<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PayProperties StructType
 * Meta informations extracted from the WSDL
 * - documentation: Контейнер PayProperties | Содержит сведения о реквизитах плательщика или получателя.
 * - type: tns:PayProperties
 * @subpackage Structs
 */
class PayProperties extends AbstractStructBase
{
    /**
     * The INN
     * Meta informations extracted from the WSDL
     * - documentation: ИНН получателя | Обязательно для кредитных организаций и платежных систем. | ИНН юридического лица
     * - minOccurs: 0
     * - length: 10
     * - pattern: ([0-9]{1}[1-9]{1}|[1-9]{1}[0-9]{1})[0-9]{8}
     * @var string
     */
    public $INN;
    /**
     * The KPP
     * Meta informations extracted from the WSDL
     * - documentation: КПП получателя | Обязательно для кредитных организаций и платежных систем. | КПП
     * - minOccurs: 0
     * - length: 9
     * - pattern: ([0-9]{1}[1-9]{1}|[1-9]{1}[0-9]{1})[0-9]{7}
     * @var string
     */
    public $KPP;
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - documentation: Наименование организации | Обязательно для кредитных организаций и платежных систем. | Строка длиной от 1 до 1000 символов
     * - minOccurs: 0
     * - maxLength: 1000
     * - minLength: 1
     * @var string
     */
    public $Name;
    /**
     * The BankBIK
     * Meta informations extracted from the WSDL
     * - documentation: БИК банка | Банковский идентификационный код (БИК)
     * - length: 9
     * - pattern: [0-9]{9}
     * @var string
     */
    public $BankBIK;
    /**
     * The SwiftCode
     * Meta informations extracted from the WSDL
     * - documentation: Код SIWFT | Код SWIFT
     * - length: 12
     * - pattern: [0-9]{12}
     * @var string
     */
    public $SwiftCode;
    /**
     * The UfkCode
     * Meta informations extracted from the WSDL
     * - documentation: Код УФК | Код УФК
     * - length: 4
     * - pattern: [0-9]{4}
     * @var string
     */
    public $UfkCode;
    /**
     * The BankName
     * Meta informations extracted from the WSDL
     * - documentation: Наименование банка | Обязательно для кредитных организаций и платежных систем. | Строка длиной от 1 до 1000 символов
     * - minOccurs: 0
     * - maxLength: 1000
     * - minLength: 1
     * @var string
     */
    public $BankName;
    /**
     * The BankCorAcc
     * Meta informations extracted from the WSDL
     * - documentation: Коррсчет банка | При наличии у банка данного реквизита заполнение поля обязательно | Строка длиной от 1 до 20 символов
     * - minOccurs: 0
     * - maxLength: 20
     * - minLength: 1
     * @var string
     */
    public $BankCorAcc;
    /**
     * The Account
     * Meta informations extracted from the WSDL
     * - documentation: Счёт | Обязательно для кредитных организаций и платежных систем. | Строка длиной от 1 до 20 символов
     * - minOccurs: 0
     * - maxLength: 20
     * - minLength: 1
     * @var string
     */
    public $Account;
    /**
     * The PersonalAccount
     * Meta informations extracted from the WSDL
     * - documentation: Лицевой счет | Строка длиной от 1 до 25 символов
     * - minOccurs: 0
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $PersonalAccount;
    /**
     * The OKATO
     * Meta informations extracted from the WSDL
     * - documentation: Код ОКАТО | Код объекта административно- территориального деления
     * - minOccurs: 0
     * - length: 11
     * - pattern: [0-9]{11}
     * @var string
     */
    public $OKATO;
    /**
     * The OKTMO
     * Meta informations extracted from the WSDL
     * - documentation: ОКТМО | Код объекта административно- территориального деления
     * - minOccurs: 0
     * - maxLength: 11
     * - minLength: 8
     * - pattern: ([0-9]{8})|([0-9]{11})
     * @var string
     */
    public $OKTMO;
    /**
     * The Kbk
     * Meta informations extracted from the WSDL
     * - documentation: КБК | Код бюджетной классификации (КБК)
     * - minOccurs: 0
     * - length: 20
     * - pattern: [0-9]{20}
     * @var string
     */
    public $Kbk;
    /**
     * Constructor method for PayProperties
     * @uses PayProperties::setINN()
     * @uses PayProperties::setKPP()
     * @uses PayProperties::setName()
     * @uses PayProperties::setBankBIK()
     * @uses PayProperties::setSwiftCode()
     * @uses PayProperties::setUfkCode()
     * @uses PayProperties::setBankName()
     * @uses PayProperties::setBankCorAcc()
     * @uses PayProperties::setAccount()
     * @uses PayProperties::setPersonalAccount()
     * @uses PayProperties::setOKATO()
     * @uses PayProperties::setOKTMO()
     * @uses PayProperties::setKbk()
     * @param string $iNN
     * @param string $kPP
     * @param string $name
     * @param string $bankBIK
     * @param string $swiftCode
     * @param string $ufkCode
     * @param string $bankName
     * @param string $bankCorAcc
     * @param string $account
     * @param string $personalAccount
     * @param string $oKATO
     * @param string $oKTMO
     * @param string $kbk
     */
    public function __construct($iNN = null, $kPP = null, $name = null, $bankBIK = null, $swiftCode = null, $ufkCode = null, $bankName = null, $bankCorAcc = null, $account = null, $personalAccount = null, $oKATO = null, $oKTMO = null, $kbk = null)
    {
        $this
            ->setINN($iNN)
            ->setKPP($kPP)
            ->setName($name)
            ->setBankBIK($bankBIK)
            ->setSwiftCode($swiftCode)
            ->setUfkCode($ufkCode)
            ->setBankName($bankName)
            ->setBankCorAcc($bankCorAcc)
            ->setAccount($account)
            ->setPersonalAccount($personalAccount)
            ->setOKATO($oKATO)
            ->setOKTMO($oKTMO)
            ->setKbk($kbk);
    }
    /**
     * Get INN value
     * @return string|null
     */
    public function getINN()
    {
        return $this->INN;
    }
    /**
     * Set INN value
     * @param string $iNN
     * @return \StructType\PayProperties
     */
    public function setINN($iNN = null)
    {
        $this->INN = $iNN;
        return $this;
    }
    /**
     * Get KPP value
     * @return string|null
     */
    public function getKPP()
    {
        return $this->KPP;
    }
    /**
     * Set KPP value
     * @param string $kPP
     * @return \StructType\PayProperties
     */
    public function setKPP($kPP = null)
    {
        $this->KPP = $kPP;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\PayProperties
     */
    public function setName($name = null)
    {
        $this->Name = $name;
        return $this;
    }
    /**
     * Get BankBIK value
     * @return string|null
     */
    public function getBankBIK()
    {
        return $this->BankBIK;
    }
    /**
     * Set BankBIK value
     * @param string $bankBIK
     * @return \StructType\PayProperties
     */
    public function setBankBIK($bankBIK = null)
    {
        $this->BankBIK = $bankBIK;
        return $this;
    }
    /**
     * Get SwiftCode value
     * @return string|null
     */
    public function getSwiftCode()
    {
        return $this->SwiftCode;
    }
    /**
     * Set SwiftCode value
     * @param string $swiftCode
     * @return \StructType\PayProperties
     */
    public function setSwiftCode($swiftCode = null)
    {
        $this->SwiftCode = $swiftCode;
        return $this;
    }
    /**
     * Get UfkCode value
     * @return string|null
     */
    public function getUfkCode()
    {
        return $this->UfkCode;
    }
    /**
     * Set UfkCode value
     * @param string $ufkCode
     * @return \StructType\PayProperties
     */
    public function setUfkCode($ufkCode = null)
    {
        $this->UfkCode = $ufkCode;
        return $this;
    }
    /**
     * Get BankName value
     * @return string|null
     */
    public function getBankName()
    {
        return $this->BankName;
    }
    /**
     * Set BankName value
     * @param string $bankName
     * @return \StructType\PayProperties
     */
    public function setBankName($bankName = null)
    {
        $this->BankName = $bankName;
        return $this;
    }
    /**
     * Get BankCorAcc value
     * @return string|null
     */
    public function getBankCorAcc()
    {
        return $this->BankCorAcc;
    }
    /**
     * Set BankCorAcc value
     * @param string $bankCorAcc
     * @return \StructType\PayProperties
     */
    public function setBankCorAcc($bankCorAcc = null)
    {
        $this->BankCorAcc = $bankCorAcc;
        return $this;
    }
    /**
     * Get Account value
     * @return string|null
     */
    public function getAccount()
    {
        return $this->Account;
    }
    /**
     * Set Account value
     * @param string $account
     * @return \StructType\PayProperties
     */
    public function setAccount($account = null)
    {
        $this->Account = $account;
        return $this;
    }
    /**
     * Get PersonalAccount value
     * @return string|null
     */
    public function getPersonalAccount()
    {
        return $this->PersonalAccount;
    }
    /**
     * Set PersonalAccount value
     * @param string $personalAccount
     * @return \StructType\PayProperties
     */
    public function setPersonalAccount($personalAccount = null)
    {
        $this->PersonalAccount = $personalAccount;
        return $this;
    }
    /**
     * Get OKATO value
     * @return string|null
     */
    public function getOKATO()
    {
        return $this->OKATO;
    }
    /**
     * Set OKATO value
     * @param string $oKATO
     * @return \StructType\PayProperties
     */
    public function setOKATO($oKATO = null)
    {
        $this->OKATO = $oKATO;
        return $this;
    }
    /**
     * Get OKTMO value
     * @return string|null
     */
    public function getOKTMO()
    {
        return $this->OKTMO;
    }
    /**
     * Set OKTMO value
     * @param string $oKTMO
     * @return \StructType\PayProperties
     */
    public function setOKTMO($oKTMO = null)
    {
        $this->OKTMO = $oKTMO;
        return $this;
    }
    /**
     * Get Kbk value
     * @return string|null
     */
    public function getKbk()
    {
        return $this->Kbk;
    }
    /**
     * Set Kbk value
     * @param string $kbk
     * @return \StructType\PayProperties
     */
    public function setKbk($kbk = null)
    {
        $this->Kbk = $kbk;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PayProperties
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
