<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Pack StructType
 * Meta informations extracted from the WSDL
 * - documentation: Режим работы пакетного обмена документами
 * @subpackage Structs
 */
class Pack extends AbstractStructBase
{
    /**
     * The MaxCount
     * Meta informations extracted from the WSDL
     * - documentation: Максимальное количество принимаемых пакетов | Целое | Целое
     * - minOccurs: 0
     * - maxInclusive: 2147483647
     * @var int
     */
    public $MaxCount;
    /**
     * The GenerationId
     * Meta informations extracted from the WSDL
     * - documentation: Номер максимального поколения пакета документов, имеющегося у получателя | Номер поколения пакета
     * - minOccurs: 0
     * @var int
     */
    public $GenerationId;
    /**
     * The FarReceiptEnabled
     * Meta informations extracted from the WSDL
     * - documentation: Поддержка квитирования доставки пакета получателю через транзитные узлы (с 20й версии) | Обертка стандартного xs:boolean |
     * Логический
     * - minOccurs: 0
     * @var bool
     */
    public $FarReceiptEnabled;
    /**
     * Constructor method for Pack
     * @uses Pack::setMaxCount()
     * @uses Pack::setGenerationId()
     * @uses Pack::setFarReceiptEnabled()
     * @param int $maxCount
     * @param int $generationId
     * @param bool $farReceiptEnabled
     */
    public function __construct($maxCount = null, $generationId = null, $farReceiptEnabled = null)
    {
        $this
            ->setMaxCount($maxCount)
            ->setGenerationId($generationId)
            ->setFarReceiptEnabled($farReceiptEnabled);
    }
    /**
     * Get MaxCount value
     * @return int|null
     */
    public function getMaxCount()
    {
        return $this->MaxCount;
    }
    /**
     * Set MaxCount value
     * @param int $maxCount
     * @return \StructType\Pack
     */
    public function setMaxCount($maxCount = null)
    {
        $this->MaxCount = $maxCount;
        return $this;
    }
    /**
     * Get GenerationId value
     * @return int|null
     */
    public function getGenerationId()
    {
        return $this->GenerationId;
    }
    /**
     * Set GenerationId value
     * @param int $generationId
     * @return \StructType\Pack
     */
    public function setGenerationId($generationId = null)
    {
        $this->GenerationId = $generationId;
        return $this;
    }
    /**
     * Get FarReceiptEnabled value
     * @return bool|null
     */
    public function getFarReceiptEnabled()
    {
        return $this->FarReceiptEnabled;
    }
    /**
     * Set FarReceiptEnabled value
     * @param bool $farReceiptEnabled
     * @return \StructType\Pack
     */
    public function setFarReceiptEnabled($farReceiptEnabled = null)
    {
        $this->FarReceiptEnabled = $farReceiptEnabled;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Pack
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
