<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OutgoingForcedExecDocument StructType
 * Meta informations extracted from the WSDL
 * - documentation: Исходящий документ принудительного исполнения | используется для передачи документов внешним контрагентам
 * - type: tns:OutgoingForcedExecDocument
 * @subpackage Structs
 */
class OutgoingForcedExecDocument extends AbstractStructBase
{
    /**
     * The InternalKey
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор документа в АИС ФССП России | Ключ объекта, присвоенний информационной системой ФССП РФ при создании объекта или
     * при получении объекта от контрагента
     * - maxInclusive: 9223372036854775807
     * - minInclusive: -9223372036854775808
     * @var int
     */
    public $InternalKey;
    /**
     * The IncomingDocKey
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор входящего документа | Идентификатор документа, направленного ранее внешним контрагентов в АИС ФССП России.
     * Обязательно, если документ направляется в ответ на ранее принятый от внешнего контрагента документ | Идентификатор объекта,
     * присвоенный объекту АИС внешнего контрагентом (ФНС, ПФР и прочие). Данный идентификатор должен быть уникальным для типа
     * идентифицируемого документа в пространстве обмена данными с конкретным внешним контрагентом.
     * - minOccurs: 0
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $IncomingDocKey;
    /**
     * The ProcDocRef
     * Meta informations extracted from the WSDL
     * - documentation: Постановление СПИ | Обязательно для документов: - Уведомление о готовности к реализации арестованного имущества.
     * - minOccurs: 0
     * @var \StructType\DocRefType
     */
    public $ProcDocRef;
    /**
     * The SenderProperties
     * Meta informations extracted from the WSDL
     * - documentation: Реквизиты СПИ
     * - minOccurs: 0
     * @var \StructType\SenderSPIType
     */
    public $SenderProperties;
    /**
     * The RejectReason
     * Meta informations extracted from the WSDL
     * - documentation: Причина отказа | Обязательно для документа: Уведомления об отказе в предоставлении гос.услуги
     * - minOccurs: 0
     * @var string
     */
    public $RejectReason;
    /**
     * The IP
     * Meta informations extracted from the WSDL
     * - documentation: Исполнительное производство
     * - minOccurs: 0
     * @var \StructType\IP
     */
    public $IP;
    /**
     * The DocumentData
     * Meta informations extracted from the WSDL
     * - documentation: Документ в формате ПИЭВ
     * @var \StructType\EmbeddedDocumentType
     */
    public $DocumentData;
    /**
     * Constructor method for OutgoingForcedExecDocument
     * @uses OutgoingForcedExecDocument::setInternalKey()
     * @uses OutgoingForcedExecDocument::setIncomingDocKey()
     * @uses OutgoingForcedExecDocument::setProcDocRef()
     * @uses OutgoingForcedExecDocument::setSenderProperties()
     * @uses OutgoingForcedExecDocument::setRejectReason()
     * @uses OutgoingForcedExecDocument::setIP()
     * @uses OutgoingForcedExecDocument::setDocumentData()
     * @param int $internalKey
     * @param string $incomingDocKey
     * @param \StructType\DocRefType $procDocRef
     * @param \StructType\SenderSPIType $senderProperties
     * @param string $rejectReason
     * @param \StructType\IP $iP
     * @param \StructType\EmbeddedDocumentType $documentData
     */
    public function __construct($internalKey = null, $incomingDocKey = null, \StructType\DocRefType $procDocRef = null, \StructType\SenderSPIType $senderProperties = null, $rejectReason = null, \StructType\IP $iP = null, \StructType\EmbeddedDocumentType $documentData = null)
    {
        $this
            ->setInternalKey($internalKey)
            ->setIncomingDocKey($incomingDocKey)
            ->setProcDocRef($procDocRef)
            ->setSenderProperties($senderProperties)
            ->setRejectReason($rejectReason)
            ->setIP($iP)
            ->setDocumentData($documentData);
    }
    /**
     * Get InternalKey value
     * @return int|null
     */
    public function getInternalKey()
    {
        return $this->InternalKey;
    }
    /**
     * Set InternalKey value
     * @param int $internalKey
     * @return \StructType\OutgoingForcedExecDocument
     */
    public function setInternalKey($internalKey = null)
    {
        $this->InternalKey = $internalKey;
        return $this;
    }
    /**
     * Get IncomingDocKey value
     * @return string|null
     */
    public function getIncomingDocKey()
    {
        return $this->IncomingDocKey;
    }
    /**
     * Set IncomingDocKey value
     * @param string $incomingDocKey
     * @return \StructType\OutgoingForcedExecDocument
     */
    public function setIncomingDocKey($incomingDocKey = null)
    {
        $this->IncomingDocKey = $incomingDocKey;
        return $this;
    }
    /**
     * Get ProcDocRef value
     * @return \StructType\DocRefType|null
     */
    public function getProcDocRef()
    {
        return $this->ProcDocRef;
    }
    /**
     * Set ProcDocRef value
     * @param \StructType\DocRefType $procDocRef
     * @return \StructType\OutgoingForcedExecDocument
     */
    public function setProcDocRef(\StructType\DocRefType $procDocRef = null)
    {
        $this->ProcDocRef = $procDocRef;
        return $this;
    }
    /**
     * Get SenderProperties value
     * @return \StructType\SenderSPIType|null
     */
    public function getSenderProperties()
    {
        return $this->SenderProperties;
    }
    /**
     * Set SenderProperties value
     * @param \StructType\SenderSPIType $senderProperties
     * @return \StructType\OutgoingForcedExecDocument
     */
    public function setSenderProperties(\StructType\SenderSPIType $senderProperties = null)
    {
        $this->SenderProperties = $senderProperties;
        return $this;
    }
    /**
     * Get RejectReason value
     * @return string|null
     */
    public function getRejectReason()
    {
        return $this->RejectReason;
    }
    /**
     * Set RejectReason value
     * @uses \EnumType\RejectReasonType::valueIsValid()
     * @uses \EnumType\RejectReasonType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $rejectReason
     * @return \StructType\OutgoingForcedExecDocument
     */
    public function setRejectReason($rejectReason = null)
    {
        $this->RejectReason = $rejectReason;
        return $this;
    }
    /**
     * Get IP value
     * @return \StructType\IP|null
     */
    public function getIP()
    {
        return $this->IP;
    }
    /**
     * Set IP value
     * @param \StructType\IP $iP
     * @return \StructType\OutgoingForcedExecDocument
     */
    public function setIP(\StructType\IP $iP = null)
    {
        $this->IP = $iP;
        return $this;
    }
    /**
     * Get DocumentData value
     * @return \StructType\EmbeddedDocumentType|null
     */
    public function getDocumentData()
    {
        return $this->DocumentData;
    }
    /**
     * Set DocumentData value
     * @param \StructType\EmbeddedDocumentType $documentData
     * @return \StructType\OutgoingForcedExecDocument
     */
    public function setDocumentData(\StructType\EmbeddedDocumentType $documentData = null)
    {
        $this->DocumentData = $documentData;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OutgoingForcedExecDocument
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
