<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OutgoingArbitraryDocument StructType
 * Meta informations extracted from the WSDL
 * - documentation: Ответ на электронное обращение
 * - type: tns:OutgoingArbitraryDocument
 * @subpackage Structs
 */
class OutgoingArbitraryDocument extends AbstractStructBase
{
    /**
     * The InternalKey
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор документа в АИС ФССП России | Ключ объекта, присвоенний информационной системой ФССП РФ при создании объекта или
     * при получении объекта от контрагента
     * - maxInclusive: 9223372036854775807
     * - minInclusive: -9223372036854775808
     * @var int
     */
    public $InternalKey;
    /**
     * The IncomingDocKey
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор входящего документа | Идентификатор документа, направленного ранее внешним контрагентов в АИС ФССП России.
     * Обязательно, если документ направляется в ответ на ранее принятый от внешнего контрагента документ | Идентификатор объекта,
     * присвоенный объекту АИС внешнего контрагентом (ФНС, ПФР и прочие). Данный идентификатор должен быть уникальным для типа
     * идентифицируемого документа в пространстве обмена данными с конкретным внешним контрагентом.
     * - minOccurs: 0
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $IncomingDocKey;
    /**
     * The DocType
     * Meta informations extracted from the WSDL
     * - documentation: Тип документа | Тип документа АИС ФССП России (тип документа ПКОСП) | Тип документа электронного документооборота | NSI_Document |
     * Наименование объекта NCORE
     * - minOccurs: 0
     * - maxLength: 31 | 31
     * - minLength: 1 | 1
     * @var string
     */
    public $DocType;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - documentation: Описание документа | Строка длиной от 1 до 50 символов
     * - minOccurs: 0
     * - maxLength: 50
     * - minLength: 1
     * @var string
     */
    public $Description;
    /**
     * The DocDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата документа | Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $DocDate;
    /**
     * The DocNumber
     * Meta informations extracted from the WSDL
     * - documentation: Номер документа | Номер документа
     * - minOccurs: 0
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $DocNumber;
    /**
     * The SenderProperties
     * Meta informations extracted from the WSDL
     * - documentation: Реквизиты СПИ
     * - minOccurs: 0
     * @var \StructType\SenderContragentType
     */
    public $SenderProperties;
    /**
     * The Attachments
     * Meta informations extracted from the WSDL
     * - documentation: Вложения
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\AttachmentType[]
     */
    public $Attachments;
    /**
     * Constructor method for OutgoingArbitraryDocument
     * @uses OutgoingArbitraryDocument::setInternalKey()
     * @uses OutgoingArbitraryDocument::setIncomingDocKey()
     * @uses OutgoingArbitraryDocument::setDocType()
     * @uses OutgoingArbitraryDocument::setDescription()
     * @uses OutgoingArbitraryDocument::setDocDate()
     * @uses OutgoingArbitraryDocument::setDocNumber()
     * @uses OutgoingArbitraryDocument::setSenderProperties()
     * @uses OutgoingArbitraryDocument::setAttachments()
     * @param int $internalKey
     * @param string $incomingDocKey
     * @param string $docType
     * @param string $description
     * @param string $docDate
     * @param string $docNumber
     * @param \StructType\SenderContragentType $senderProperties
     * @param \StructType\AttachmentType[] $attachments
     */
    public function __construct($internalKey = null, $incomingDocKey = null, $docType = null, $description = null, $docDate = null, $docNumber = null, \StructType\SenderContragentType $senderProperties = null, array $attachments = array())
    {
        $this
            ->setInternalKey($internalKey)
            ->setIncomingDocKey($incomingDocKey)
            ->setDocType($docType)
            ->setDescription($description)
            ->setDocDate($docDate)
            ->setDocNumber($docNumber)
            ->setSenderProperties($senderProperties)
            ->setAttachments($attachments);
    }
    /**
     * Get InternalKey value
     * @return int|null
     */
    public function getInternalKey()
    {
        return $this->InternalKey;
    }
    /**
     * Set InternalKey value
     * @param int $internalKey
     * @return \StructType\OutgoingArbitraryDocument
     */
    public function setInternalKey($internalKey = null)
    {
        $this->InternalKey = $internalKey;
        return $this;
    }
    /**
     * Get IncomingDocKey value
     * @return string|null
     */
    public function getIncomingDocKey()
    {
        return $this->IncomingDocKey;
    }
    /**
     * Set IncomingDocKey value
     * @param string $incomingDocKey
     * @return \StructType\OutgoingArbitraryDocument
     */
    public function setIncomingDocKey($incomingDocKey = null)
    {
        $this->IncomingDocKey = $incomingDocKey;
        return $this;
    }
    /**
     * Get DocType value
     * @return string|null
     */
    public function getDocType()
    {
        return $this->DocType;
    }
    /**
     * Set DocType value
     * @param string $docType
     * @return \StructType\OutgoingArbitraryDocument
     */
    public function setDocType($docType = null)
    {
        $this->DocType = $docType;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\OutgoingArbitraryDocument
     */
    public function setDescription($description = null)
    {
        $this->Description = $description;
        return $this;
    }
    /**
     * Get DocDate value
     * @return string|null
     */
    public function getDocDate()
    {
        return $this->DocDate;
    }
    /**
     * Set DocDate value
     * @param string $docDate
     * @return \StructType\OutgoingArbitraryDocument
     */
    public function setDocDate($docDate = null)
    {
        $this->DocDate = $docDate;
        return $this;
    }
    /**
     * Get DocNumber value
     * @return string|null
     */
    public function getDocNumber()
    {
        return $this->DocNumber;
    }
    /**
     * Set DocNumber value
     * @param string $docNumber
     * @return \StructType\OutgoingArbitraryDocument
     */
    public function setDocNumber($docNumber = null)
    {
        $this->DocNumber = $docNumber;
        return $this;
    }
    /**
     * Get SenderProperties value
     * @return \StructType\SenderContragentType|null
     */
    public function getSenderProperties()
    {
        return $this->SenderProperties;
    }
    /**
     * Set SenderProperties value
     * @param \StructType\SenderContragentType $senderProperties
     * @return \StructType\OutgoingArbitraryDocument
     */
    public function setSenderProperties(\StructType\SenderContragentType $senderProperties = null)
    {
        $this->SenderProperties = $senderProperties;
        return $this;
    }
    /**
     * Get Attachments value
     * @return \StructType\AttachmentType[]|null
     */
    public function getAttachments()
    {
        return $this->Attachments;
    }
    /**
     * Set Attachments value
     * @throws \InvalidArgumentException
     * @param \StructType\AttachmentType[] $attachments
     * @return \StructType\OutgoingArbitraryDocument
     */
    public function setAttachments(array $attachments = array())
    {
        $this->Attachments = $attachments;
        return $this;
    }
    /**
     * Add item to Attachments value
     * @throws \InvalidArgumentException
     * @param \StructType\AttachmentType $item
     * @return \StructType\OutgoingArbitraryDocument
     */
    public function addToAttachments(\StructType\AttachmentType $item)
    {
        $this->Attachments[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OutgoingArbitraryDocument
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
