<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OspProperty StructType
 * Meta informations extracted from the WSDL
 * - documentation: Контейнер OspProperty «Отдел СП» | Содержит сведения о расчетном счете отдела СП
 * - type: tns:OspProperty
 * @subpackage Structs
 */
class OspProperty extends AbstractStructBase
{
    /**
     * The InternalKey
     * Meta informations extracted from the WSDL
     * - documentation: Ключ ФССП России | Уникальный идентификатор объекта, присвоенный АИС ФССП России | Ключ объекта, присвоенний информационной
     * системой ФССП РФ при создании объекта или при получении объекта от контрагента
     * - maxInclusive: 9223372036854775807
     * - minInclusive: -9223372036854775808
     * @var int
     */
    public $InternalKey;
    /**
     * The OspCode
     * Meta informations extracted from the WSDL
     * - documentation: Код отдела СП | Ведомственный классификатор отделов судебных приставов | NSI_Departments
     * - length: 5
     * - pattern: [0-9]{5}
     * @var string
     */
    public $OspCode;
    /**
     * The BeginDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата начала действия | Дата начала действия реквизитов, Неуказанное значение сигнализирует о том, что реквизиты действуют на
     * момент ответа на запрос | Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $BeginDate;
    /**
     * The EndDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата окончания действия | Дата окончания действия реквизитов. Неуказанное значение сигнализирует о том, что срок окончения
     * действия реквизитов неизвестен | Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $EndDate;
    /**
     * The DivName
     * Meta informations extracted from the WSDL
     * - documentation: Наименование подразделения | Строка длиной от 1 до 1000 символов
     * - maxLength: 1000
     * - minLength: 1
     * @var string
     */
    public $DivName;
    /**
     * The DivFullName
     * Meta informations extracted from the WSDL
     * - documentation: Полное наименование подразделения | Строка длиной от 1 до 1000 символов
     * - maxLength: 1000
     * - minLength: 1
     * @var string
     */
    public $DivFullName;
    /**
     * The DivHeadName
     * Meta informations extracted from the WSDL
     * - documentation: Руководитель | Полное имя физического лица (фамилия, имя, отчество)
     * - maxLength: 100
     * - minLength: 1
     * @var string
     */
    public $DivHeadName;
    /**
     * The DivHeadPostName
     * Meta informations extracted from the WSDL
     * - documentation: Должность руководителя | Строка длиной от 1 до 1000 символов
     * - maxLength: 1000
     * - minLength: 1
     * @var string
     */
    public $DivHeadPostName;
    /**
     * The DivDeputyHeadName
     * Meta informations extracted from the WSDL
     * - documentation: Заместитель руководителя | Полное имя физического лица (фамилия, имя, отчество)
     * - minOccurs: 0
     * - maxLength: 100
     * - minLength: 1
     * @var string
     */
    public $DivDeputyHeadName;
    /**
     * The DivDeputyHeadPostName
     * Meta informations extracted from the WSDL
     * - documentation: Должность заместитель руководителя | Строка длиной от 1 до 1000 символов
     * - minOccurs: 0
     * - maxLength: 1000
     * - minLength: 1
     * @var string
     */
    public $DivDeputyHeadPostName;
    /**
     * The DivAdr
     * Meta informations extracted from the WSDL
     * - documentation: Адрес юридический | Строка длиной от 1 до 300 символов
     * - maxLength: 300
     * - minLength: 1
     * @var string
     */
    public $DivAdr;
    /**
     * The DivEmail
     * Meta informations extracted from the WSDL
     * - documentation: Адрес электронной почты | Адрес электронной почты
     * - maxLength: 100
     * - minLength: 1
     * @var string
     */
    public $DivEmail;
    /**
     * The DivTel
     * Meta informations extracted from the WSDL
     * - documentation: Телефон ССП | Номер телефона
     * - minOccurs: 0
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $DivTel;
    /**
     * The DivTelReception
     * Meta informations extracted from the WSDL
     * - documentation: Телефон приемной | Номер телефона
     * - minOccurs: 0
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $DivTelReception;
    /**
     * The DivFax
     * Meta informations extracted from the WSDL
     * - documentation: Факс | Номер телефона
     * - minOccurs: 0
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $DivFax;
    /**
     * The DivOfficeHours
     * Meta informations extracted from the WSDL
     * - documentation: Часы работы | Строка длиной от 1 до 1000 символов
     * - minOccurs: 0
     * - maxLength: 1000
     * - minLength: 1
     * @var string
     */
    public $DivOfficeHours;
    /**
     * The DivReceptionHours
     * Meta informations extracted from the WSDL
     * - documentation: Часы приема | Строка длиной от 1 до 1000 символов
     * - minOccurs: 0
     * - maxLength: 1000
     * - minLength: 1
     * @var string
     */
    public $DivReceptionHours;
    /**
     * The RecpName
     * Meta informations extracted from the WSDL
     * - documentation: Наименование ОСП для платежей | Строка длиной от 1 до 160 символов
     * - maxLength: 160
     * - minLength: 1
     * @var string
     */
    public $RecpName;
    /**
     * The RecpAdr
     * Meta informations extracted from the WSDL
     * - documentation: Адрес получателя | Строка длиной от 1 до 200 символов
     * - maxLength: 200
     * - minLength: 1
     * @var string
     */
    public $RecpAdr;
    /**
     * The RecpBank
     * Meta informations extracted from the WSDL
     * - documentation: Банк получателя. | Строка длиной от 1 до 80 символов
     * - maxLength: 80
     * - minLength: 1
     * @var string
     */
    public $RecpBank;
    /**
     * The RecpBIK
     * Meta informations extracted from the WSDL
     * - documentation: БИК банка получателя. | Банковский идентификационный код (БИК)
     * - length: 9
     * - pattern: [0-9]{9}
     * @var string
     */
    public $RecpBIK;
    /**
     * The RecpCnt
     * Meta informations extracted from the WSDL
     * - documentation: Расчетный счет. | Строка длиной от 1 до 20 символов
     * - maxLength: 20
     * - minLength: 1
     * @var string
     */
    public $RecpCnt;
    /**
     * The RecpINN
     * Meta informations extracted from the WSDL
     * - documentation: ИНН получателя. | ИНН юридического лица
     * - length: 10
     * - pattern: ([0-9]{1}[1-9]{1}|[1-9]{1}[0-9]{1})[0-9]{8}
     * @var string
     */
    public $RecpINN;
    /**
     * The RecpKPP
     * Meta informations extracted from the WSDL
     * - documentation: КПП получателя. | КПП
     * - length: 9
     * - pattern: ([0-9]{1}[1-9]{1}|[1-9]{1}[0-9]{1})[0-9]{7}
     * @var string
     */
    public $RecpKPP;
    /**
     * The OKATO
     * Meta informations extracted from the WSDL
     * - documentation: Код ОКАТО | Код объекта административно- территориального деления
     * - minOccurs: 0
     * - length: 11
     * - pattern: [0-9]{11}
     * @var string
     */
    public $OKATO;
    /**
     * The OKTMO
     * Meta informations extracted from the WSDL
     * - documentation: ОКТМО | Код объекта административно- территориального деления
     * - minOccurs: 0
     * - maxLength: 11
     * - minLength: 8
     * - pattern: ([0-9]{8})|([0-9]{11})
     * @var string
     */
    public $OKTMO;
    /**
     * The Address
     * Meta informations extracted from the WSDL
     * - documentation: Адрес подразделения | Строка длиной от 1 до 300 символов
     * - minOccurs: 0
     * - maxLength: 300
     * - minLength: 1
     * @var string
     */
    public $Address;
    /**
     * The Details
     * Meta informations extracted from the WSDL
     * - documentation: Сведения об отделе
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\OspDetail[]
     */
    public $Details;
    /**
     * Constructor method for OspProperty
     * @uses OspProperty::setInternalKey()
     * @uses OspProperty::setOspCode()
     * @uses OspProperty::setBeginDate()
     * @uses OspProperty::setEndDate()
     * @uses OspProperty::setDivName()
     * @uses OspProperty::setDivFullName()
     * @uses OspProperty::setDivHeadName()
     * @uses OspProperty::setDivHeadPostName()
     * @uses OspProperty::setDivDeputyHeadName()
     * @uses OspProperty::setDivDeputyHeadPostName()
     * @uses OspProperty::setDivAdr()
     * @uses OspProperty::setDivEmail()
     * @uses OspProperty::setDivTel()
     * @uses OspProperty::setDivTelReception()
     * @uses OspProperty::setDivFax()
     * @uses OspProperty::setDivOfficeHours()
     * @uses OspProperty::setDivReceptionHours()
     * @uses OspProperty::setRecpName()
     * @uses OspProperty::setRecpAdr()
     * @uses OspProperty::setRecpBank()
     * @uses OspProperty::setRecpBIK()
     * @uses OspProperty::setRecpCnt()
     * @uses OspProperty::setRecpINN()
     * @uses OspProperty::setRecpKPP()
     * @uses OspProperty::setOKATO()
     * @uses OspProperty::setOKTMO()
     * @uses OspProperty::setAddress()
     * @uses OspProperty::setDetails()
     * @param int $internalKey
     * @param string $ospCode
     * @param string $beginDate
     * @param string $endDate
     * @param string $divName
     * @param string $divFullName
     * @param string $divHeadName
     * @param string $divHeadPostName
     * @param string $divDeputyHeadName
     * @param string $divDeputyHeadPostName
     * @param string $divAdr
     * @param string $divEmail
     * @param string $divTel
     * @param string $divTelReception
     * @param string $divFax
     * @param string $divOfficeHours
     * @param string $divReceptionHours
     * @param string $recpName
     * @param string $recpAdr
     * @param string $recpBank
     * @param string $recpBIK
     * @param string $recpCnt
     * @param string $recpINN
     * @param string $recpKPP
     * @param string $oKATO
     * @param string $oKTMO
     * @param string $address
     * @param \StructType\OspDetail[] $details
     */
    public function __construct($internalKey = null, $ospCode = null, $beginDate = null, $endDate = null, $divName = null, $divFullName = null, $divHeadName = null, $divHeadPostName = null, $divDeputyHeadName = null, $divDeputyHeadPostName = null, $divAdr = null, $divEmail = null, $divTel = null, $divTelReception = null, $divFax = null, $divOfficeHours = null, $divReceptionHours = null, $recpName = null, $recpAdr = null, $recpBank = null, $recpBIK = null, $recpCnt = null, $recpINN = null, $recpKPP = null, $oKATO = null, $oKTMO = null, $address = null, array $details = array())
    {
        $this
            ->setInternalKey($internalKey)
            ->setOspCode($ospCode)
            ->setBeginDate($beginDate)
            ->setEndDate($endDate)
            ->setDivName($divName)
            ->setDivFullName($divFullName)
            ->setDivHeadName($divHeadName)
            ->setDivHeadPostName($divHeadPostName)
            ->setDivDeputyHeadName($divDeputyHeadName)
            ->setDivDeputyHeadPostName($divDeputyHeadPostName)
            ->setDivAdr($divAdr)
            ->setDivEmail($divEmail)
            ->setDivTel($divTel)
            ->setDivTelReception($divTelReception)
            ->setDivFax($divFax)
            ->setDivOfficeHours($divOfficeHours)
            ->setDivReceptionHours($divReceptionHours)
            ->setRecpName($recpName)
            ->setRecpAdr($recpAdr)
            ->setRecpBank($recpBank)
            ->setRecpBIK($recpBIK)
            ->setRecpCnt($recpCnt)
            ->setRecpINN($recpINN)
            ->setRecpKPP($recpKPP)
            ->setOKATO($oKATO)
            ->setOKTMO($oKTMO)
            ->setAddress($address)
            ->setDetails($details);
    }
    /**
     * Get InternalKey value
     * @return int|null
     */
    public function getInternalKey()
    {
        return $this->InternalKey;
    }
    /**
     * Set InternalKey value
     * @param int $internalKey
     * @return \StructType\OspProperty
     */
    public function setInternalKey($internalKey = null)
    {
        $this->InternalKey = $internalKey;
        return $this;
    }
    /**
     * Get OspCode value
     * @return string|null
     */
    public function getOspCode()
    {
        return $this->OspCode;
    }
    /**
     * Set OspCode value
     * @param string $ospCode
     * @return \StructType\OspProperty
     */
    public function setOspCode($ospCode = null)
    {
        $this->OspCode = $ospCode;
        return $this;
    }
    /**
     * Get BeginDate value
     * @return string|null
     */
    public function getBeginDate()
    {
        return $this->BeginDate;
    }
    /**
     * Set BeginDate value
     * @param string $beginDate
     * @return \StructType\OspProperty
     */
    public function setBeginDate($beginDate = null)
    {
        $this->BeginDate = $beginDate;
        return $this;
    }
    /**
     * Get EndDate value
     * @return string|null
     */
    public function getEndDate()
    {
        return $this->EndDate;
    }
    /**
     * Set EndDate value
     * @param string $endDate
     * @return \StructType\OspProperty
     */
    public function setEndDate($endDate = null)
    {
        $this->EndDate = $endDate;
        return $this;
    }
    /**
     * Get DivName value
     * @return string|null
     */
    public function getDivName()
    {
        return $this->DivName;
    }
    /**
     * Set DivName value
     * @param string $divName
     * @return \StructType\OspProperty
     */
    public function setDivName($divName = null)
    {
        $this->DivName = $divName;
        return $this;
    }
    /**
     * Get DivFullName value
     * @return string|null
     */
    public function getDivFullName()
    {
        return $this->DivFullName;
    }
    /**
     * Set DivFullName value
     * @param string $divFullName
     * @return \StructType\OspProperty
     */
    public function setDivFullName($divFullName = null)
    {
        $this->DivFullName = $divFullName;
        return $this;
    }
    /**
     * Get DivHeadName value
     * @return string|null
     */
    public function getDivHeadName()
    {
        return $this->DivHeadName;
    }
    /**
     * Set DivHeadName value
     * @param string $divHeadName
     * @return \StructType\OspProperty
     */
    public function setDivHeadName($divHeadName = null)
    {
        $this->DivHeadName = $divHeadName;
        return $this;
    }
    /**
     * Get DivHeadPostName value
     * @return string|null
     */
    public function getDivHeadPostName()
    {
        return $this->DivHeadPostName;
    }
    /**
     * Set DivHeadPostName value
     * @param string $divHeadPostName
     * @return \StructType\OspProperty
     */
    public function setDivHeadPostName($divHeadPostName = null)
    {
        $this->DivHeadPostName = $divHeadPostName;
        return $this;
    }
    /**
     * Get DivDeputyHeadName value
     * @return string|null
     */
    public function getDivDeputyHeadName()
    {
        return $this->DivDeputyHeadName;
    }
    /**
     * Set DivDeputyHeadName value
     * @param string $divDeputyHeadName
     * @return \StructType\OspProperty
     */
    public function setDivDeputyHeadName($divDeputyHeadName = null)
    {
        $this->DivDeputyHeadName = $divDeputyHeadName;
        return $this;
    }
    /**
     * Get DivDeputyHeadPostName value
     * @return string|null
     */
    public function getDivDeputyHeadPostName()
    {
        return $this->DivDeputyHeadPostName;
    }
    /**
     * Set DivDeputyHeadPostName value
     * @param string $divDeputyHeadPostName
     * @return \StructType\OspProperty
     */
    public function setDivDeputyHeadPostName($divDeputyHeadPostName = null)
    {
        $this->DivDeputyHeadPostName = $divDeputyHeadPostName;
        return $this;
    }
    /**
     * Get DivAdr value
     * @return string|null
     */
    public function getDivAdr()
    {
        return $this->DivAdr;
    }
    /**
     * Set DivAdr value
     * @param string $divAdr
     * @return \StructType\OspProperty
     */
    public function setDivAdr($divAdr = null)
    {
        $this->DivAdr = $divAdr;
        return $this;
    }
    /**
     * Get DivEmail value
     * @return string|null
     */
    public function getDivEmail()
    {
        return $this->DivEmail;
    }
    /**
     * Set DivEmail value
     * @param string $divEmail
     * @return \StructType\OspProperty
     */
    public function setDivEmail($divEmail = null)
    {
        $this->DivEmail = $divEmail;
        return $this;
    }
    /**
     * Get DivTel value
     * @return string|null
     */
    public function getDivTel()
    {
        return $this->DivTel;
    }
    /**
     * Set DivTel value
     * @param string $divTel
     * @return \StructType\OspProperty
     */
    public function setDivTel($divTel = null)
    {
        $this->DivTel = $divTel;
        return $this;
    }
    /**
     * Get DivTelReception value
     * @return string|null
     */
    public function getDivTelReception()
    {
        return $this->DivTelReception;
    }
    /**
     * Set DivTelReception value
     * @param string $divTelReception
     * @return \StructType\OspProperty
     */
    public function setDivTelReception($divTelReception = null)
    {
        $this->DivTelReception = $divTelReception;
        return $this;
    }
    /**
     * Get DivFax value
     * @return string|null
     */
    public function getDivFax()
    {
        return $this->DivFax;
    }
    /**
     * Set DivFax value
     * @param string $divFax
     * @return \StructType\OspProperty
     */
    public function setDivFax($divFax = null)
    {
        $this->DivFax = $divFax;
        return $this;
    }
    /**
     * Get DivOfficeHours value
     * @return string|null
     */
    public function getDivOfficeHours()
    {
        return $this->DivOfficeHours;
    }
    /**
     * Set DivOfficeHours value
     * @param string $divOfficeHours
     * @return \StructType\OspProperty
     */
    public function setDivOfficeHours($divOfficeHours = null)
    {
        $this->DivOfficeHours = $divOfficeHours;
        return $this;
    }
    /**
     * Get DivReceptionHours value
     * @return string|null
     */
    public function getDivReceptionHours()
    {
        return $this->DivReceptionHours;
    }
    /**
     * Set DivReceptionHours value
     * @param string $divReceptionHours
     * @return \StructType\OspProperty
     */
    public function setDivReceptionHours($divReceptionHours = null)
    {
        $this->DivReceptionHours = $divReceptionHours;
        return $this;
    }
    /**
     * Get RecpName value
     * @return string|null
     */
    public function getRecpName()
    {
        return $this->RecpName;
    }
    /**
     * Set RecpName value
     * @param string $recpName
     * @return \StructType\OspProperty
     */
    public function setRecpName($recpName = null)
    {
        $this->RecpName = $recpName;
        return $this;
    }
    /**
     * Get RecpAdr value
     * @return string|null
     */
    public function getRecpAdr()
    {
        return $this->RecpAdr;
    }
    /**
     * Set RecpAdr value
     * @param string $recpAdr
     * @return \StructType\OspProperty
     */
    public function setRecpAdr($recpAdr = null)
    {
        $this->RecpAdr = $recpAdr;
        return $this;
    }
    /**
     * Get RecpBank value
     * @return string|null
     */
    public function getRecpBank()
    {
        return $this->RecpBank;
    }
    /**
     * Set RecpBank value
     * @param string $recpBank
     * @return \StructType\OspProperty
     */
    public function setRecpBank($recpBank = null)
    {
        $this->RecpBank = $recpBank;
        return $this;
    }
    /**
     * Get RecpBIK value
     * @return string|null
     */
    public function getRecpBIK()
    {
        return $this->RecpBIK;
    }
    /**
     * Set RecpBIK value
     * @param string $recpBIK
     * @return \StructType\OspProperty
     */
    public function setRecpBIK($recpBIK = null)
    {
        $this->RecpBIK = $recpBIK;
        return $this;
    }
    /**
     * Get RecpCnt value
     * @return string|null
     */
    public function getRecpCnt()
    {
        return $this->RecpCnt;
    }
    /**
     * Set RecpCnt value
     * @param string $recpCnt
     * @return \StructType\OspProperty
     */
    public function setRecpCnt($recpCnt = null)
    {
        $this->RecpCnt = $recpCnt;
        return $this;
    }
    /**
     * Get RecpINN value
     * @return string|null
     */
    public function getRecpINN()
    {
        return $this->RecpINN;
    }
    /**
     * Set RecpINN value
     * @param string $recpINN
     * @return \StructType\OspProperty
     */
    public function setRecpINN($recpINN = null)
    {
        $this->RecpINN = $recpINN;
        return $this;
    }
    /**
     * Get RecpKPP value
     * @return string|null
     */
    public function getRecpKPP()
    {
        return $this->RecpKPP;
    }
    /**
     * Set RecpKPP value
     * @param string $recpKPP
     * @return \StructType\OspProperty
     */
    public function setRecpKPP($recpKPP = null)
    {
        $this->RecpKPP = $recpKPP;
        return $this;
    }
    /**
     * Get OKATO value
     * @return string|null
     */
    public function getOKATO()
    {
        return $this->OKATO;
    }
    /**
     * Set OKATO value
     * @param string $oKATO
     * @return \StructType\OspProperty
     */
    public function setOKATO($oKATO = null)
    {
        $this->OKATO = $oKATO;
        return $this;
    }
    /**
     * Get OKTMO value
     * @return string|null
     */
    public function getOKTMO()
    {
        return $this->OKTMO;
    }
    /**
     * Set OKTMO value
     * @param string $oKTMO
     * @return \StructType\OspProperty
     */
    public function setOKTMO($oKTMO = null)
    {
        $this->OKTMO = $oKTMO;
        return $this;
    }
    /**
     * Get Address value
     * @return string|null
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @param string $address
     * @return \StructType\OspProperty
     */
    public function setAddress($address = null)
    {
        $this->Address = $address;
        return $this;
    }
    /**
     * Get Details value
     * @return \StructType\OspDetail[]|null
     */
    public function getDetails()
    {
        return $this->Details;
    }
    /**
     * Set Details value
     * @throws \InvalidArgumentException
     * @param \StructType\OspDetail[] $details
     * @return \StructType\OspProperty
     */
    public function setDetails(array $details = array())
    {
        $this->Details = $details;
        return $this;
    }
    /**
     * Add item to Details value
     * @throws \InvalidArgumentException
     * @param \StructType\OspDetail $item
     * @return \StructType\OspProperty
     */
    public function addToDetails(\StructType\OspDetail $item)
    {
        $this->Details[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OspProperty
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
