<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OspProperties StructType
 * Meta informations extracted from the WSDL
 * - documentation: Документ OspProperties «Реквизиты ОСП» | Содержит список сведений о расчетных счетах ОСП для зачисления платежей | ЭП
 * - type: tns:OspProperties
 * @subpackage Structs
 */
class OspProperties extends AbstractStructBase
{
    /**
     * The InternalKey
     * Meta informations extracted from the WSDL
     * - documentation: Ключ ФССП России | Идентификатор объекта, присвоенный АИС ФССП России | Ключ объекта, присвоенний информационной системой ФССП
     * РФ при создании объекта или при получении объекта от контрагента
     * - maxInclusive: 9223372036854775807
     * - minInclusive: -9223372036854775808
     * @var int
     */
    public $InternalKey;
    /**
     * The RequestExternalKey
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор запроса АИС ВК | Идентификатор запроса списка реквизитов ОСП, полученный ранее от АИС внешнего контрагента |
     * Идентификатор объекта, присвоенный объекту АИС внешнего контрагентом (ФНС, ПФР и прочие). Данный идентификатор должен быть уникальным
     * для типа идентифицируемого документа в пространстве обмена данными с конкретным внешним контрагентом.
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $RequestExternalKey;
    /**
     * The OspProperty
     * Meta informations extracted from the WSDL
     * - documentation: Список ОСП | Список реквизитов отделов СП
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\OspProperty[]
     */
    public $OspProperty;
    /**
     * The SignDateTime
     * Meta informations extracted from the WSDL
     * - documentation: Дата и время формирования подписи | Дата и время | Дата и время
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01T00:00:00
     * - minInclusive: 1900-01-01T00:00:00
     * @var string
     */
    public $SignDateTime;
    /**
     * The Signature
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: ds:Signature
     * @var \StructType\SignatureType[]
     */
    public $Signature;
    /**
     * Constructor method for OspProperties
     * @uses OspProperties::setInternalKey()
     * @uses OspProperties::setRequestExternalKey()
     * @uses OspProperties::setOspProperty()
     * @uses OspProperties::setSignDateTime()
     * @uses OspProperties::setSignature()
     * @param int $internalKey
     * @param string $requestExternalKey
     * @param \StructType\OspProperty[] $ospProperty
     * @param string $signDateTime
     * @param \StructType\SignatureType[] $signature
     */
    public function __construct($internalKey = null, $requestExternalKey = null, array $ospProperty = array(), $signDateTime = null, array $signature = array())
    {
        $this
            ->setInternalKey($internalKey)
            ->setRequestExternalKey($requestExternalKey)
            ->setOspProperty($ospProperty)
            ->setSignDateTime($signDateTime)
            ->setSignature($signature);
    }
    /**
     * Get InternalKey value
     * @return int|null
     */
    public function getInternalKey()
    {
        return $this->InternalKey;
    }
    /**
     * Set InternalKey value
     * @param int $internalKey
     * @return \StructType\OspProperties
     */
    public function setInternalKey($internalKey = null)
    {
        $this->InternalKey = $internalKey;
        return $this;
    }
    /**
     * Get RequestExternalKey value
     * @return string|null
     */
    public function getRequestExternalKey()
    {
        return $this->RequestExternalKey;
    }
    /**
     * Set RequestExternalKey value
     * @param string $requestExternalKey
     * @return \StructType\OspProperties
     */
    public function setRequestExternalKey($requestExternalKey = null)
    {
        $this->RequestExternalKey = $requestExternalKey;
        return $this;
    }
    /**
     * Get OspProperty value
     * @return \StructType\OspProperty[]|null
     */
    public function getOspProperty()
    {
        return $this->OspProperty;
    }
    /**
     * Set OspProperty value
     * @throws \InvalidArgumentException
     * @param \StructType\OspProperty[] $ospProperty
     * @return \StructType\OspProperties
     */
    public function setOspProperty(array $ospProperty = array())
    {
        $this->OspProperty = $ospProperty;
        return $this;
    }
    /**
     * Add item to OspProperty value
     * @throws \InvalidArgumentException
     * @param \StructType\OspProperty $item
     * @return \StructType\OspProperties
     */
    public function addToOspProperty(\StructType\OspProperty $item)
    {
        $this->OspProperty[] = $item;
        return $this;
    }
    /**
     * Get SignDateTime value
     * @return string|null
     */
    public function getSignDateTime()
    {
        return $this->SignDateTime;
    }
    /**
     * Set SignDateTime value
     * @param string $signDateTime
     * @return \StructType\OspProperties
     */
    public function setSignDateTime($signDateTime = null)
    {
        $this->SignDateTime = $signDateTime;
        return $this;
    }
    /**
     * Get Signature value
     * @return \StructType\SignatureType[]|null
     */
    public function getSignature()
    {
        return $this->Signature;
    }
    /**
     * Set Signature value
     * @throws \InvalidArgumentException
     * @param \StructType\SignatureType[] $signature
     * @return \StructType\OspProperties
     */
    public function setSignature(array $signature = array())
    {
        $this->Signature = $signature;
        return $this;
    }
    /**
     * Add item to Signature value
     * @throws \InvalidArgumentException
     * @param \StructType\SignatureType $item
     * @return \StructType\OspProperties
     */
    public function addToSignature(\StructType\SignatureType $item)
    {
        $this->Signature[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OspProperties
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
