<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OspDetail StructType
 * Meta informations extracted from the WSDL
 * - documentation: Контейнер OspDetail «Сведения об отделе судебных приставов»
 * @subpackage Structs
 */
class OspDetail extends AbstractStructBase
{
    /**
     * The Priority
     * Meta informations extracted from the WSDL
     * - documentation: Приоритет | Допустимы значения 1 — 10 | Положительное короткое целое
     * - minInclusive: 1
     * @var int
     */
    public $Priority;
    /**
     * The OKATO
     * Meta informations extracted from the WSDL
     * - documentation: ОКАТО | Код объекта административно- территориального деления
     * - minOccurs: 0
     * - length: 11
     * - pattern: [0-9]{11}
     * @var string
     */
    public $OKATO;
    /**
     * The OKTMO
     * Meta informations extracted from the WSDL
     * - documentation: ОКТМО | Код объекта административно- территориального деления
     * - minOccurs: 0
     * - maxLength: 11
     * - minLength: 8
     * - pattern: ([0-9]{8})|([0-9]{11})
     * @var string
     */
    public $OKTMO;
    /**
     * The MinAmount
     * Meta informations extracted from the WSDL
     * - documentation: Сумма от | Сумма
     * - minOccurs: 0
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $MinAmount;
    /**
     * The MaxAmount
     * Meta informations extracted from the WSDL
     * - documentation: Сумма до | Сумма
     * - minOccurs: 0
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $MaxAmount;
    /**
     * The IDType
     * Meta informations extracted from the WSDL
     * - documentation: Тип ИД
     * - minOccurs: 0
     * @var string
     */
    public $IDType;
    /**
     * The ClaimerType
     * Meta informations extracted from the WSDL
     * - documentation: Тип органа, выдавшего ИД
     * - minOccurs: 0
     * @var string
     */
    public $ClaimerType;
    /**
     * The IdSubj
     * Meta informations extracted from the WSDL
     * - documentation: Тип предмета исполнения | Код предмета исполнения | NSI_IDoc_Subj_Exec
     * - minOccurs: 0
     * - maxLength: 8
     * - minLength: 1
     * @var string
     */
    public $IdSubj;
    /**
     * The DebtorType
     * Meta informations extracted from the WSDL
     * - documentation: Тип должника
     * - minOccurs: 0
     * @var string
     */
    public $DebtorType;
    /**
     * The KladrStreet
     * Meta informations extracted from the WSDL
     * - documentation: Код КЛАДР улицы | Код КЛАДР второго раздела
     * - minOccurs: 0
     * - length: 15
     * - pattern: [0-9]{15}
     * @var string
     */
    public $KladrStreet;
    /**
     * The Street
     * Meta informations extracted from the WSDL
     * - documentation: Название улицы | Строка длиной от 1 до 60 символов
     * - minOccurs: 0
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $Street;
    /**
     * The HouseNumber
     * Meta informations extracted from the WSDL
     * - documentation: Дома | Строка длиной от 1 до 100 символов
     * - minOccurs: 0
     * - maxLength: 100
     * - minLength: 1
     * @var string
     */
    public $HouseNumber;
    /**
     * The EvenHouse
     * Meta informations extracted from the WSDL
     * - documentation: Все четные дома | Обертка стандартного xs:boolean | Логический
     * - minOccurs: 0
     * @var bool
     */
    public $EvenHouse;
    /**
     * The UnevenHouse
     * Meta informations extracted from the WSDL
     * - documentation: Все нечетные дома | Обертка стандартного xs:boolean | Логический
     * - minOccurs: 0
     * @var bool
     */
    public $UnevenHouse;
    /**
     * Constructor method for OspDetail
     * @uses OspDetail::setPriority()
     * @uses OspDetail::setOKATO()
     * @uses OspDetail::setOKTMO()
     * @uses OspDetail::setMinAmount()
     * @uses OspDetail::setMaxAmount()
     * @uses OspDetail::setIDType()
     * @uses OspDetail::setClaimerType()
     * @uses OspDetail::setIdSubj()
     * @uses OspDetail::setDebtorType()
     * @uses OspDetail::setKladrStreet()
     * @uses OspDetail::setStreet()
     * @uses OspDetail::setHouseNumber()
     * @uses OspDetail::setEvenHouse()
     * @uses OspDetail::setUnevenHouse()
     * @param int $priority
     * @param string $oKATO
     * @param string $oKTMO
     * @param float $minAmount
     * @param float $maxAmount
     * @param string $iDType
     * @param string $claimerType
     * @param string $idSubj
     * @param string $debtorType
     * @param string $kladrStreet
     * @param string $street
     * @param string $houseNumber
     * @param bool $evenHouse
     * @param bool $unevenHouse
     */
    public function __construct($priority = null, $oKATO = null, $oKTMO = null, $minAmount = null, $maxAmount = null, $iDType = null, $claimerType = null, $idSubj = null, $debtorType = null, $kladrStreet = null, $street = null, $houseNumber = null, $evenHouse = null, $unevenHouse = null)
    {
        $this
            ->setPriority($priority)
            ->setOKATO($oKATO)
            ->setOKTMO($oKTMO)
            ->setMinAmount($minAmount)
            ->setMaxAmount($maxAmount)
            ->setIDType($iDType)
            ->setClaimerType($claimerType)
            ->setIdSubj($idSubj)
            ->setDebtorType($debtorType)
            ->setKladrStreet($kladrStreet)
            ->setStreet($street)
            ->setHouseNumber($houseNumber)
            ->setEvenHouse($evenHouse)
            ->setUnevenHouse($unevenHouse);
    }
    /**
     * Get Priority value
     * @return int|null
     */
    public function getPriority()
    {
        return $this->Priority;
    }
    /**
     * Set Priority value
     * @param int $priority
     * @return \StructType\OspDetail
     */
    public function setPriority($priority = null)
    {
        $this->Priority = $priority;
        return $this;
    }
    /**
     * Get OKATO value
     * @return string|null
     */
    public function getOKATO()
    {
        return $this->OKATO;
    }
    /**
     * Set OKATO value
     * @param string $oKATO
     * @return \StructType\OspDetail
     */
    public function setOKATO($oKATO = null)
    {
        $this->OKATO = $oKATO;
        return $this;
    }
    /**
     * Get OKTMO value
     * @return string|null
     */
    public function getOKTMO()
    {
        return $this->OKTMO;
    }
    /**
     * Set OKTMO value
     * @param string $oKTMO
     * @return \StructType\OspDetail
     */
    public function setOKTMO($oKTMO = null)
    {
        $this->OKTMO = $oKTMO;
        return $this;
    }
    /**
     * Get MinAmount value
     * @return float|null
     */
    public function getMinAmount()
    {
        return $this->MinAmount;
    }
    /**
     * Set MinAmount value
     * @param float $minAmount
     * @return \StructType\OspDetail
     */
    public function setMinAmount($minAmount = null)
    {
        $this->MinAmount = $minAmount;
        return $this;
    }
    /**
     * Get MaxAmount value
     * @return float|null
     */
    public function getMaxAmount()
    {
        return $this->MaxAmount;
    }
    /**
     * Set MaxAmount value
     * @param float $maxAmount
     * @return \StructType\OspDetail
     */
    public function setMaxAmount($maxAmount = null)
    {
        $this->MaxAmount = $maxAmount;
        return $this;
    }
    /**
     * Get IDType value
     * @return string|null
     */
    public function getIDType()
    {
        return $this->IDType;
    }
    /**
     * Set IDType value
     * @uses \EnumType\IdType::valueIsValid()
     * @uses \EnumType\IdType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $iDType
     * @return \StructType\OspDetail
     */
    public function setIDType($iDType = null)
    {
        $this->IDType = $iDType;
        return $this;
    }
    /**
     * Get ClaimerType value
     * @return string|null
     */
    public function getClaimerType()
    {
        return $this->ClaimerType;
    }
    /**
     * Set ClaimerType value
     * @uses \EnumType\ContragentType::valueIsValid()
     * @uses \EnumType\ContragentType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $claimerType
     * @return \StructType\OspDetail
     */
    public function setClaimerType($claimerType = null)
    {
        $this->ClaimerType = $claimerType;
        return $this;
    }
    /**
     * Get IdSubj value
     * @return string|null
     */
    public function getIdSubj()
    {
        return $this->IdSubj;
    }
    /**
     * Set IdSubj value
     * @param string $idSubj
     * @return \StructType\OspDetail
     */
    public function setIdSubj($idSubj = null)
    {
        $this->IdSubj = $idSubj;
        return $this;
    }
    /**
     * Get DebtorType value
     * @return string|null
     */
    public function getDebtorType()
    {
        return $this->DebtorType;
    }
    /**
     * Set DebtorType value
     * @uses \EnumType\ContragentType::valueIsValid()
     * @uses \EnumType\ContragentType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $debtorType
     * @return \StructType\OspDetail
     */
    public function setDebtorType($debtorType = null)
    {
        $this->DebtorType = $debtorType;
        return $this;
    }
    /**
     * Get KladrStreet value
     * @return string|null
     */
    public function getKladrStreet()
    {
        return $this->KladrStreet;
    }
    /**
     * Set KladrStreet value
     * @param string $kladrStreet
     * @return \StructType\OspDetail
     */
    public function setKladrStreet($kladrStreet = null)
    {
        $this->KladrStreet = $kladrStreet;
        return $this;
    }
    /**
     * Get Street value
     * @return string|null
     */
    public function getStreet()
    {
        return $this->Street;
    }
    /**
     * Set Street value
     * @param string $street
     * @return \StructType\OspDetail
     */
    public function setStreet($street = null)
    {
        $this->Street = $street;
        return $this;
    }
    /**
     * Get HouseNumber value
     * @return string|null
     */
    public function getHouseNumber()
    {
        return $this->HouseNumber;
    }
    /**
     * Set HouseNumber value
     * @param string $houseNumber
     * @return \StructType\OspDetail
     */
    public function setHouseNumber($houseNumber = null)
    {
        $this->HouseNumber = $houseNumber;
        return $this;
    }
    /**
     * Get EvenHouse value
     * @return bool|null
     */
    public function getEvenHouse()
    {
        return $this->EvenHouse;
    }
    /**
     * Set EvenHouse value
     * @param bool $evenHouse
     * @return \StructType\OspDetail
     */
    public function setEvenHouse($evenHouse = null)
    {
        $this->EvenHouse = $evenHouse;
        return $this;
    }
    /**
     * Get UnevenHouse value
     * @return bool|null
     */
    public function getUnevenHouse()
    {
        return $this->UnevenHouse;
    }
    /**
     * Set UnevenHouse value
     * @param bool $unevenHouse
     * @return \StructType\OspDetail
     */
    public function setUnevenHouse($unevenHouse = null)
    {
        $this->UnevenHouse = $unevenHouse;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OspDetail
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
