<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OkvedDetailType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Сведения о видах экономической деятельности
 * @subpackage Structs
 */
class OkvedDetailType extends AbstractStructBase
{
    /**
     * The OKVED
     * Meta informations extracted from the WSDL
     * - documentation: Kод ОКВЭД | Код вида экономической деятельности
     * - length: 8
     * - pattern: [0-9]{8}
     * @var string
     */
    public $OKVED;
    /**
     * The isMain
     * Meta informations extracted from the WSDL
     * - documentation: Признак основного вида деятельности
     * @var string
     */
    public $isMain;
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - documentation: Наименование вида деятельности | Строка длиной от 1 до 80 символов
     * - maxLength: 80
     * - minLength: 1
     * @var string
     */
    public $name;
    /**
     * Constructor method for OkvedDetailType
     * @uses OkvedDetailType::setOKVED()
     * @uses OkvedDetailType::setIsMain()
     * @uses OkvedDetailType::setName()
     * @param string $oKVED
     * @param string $isMain
     * @param string $name
     */
    public function __construct($oKVED = null, $isMain = null, $name = null)
    {
        $this
            ->setOKVED($oKVED)
            ->setIsMain($isMain)
            ->setName($name);
    }
    /**
     * Get OKVED value
     * @return string|null
     */
    public function getOKVED()
    {
        return $this->OKVED;
    }
    /**
     * Set OKVED value
     * @param string $oKVED
     * @return \StructType\OkvedDetailType
     */
    public function setOKVED($oKVED = null)
    {
        $this->OKVED = $oKVED;
        return $this;
    }
    /**
     * Get isMain value
     * @return string|null
     */
    public function getIsMain()
    {
        return $this->isMain;
    }
    /**
     * Set isMain value
     * @uses \EnumType\OkvedIsMainType::valueIsValid()
     * @uses \EnumType\OkvedIsMainType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $isMain
     * @return \StructType\OkvedDetailType
     */
    public function setIsMain($isMain = null)
    {
        $this->isMain = $isMain;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\OkvedDetailType
     */
    public function setName($name = null)
    {
        $this->name = $name;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OkvedDetailType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
