<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ObjectDataType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Тип сведений ObjectDataType "Объекты учета"
 * @subpackage Structs
 */
class ObjectDataType extends InformationType
{
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - documentation: Наименование объекта учета (у которых не заполнена дата снятия с учета) | Строка длиной от 1 до 300 символов
     * - maxLength: 300
     * - minLength: 1
     * @var string
     */
    public $Name;
    /**
     * The Location
     * Meta informations extracted from the WSDL
     * - documentation: Адрес (место нахождения) объекта учета | Адрес в формате «Код страны» + «запятая» + «Адрес в формате 9 запятых по КЛАДР» или (в
     * случае отсутствия кода страны) в произвольном формате | Строка длиной от 1 до 300 символов
     * - minOccurs: 0
     * - maxLength: 300
     * - minLength: 1
     * @var string
     */
    public $Location;
    /**
     * Constructor method for ObjectDataType
     * @uses ObjectDataType::setName()
     * @uses ObjectDataType::setLocation()
     * @param string $name
     * @param string $location
     */
    public function __construct($name = null, $location = null)
    {
        $this
            ->setName($name)
            ->setLocation($location);
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\ObjectDataType
     */
    public function setName($name = null)
    {
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Location value
     * @return string|null
     */
    public function getLocation()
    {
        return $this->Location;
    }
    /**
     * Set Location value
     * @param string $location
     * @return \StructType\ObjectDataType
     */
    public function setLocation($location = null)
    {
        $this->Location = $location;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ObjectDataType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
