<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for NoticeSaleSeizedProperty StructType
 * Meta informations extracted from the WSDL
 * - documentation: Уведомление о реализации арестованного имущества | ЭП
 * - type: tns:NoticeSaleSeizedProperty
 * @subpackage Structs
 */
class NoticeSaleSeizedProperty extends AbstractStructBase
{
    /**
     * The ExternalKey
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор АИС ВК | Идентификатор документа, присвоенный АИС внешнего контрагента. | Идентификатор объекта, присвоенный
     * объекту АИС внешнего контрагентом (ФНС, ПФР и прочие). Данный идентификатор должен быть уникальным для типа идентифицируемого документа
     * в пространстве обмена данными с конкретным внешним контрагентом.
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $ExternalKey;
    /**
     * The NoticeNum
     * Meta informations extracted from the WSDL
     * - documentation: Номер уведомления | Номер уведомления о готовности к реализации арестованного имущества. | Номер документа
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $NoticeNum;
    /**
     * The NoticeDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата уведомления | Дата уведомления о готовности к реализации арестованного имущества. | Дата | Дата
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $NoticeDate;
    /**
     * The ProcDocId
     * Meta informations extracted from the WSDL
     * - documentation: Ключ постановления | Ключ постановления судебного пристава-исполнителя о передачи арестованного имущества должника на
     * реализацию. | Ключ объекта, присвоенний информационной системой ФССП РФ при создании объекта или при получении объекта от контрагента
     * - minOccurs: 0
     * - maxInclusive: 9223372036854775807
     * - minInclusive: -9223372036854775808
     * @var int
     */
    public $ProcDocId;
    /**
     * The NoticeSaleSeizedPropertyBase
     * Meta informations extracted from the WSDL
     * - documentation: Уведомление | Оригинал уведомления о реализации арестованного имущества вынесенного в электронном виде согласно формату
     * Приложения № X «Формат постановления должностного лица ФССП России, выданного в виде электронного документа, юридическая значимость
     * которого подтверждена электронной подписью в порядке, установленном законодательством Российской Федерации» в кодировке Base64.
     * - minOccurs: 0
     * @var string
     */
    public $NoticeSaleSeizedPropertyBase;
    /**
     * The SignatureNoticeSaleSeizedPropertyBase
     * Meta informations extracted from the WSDL
     * - documentation: ЭП уведомления | ЭП уведомления о готовности к реализации арестованного имущества вынесенного в электронном виде, элемента
     * «NoticeSaleSeizedPropertyBase» в формате pkcs#7, в кодировке Base64.
     * - minOccurs: 0
     * @var string
     */
    public $SignatureNoticeSaleSeizedPropertyBase;
    /**
     * The attachments
     * Meta informations extracted from the WSDL
     * - documentation: Приложенные файлы | Дополнительные данные в произвольных форматах.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\AttachmentType[]
     */
    public $attachments;
    /**
     * The SignDateTime
     * Meta informations extracted from the WSDL
     * - documentation: Дата и время формирования подписи | Дата и время | Дата и время
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01T00:00:00
     * - minInclusive: 1900-01-01T00:00:00
     * @var string
     */
    public $SignDateTime;
    /**
     * The Signature
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: ds:Signature
     * @var \StructType\SignatureType[]
     */
    public $Signature;
    /**
     * Constructor method for NoticeSaleSeizedProperty
     * @uses NoticeSaleSeizedProperty::setExternalKey()
     * @uses NoticeSaleSeizedProperty::setNoticeNum()
     * @uses NoticeSaleSeizedProperty::setNoticeDate()
     * @uses NoticeSaleSeizedProperty::setProcDocId()
     * @uses NoticeSaleSeizedProperty::setNoticeSaleSeizedPropertyBase()
     * @uses NoticeSaleSeizedProperty::setSignatureNoticeSaleSeizedPropertyBase()
     * @uses NoticeSaleSeizedProperty::setAttachments()
     * @uses NoticeSaleSeizedProperty::setSignDateTime()
     * @uses NoticeSaleSeizedProperty::setSignature()
     * @param string $externalKey
     * @param string $noticeNum
     * @param string $noticeDate
     * @param int $procDocId
     * @param string $noticeSaleSeizedPropertyBase
     * @param string $signatureNoticeSaleSeizedPropertyBase
     * @param \StructType\AttachmentType[] $attachments
     * @param string $signDateTime
     * @param \StructType\SignatureType[] $signature
     */
    public function __construct($externalKey = null, $noticeNum = null, $noticeDate = null, $procDocId = null, $noticeSaleSeizedPropertyBase = null, $signatureNoticeSaleSeizedPropertyBase = null, array $attachments = array(), $signDateTime = null, array $signature = array())
    {
        $this
            ->setExternalKey($externalKey)
            ->setNoticeNum($noticeNum)
            ->setNoticeDate($noticeDate)
            ->setProcDocId($procDocId)
            ->setNoticeSaleSeizedPropertyBase($noticeSaleSeizedPropertyBase)
            ->setSignatureNoticeSaleSeizedPropertyBase($signatureNoticeSaleSeizedPropertyBase)
            ->setAttachments($attachments)
            ->setSignDateTime($signDateTime)
            ->setSignature($signature);
    }
    /**
     * Get ExternalKey value
     * @return string|null
     */
    public function getExternalKey()
    {
        return $this->ExternalKey;
    }
    /**
     * Set ExternalKey value
     * @param string $externalKey
     * @return \StructType\NoticeSaleSeizedProperty
     */
    public function setExternalKey($externalKey = null)
    {
        $this->ExternalKey = $externalKey;
        return $this;
    }
    /**
     * Get NoticeNum value
     * @return string|null
     */
    public function getNoticeNum()
    {
        return $this->NoticeNum;
    }
    /**
     * Set NoticeNum value
     * @param string $noticeNum
     * @return \StructType\NoticeSaleSeizedProperty
     */
    public function setNoticeNum($noticeNum = null)
    {
        $this->NoticeNum = $noticeNum;
        return $this;
    }
    /**
     * Get NoticeDate value
     * @return string|null
     */
    public function getNoticeDate()
    {
        return $this->NoticeDate;
    }
    /**
     * Set NoticeDate value
     * @param string $noticeDate
     * @return \StructType\NoticeSaleSeizedProperty
     */
    public function setNoticeDate($noticeDate = null)
    {
        $this->NoticeDate = $noticeDate;
        return $this;
    }
    /**
     * Get ProcDocId value
     * @return int|null
     */
    public function getProcDocId()
    {
        return $this->ProcDocId;
    }
    /**
     * Set ProcDocId value
     * @param int $procDocId
     * @return \StructType\NoticeSaleSeizedProperty
     */
    public function setProcDocId($procDocId = null)
    {
        $this->ProcDocId = $procDocId;
        return $this;
    }
    /**
     * Get NoticeSaleSeizedPropertyBase value
     * @return string|null
     */
    public function getNoticeSaleSeizedPropertyBase()
    {
        return $this->NoticeSaleSeizedPropertyBase;
    }
    /**
     * Set NoticeSaleSeizedPropertyBase value
     * @param string $noticeSaleSeizedPropertyBase
     * @return \StructType\NoticeSaleSeizedProperty
     */
    public function setNoticeSaleSeizedPropertyBase($noticeSaleSeizedPropertyBase = null)
    {
        $this->NoticeSaleSeizedPropertyBase = $noticeSaleSeizedPropertyBase;
        return $this;
    }
    /**
     * Get SignatureNoticeSaleSeizedPropertyBase value
     * @return string|null
     */
    public function getSignatureNoticeSaleSeizedPropertyBase()
    {
        return $this->SignatureNoticeSaleSeizedPropertyBase;
    }
    /**
     * Set SignatureNoticeSaleSeizedPropertyBase value
     * @param string $signatureNoticeSaleSeizedPropertyBase
     * @return \StructType\NoticeSaleSeizedProperty
     */
    public function setSignatureNoticeSaleSeizedPropertyBase($signatureNoticeSaleSeizedPropertyBase = null)
    {
        $this->SignatureNoticeSaleSeizedPropertyBase = $signatureNoticeSaleSeizedPropertyBase;
        return $this;
    }
    /**
     * Get attachments value
     * @return \StructType\AttachmentType[]|null
     */
    public function getAttachments()
    {
        return $this->attachments;
    }
    /**
     * Set attachments value
     * @throws \InvalidArgumentException
     * @param \StructType\AttachmentType[] $attachments
     * @return \StructType\NoticeSaleSeizedProperty
     */
    public function setAttachments(array $attachments = array())
    {
        $this->attachments = $attachments;
        return $this;
    }
    /**
     * Add item to attachments value
     * @throws \InvalidArgumentException
     * @param \StructType\AttachmentType $item
     * @return \StructType\NoticeSaleSeizedProperty
     */
    public function addToAttachments(\StructType\AttachmentType $item)
    {
        $this->attachments[] = $item;
        return $this;
    }
    /**
     * Get SignDateTime value
     * @return string|null
     */
    public function getSignDateTime()
    {
        return $this->SignDateTime;
    }
    /**
     * Set SignDateTime value
     * @param string $signDateTime
     * @return \StructType\NoticeSaleSeizedProperty
     */
    public function setSignDateTime($signDateTime = null)
    {
        $this->SignDateTime = $signDateTime;
        return $this;
    }
    /**
     * Get Signature value
     * @return \StructType\SignatureType[]|null
     */
    public function getSignature()
    {
        return $this->Signature;
    }
    /**
     * Set Signature value
     * @throws \InvalidArgumentException
     * @param \StructType\SignatureType[] $signature
     * @return \StructType\NoticeSaleSeizedProperty
     */
    public function setSignature(array $signature = array())
    {
        $this->Signature = $signature;
        return $this;
    }
    /**
     * Add item to Signature value
     * @throws \InvalidArgumentException
     * @param \StructType\SignatureType $item
     * @return \StructType\NoticeSaleSeizedProperty
     */
    public function addToSignature(\StructType\SignatureType $item)
    {
        $this->Signature[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\NoticeSaleSeizedProperty
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
