<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Message StructType
 * Meta informations extracted from the WSDL
 * - documentation: Сообщение. Включает в себя один пакет документов | ЭЦП | Технологическая ЭЦП (накладывается сервером, формирующим сообщение)
 * - type: tns:DocumentNote
 * @subpackage Structs
 */
class Message extends AbstractStructBase
{
    /**
     * The pack
     * Meta informations extracted from the WSDL
     * - documentation: Пакет документов
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\DataBlock
     */
    public $pack;
    /**
     * The externalKey
     * Meta informations extracted from the WSDL
     * - documentation: Ключ сообщения внешнего контрагента | Идентификатор объекта, присвоенный объекту АИС внешнего контрагентом (ФНС, ПФР и прочие).
     * Данный идентификатор должен быть уникальным для типа идентифицируемого документа в пространстве обмена данными с конкретным внешним
     * контрагентом.
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $externalKey;
    /**
     * The internalKey
     * Meta informations extracted from the WSDL
     * - documentation: Ключ сообщения АИС ФССП России | Ключ объекта, присвоенний информационной системой ФССП РФ при создании объекта или при
     * получении объекта от контрагента
     * - maxInclusive: 9223372036854775807
     * - minInclusive: -9223372036854775808
     * @var int
     */
    public $internalKey;
    /**
     * The origin
     * Meta informations extracted from the WSDL
     * - documentation: Адрес отправителя пакета
     * - minOccurs: 0
     * @var \StructType\RedAddress
     */
    public $origin;
    /**
     * The target
     * Meta informations extracted from the WSDL
     * - documentation: Адрес получателя пакета
     * - minOccurs: 0
     * @var \StructType\RedAddress
     */
    public $target;
    /**
     * The generation
     * Meta informations extracted from the WSDL
     * - documentation: Номер поколения
     * - minOccurs: 0
     * @var int
     */
    public $generation;
    /**
     * The Signature
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: ds:Signature
     * @var \StructType\SignatureType[]
     */
    public $Signature;
    /**
     * Constructor method for Message
     * @uses Message::setPack()
     * @uses Message::setExternalKey()
     * @uses Message::setInternalKey()
     * @uses Message::setOrigin()
     * @uses Message::setTarget()
     * @uses Message::setGeneration()
     * @uses Message::setSignature()
     * @param \StructType\DataBlock $pack
     * @param string $externalKey
     * @param int $internalKey
     * @param \StructType\RedAddress $origin
     * @param \StructType\RedAddress $target
     * @param int $generation
     * @param \StructType\SignatureType[] $signature
     */
    public function __construct(\StructType\DataBlock $pack = null, $externalKey = null, $internalKey = null, \StructType\RedAddress $origin = null, \StructType\RedAddress $target = null, $generation = null, array $signature = array())
    {
        $this
            ->setPack($pack)
            ->setExternalKey($externalKey)
            ->setInternalKey($internalKey)
            ->setOrigin($origin)
            ->setTarget($target)
            ->setGeneration($generation)
            ->setSignature($signature);
    }
    /**
     * Get pack value
     * @return \StructType\DataBlock
     */
    public function getPack()
    {
        return $this->pack;
    }
    /**
     * Set pack value
     * @param \StructType\DataBlock $pack
     * @return \StructType\Message
     */
    public function setPack(\StructType\DataBlock $pack = null)
    {
        $this->pack = $pack;
        return $this;
    }
    /**
     * Get externalKey value
     * @return string|null
     */
    public function getExternalKey()
    {
        return $this->externalKey;
    }
    /**
     * Set externalKey value
     * @param string $externalKey
     * @return \StructType\Message
     */
    public function setExternalKey($externalKey = null)
    {
        $this->externalKey = $externalKey;
        return $this;
    }
    /**
     * Get internalKey value
     * @return int|null
     */
    public function getInternalKey()
    {
        return $this->internalKey;
    }
    /**
     * Set internalKey value
     * @param int $internalKey
     * @return \StructType\Message
     */
    public function setInternalKey($internalKey = null)
    {
        $this->internalKey = $internalKey;
        return $this;
    }
    /**
     * Get origin value
     * @return \StructType\RedAddress|null
     */
    public function getOrigin()
    {
        return $this->origin;
    }
    /**
     * Set origin value
     * @param \StructType\RedAddress $origin
     * @return \StructType\Message
     */
    public function setOrigin(\StructType\RedAddress $origin = null)
    {
        $this->origin = $origin;
        return $this;
    }
    /**
     * Get target value
     * @return \StructType\RedAddress|null
     */
    public function getTarget()
    {
        return $this->target;
    }
    /**
     * Set target value
     * @param \StructType\RedAddress $target
     * @return \StructType\Message
     */
    public function setTarget(\StructType\RedAddress $target = null)
    {
        $this->target = $target;
        return $this;
    }
    /**
     * Get generation value
     * @return int|null
     */
    public function getGeneration()
    {
        return $this->generation;
    }
    /**
     * Set generation value
     * @param int $generation
     * @return \StructType\Message
     */
    public function setGeneration($generation = null)
    {
        $this->generation = $generation;
        return $this;
    }
    /**
     * Get Signature value
     * @return \StructType\SignatureType[]|null
     */
    public function getSignature()
    {
        return $this->Signature;
    }
    /**
     * Set Signature value
     * @throws \InvalidArgumentException
     * @param \StructType\SignatureType[] $signature
     * @return \StructType\Message
     */
    public function setSignature(array $signature = array())
    {
        $this->Signature = $signature;
        return $this;
    }
    /**
     * Add item to Signature value
     * @throws \InvalidArgumentException
     * @param \StructType\SignatureType $item
     * @return \StructType\Message
     */
    public function addToSignature(\StructType\SignatureType $item)
    {
        $this->Signature[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Message
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
