<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MailStateTrackingRequest StructType
 * Meta informations extracted from the WSDL
 * - documentation: Документ MailStateTrackingRequest "Запрос статуса корреспонденции" | Запрос статуса корреспонденции
 * - type: tns:MailStateTrackingRequest
 * @subpackage Structs
 */
class MailStateTrackingRequest extends AbstractStructBase
{
    /**
     * The BarcodeList
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var \StructType\BarcodeList[]
     */
    public $BarcodeList;
    /**
     * The InternalKey
     * Meta informations extracted from the WSDL
     * - documentation: Ключ ФССП России | Уникальный идентификатор запроса на отслеживание корреспонденции. | Ключ объекта, присвоенний
     * информационной системой ФССП РФ при создании объекта или при получении объекта от контрагента
     * - maxInclusive: 9223372036854775807
     * - minInclusive: -9223372036854775808
     * @var int
     */
    public $InternalKey;
    /**
     * The DocDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата запроса | Дата | Дата
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $DocDate;
    /**
     * Constructor method for MailStateTrackingRequest
     * @uses MailStateTrackingRequest::setBarcodeList()
     * @uses MailStateTrackingRequest::setInternalKey()
     * @uses MailStateTrackingRequest::setDocDate()
     * @param \StructType\BarcodeList[] $barcodeList
     * @param int $internalKey
     * @param string $docDate
     */
    public function __construct(array $barcodeList = array(), $internalKey = null, $docDate = null)
    {
        $this
            ->setBarcodeList($barcodeList)
            ->setInternalKey($internalKey)
            ->setDocDate($docDate);
    }
    /**
     * Get BarcodeList value
     * @return \StructType\BarcodeList[]
     */
    public function getBarcodeList()
    {
        return $this->BarcodeList;
    }
    /**
     * Set BarcodeList value
     * @throws \InvalidArgumentException
     * @param \StructType\BarcodeList[] $barcodeList
     * @return \StructType\MailStateTrackingRequest
     */
    public function setBarcodeList(array $barcodeList = array())
    {
        $this->BarcodeList = $barcodeList;
        return $this;
    }
    /**
     * Add item to BarcodeList value
     * @throws \InvalidArgumentException
     * @param \StructType\BarcodeList $item
     * @return \StructType\MailStateTrackingRequest
     */
    public function addToBarcodeList(\StructType\BarcodeList $item)
    {
        $this->BarcodeList[] = $item;
        return $this;
    }
    /**
     * Get InternalKey value
     * @return int|null
     */
    public function getInternalKey()
    {
        return $this->InternalKey;
    }
    /**
     * Set InternalKey value
     * @param int $internalKey
     * @return \StructType\MailStateTrackingRequest
     */
    public function setInternalKey($internalKey = null)
    {
        $this->InternalKey = $internalKey;
        return $this;
    }
    /**
     * Get DocDate value
     * @return string|null
     */
    public function getDocDate()
    {
        return $this->DocDate;
    }
    /**
     * Set DocDate value
     * @param string $docDate
     * @return \StructType\MailStateTrackingRequest
     */
    public function setDocDate($docDate = null)
    {
        $this->DocDate = $docDate;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\MailStateTrackingRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
