<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MailState StructType
 * Meta informations extracted from the WSDL
 * - documentation: Документ MailState "Статус корреспонденции" | «Статус корреспонденции»
 * - type: tns:MailState
 * @subpackage Structs
 */
class MailState extends AbstractStructBase
{
    /**
     * The InternalKey
     * Meta informations extracted from the WSDL
     * - documentation: Ключ ФССП России | Ключ объекта, присвоенний информационной системой ФССП РФ при создании объекта или при получении объекта от
     * контрагента
     * - maxInclusive: 9223372036854775807
     * - minInclusive: -9223372036854775808
     * @var int
     */
    public $InternalKey;
    /**
     * The ExternalKey
     * Meta informations extracted from the WSDL
     * - documentation: >Идентификатор, присвоенный ФГУП «Почта России» | Идентификатор объекта, присвоенный объекту АИС внешнего контрагентом (ФНС,
     * ПФР и прочие). Данный идентификатор должен быть уникальным для типа идентифицируемого документа в пространстве обмена данными с
     * конкретным внешним контрагентом.
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $ExternalKey;
    /**
     * The DocDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата докумета | Дата | Дата
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $DocDate;
    /**
     * The Barcode
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор отправления | Идентификатор отправления, присвоенный ФГУП «Почта России» | Штрих-код в формате code39
     * - maxLength: 44
     * - minLength: 1
     * - pattern: [0-9A-Z\-\.\+$/%]+
     * @var string
     */
    public $Barcode;
    /**
     * The StateDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата докумета | Дата и время | Дата и время
     * - maxExclusive: 2100-01-01T00:00:00
     * - minInclusive: 1900-01-01T00:00:00
     * @var string
     */
    public $StateDate;
    /**
     * The State
     * Meta informations extracted from the WSDL
     * - documentation: Статус
     * @var string
     */
    public $State;
    /**
     * The PostOfficeCode
     * Meta informations extracted from the WSDL
     * - documentation: Индекс почтового отделения | Строка длиной от 1 до 6 символов
     * - maxLength: 6
     * - minLength: 1
     * @var string
     */
    public $PostOfficeCode;
    /**
     * The ErrorText
     * Meta informations extracted from the WSDL
     * - documentation: Сообщение об ошибке | Строка длиной от 1 до 100 символов
     * - maxLength: 100
     * - minLength: 1
     * @var string
     */
    public $ErrorText;
    /**
     * Constructor method for MailState
     * @uses MailState::setInternalKey()
     * @uses MailState::setExternalKey()
     * @uses MailState::setDocDate()
     * @uses MailState::setBarcode()
     * @uses MailState::setStateDate()
     * @uses MailState::setState()
     * @uses MailState::setPostOfficeCode()
     * @uses MailState::setErrorText()
     * @param int $internalKey
     * @param string $externalKey
     * @param string $docDate
     * @param string $barcode
     * @param string $stateDate
     * @param string $state
     * @param string $postOfficeCode
     * @param string $errorText
     */
    public function __construct($internalKey = null, $externalKey = null, $docDate = null, $barcode = null, $stateDate = null, $state = null, $postOfficeCode = null, $errorText = null)
    {
        $this
            ->setInternalKey($internalKey)
            ->setExternalKey($externalKey)
            ->setDocDate($docDate)
            ->setBarcode($barcode)
            ->setStateDate($stateDate)
            ->setState($state)
            ->setPostOfficeCode($postOfficeCode)
            ->setErrorText($errorText);
    }
    /**
     * Get InternalKey value
     * @return int|null
     */
    public function getInternalKey()
    {
        return $this->InternalKey;
    }
    /**
     * Set InternalKey value
     * @param int $internalKey
     * @return \StructType\MailState
     */
    public function setInternalKey($internalKey = null)
    {
        $this->InternalKey = $internalKey;
        return $this;
    }
    /**
     * Get ExternalKey value
     * @return string|null
     */
    public function getExternalKey()
    {
        return $this->ExternalKey;
    }
    /**
     * Set ExternalKey value
     * @param string $externalKey
     * @return \StructType\MailState
     */
    public function setExternalKey($externalKey = null)
    {
        $this->ExternalKey = $externalKey;
        return $this;
    }
    /**
     * Get DocDate value
     * @return string|null
     */
    public function getDocDate()
    {
        return $this->DocDate;
    }
    /**
     * Set DocDate value
     * @param string $docDate
     * @return \StructType\MailState
     */
    public function setDocDate($docDate = null)
    {
        $this->DocDate = $docDate;
        return $this;
    }
    /**
     * Get Barcode value
     * @return string|null
     */
    public function getBarcode()
    {
        return $this->Barcode;
    }
    /**
     * Set Barcode value
     * @param string $barcode
     * @return \StructType\MailState
     */
    public function setBarcode($barcode = null)
    {
        $this->Barcode = $barcode;
        return $this;
    }
    /**
     * Get StateDate value
     * @return string|null
     */
    public function getStateDate()
    {
        return $this->StateDate;
    }
    /**
     * Set StateDate value
     * @param string $stateDate
     * @return \StructType\MailState
     */
    public function setStateDate($stateDate = null)
    {
        $this->StateDate = $stateDate;
        return $this;
    }
    /**
     * Get State value
     * @return string|null
     */
    public function getState()
    {
        return $this->State;
    }
    /**
     * Set State value
     * @uses \EnumType\MailStateType::valueIsValid()
     * @uses \EnumType\MailStateType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $state
     * @return \StructType\MailState
     */
    public function setState($state = null)
    {
        $this->State = $state;
        return $this;
    }
    /**
     * Get PostOfficeCode value
     * @return string|null
     */
    public function getPostOfficeCode()
    {
        return $this->PostOfficeCode;
    }
    /**
     * Set PostOfficeCode value
     * @param string $postOfficeCode
     * @return \StructType\MailState
     */
    public function setPostOfficeCode($postOfficeCode = null)
    {
        $this->PostOfficeCode = $postOfficeCode;
        return $this;
    }
    /**
     * Get ErrorText value
     * @return string|null
     */
    public function getErrorText()
    {
        return $this->ErrorText;
    }
    /**
     * Set ErrorText value
     * @param string $errorText
     * @return \StructType\MailState
     */
    public function setErrorText($errorText = null)
    {
        $this->ErrorText = $errorText;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\MailState
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
