<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LookupTableQuery StructType
 * Meta informations extracted from the WSDL
 * - documentation: Запрос данных справочника
 * @subpackage Structs
 */
class LookupTableQuery extends AbstractStructBase
{
    /**
     * The lookupTable
     * Meta informations extracted from the WSDL
     * - documentation: Тип справочника
     * @var string
     */
    public $lookupTable;
    /**
     * The filter
     * Meta informations extracted from the WSDL
     * - documentation: Дополнительное условие | Указание данного значения позволяет при необходимости получить лишь часть справочника. | Строка
     * длиной от 1 до 1000 символов
     * - minOccurs: 0
     * - maxLength: 1000
     * - minLength: 1
     * @var string
     */
    public $filter;
    /**
     * Constructor method for LookupTableQuery
     * @uses LookupTableQuery::setLookupTable()
     * @uses LookupTableQuery::setFilter()
     * @param string $lookupTable
     * @param string $filter
     */
    public function __construct($lookupTable = null, $filter = null)
    {
        $this
            ->setLookupTable($lookupTable)
            ->setFilter($filter);
    }
    /**
     * Get lookupTable value
     * @return string|null
     */
    public function getLookupTable()
    {
        return $this->lookupTable;
    }
    /**
     * Set lookupTable value
     * @uses \EnumType\LookupTableType::valueIsValid()
     * @uses \EnumType\LookupTableType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $lookupTable
     * @return \StructType\LookupTableQuery
     */
    public function setLookupTable($lookupTable = null)
    {
        $this->lookupTable = $lookupTable;
        return $this;
    }
    /**
     * Get filter value
     * @return string|null
     */
    public function getFilter()
    {
        return $this->filter;
    }
    /**
     * Set filter value
     * @param string $filter
     * @return \StructType\LookupTableQuery
     */
    public function setFilter($filter = null)
    {
        $this->filter = $filter;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\LookupTableQuery
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
