<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LicenseActivityType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Вид деятельности, на который выдана лицензия
 * @subpackage Structs
 */
class LicenseActivityType extends AbstractStructBase
{
    /**
     * The activityId
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор | Идентификатор записи в БД ФНС (для ЕГРЮЛ/ЕГРИП)
     * - totalDigits: 15
     * @var int
     */
    public $activityId;
    /**
     * The activityName
     * Meta informations extracted from the WSDL
     * - documentation: Наименование вида деятельности, на который выдана лицензия | Строка длиной от 1 до 1000 символов
     * - maxLength: 1000
     * - minLength: 1
     * @var string
     */
    public $activityName;
    /**
     * Constructor method for LicenseActivityType
     * @uses LicenseActivityType::setActivityId()
     * @uses LicenseActivityType::setActivityName()
     * @param int $activityId
     * @param string $activityName
     */
    public function __construct($activityId = null, $activityName = null)
    {
        $this
            ->setActivityId($activityId)
            ->setActivityName($activityName);
    }
    /**
     * Get activityId value
     * @return int|null
     */
    public function getActivityId()
    {
        return $this->activityId;
    }
    /**
     * Set activityId value
     * @param int $activityId
     * @return \StructType\LicenseActivityType
     */
    public function setActivityId($activityId = null)
    {
        $this->activityId = $activityId;
        return $this;
    }
    /**
     * Get activityName value
     * @return string|null
     */
    public function getActivityName()
    {
        return $this->activityName;
    }
    /**
     * Set activityName value
     * @param string $activityName
     * @return \StructType\LicenseActivityType
     */
    public function setActivityName($activityName = null)
    {
        $this->activityName = $activityName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\LicenseActivityType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
