<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InformationType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Тип данных InformationType «Общие сведения» | Данный контейнер является базовым абстрактным типом, который должен быть расширен с
 * использованием XSD-инструкции xsd:extension для описания конкретных типов сведений, таких как информация о документе, адресе, наличии счетов и
 * пр.
 * @subpackage Structs
 */
abstract class InformationType extends AbstractStructBase
{
    /**
     * The InternalKey
     * Meta informations extracted from the WSDL
     * - documentation: Ключ ФССП России | Уникальный идентификатор объекта, присвоенный АИС ФССП России | Ключ объекта, присвоенний информационной
     * системой ФССП РФ при создании объекта или при получении объекта от контрагента
     * - minOccurs: 0
     * - maxInclusive: 9223372036854775807
     * - minInclusive: -9223372036854775808
     * @var int
     */
    public $InternalKey;
    /**
     * The ExternalKey
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор АИС ВК | Идентификатор объекта, присвоенный АИС внешнего контрагента. Уникален в рамках типа документа и
     * конкретного внешнего контрагента | Идентификатор объекта, присвоенный объекту АИС внешнего контрагентом (ФНС, ПФР и прочие). Данный
     * идентификатор должен быть уникальным для типа идентифицируемого документа в пространстве обмена данными с конкретным внешним
     * контрагентом.
     * - minOccurs: 0
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $ExternalKey;
    /**
     * The OwnerInternalKey
     * Meta informations extracted from the WSDL
     * - documentation: Ключ ФССП России сведений, к которым относится данная уточняющая запись сведений | Устанавливается для уточняющих или
     * дополняющих основную запись сведениях. | Ключ объекта, присвоенний информационной системой ФССП РФ при создании объекта или при
     * получении объекта от контрагента
     * - minOccurs: 0
     * - maxInclusive: 9223372036854775807
     * - minInclusive: -9223372036854775808
     * @var int
     */
    public $OwnerInternalKey;
    /**
     * The OwnerExternalKey
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор АИС ВК сведений, к которым относится данная уточняющая запись сведений | Устанавливается для уточняющих или
     * дополняющих основную запись сведениях. | Идентификатор объекта, присвоенный объекту АИС внешнего контрагентом (ФНС, ПФР и прочие).
     * Данный идентификатор должен быть уникальным для типа идентифицируемого документа в пространстве обмена данными с конкретным внешним
     * контрагентом.
     * - minOccurs: 0
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $OwnerExternalKey;
    /**
     * The ActDate
     * Meta informations extracted from the WSDL
     * - documentation: Актуальность сведений | Дата актуальности предоставления сведений. По состоянию на момент исполнения Запроса | Дата | Дата
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $ActDate;
    /**
     * The KindData
     * Meta informations extracted from the WSDL
     * - documentation: Вид сведений | Вид сведений по справочнику видов сведений | Вид сведений | NSI_MVV_KindData
     * - length: 2
     * - pattern: [0-9]{2}
     * @var string
     */
    public $KindData;
    /**
     * The DebtorName
     * Meta informations extracted from the WSDL
     * - documentation: Должник | Оригинальное наименование должника по базе банка, дата рождения (для ФЛ), ИНН (для ЮЛ/ИП) | Строка длиной от 1 до 1000
     * символов
     * - minOccurs: 0
     * - maxLength: 1000
     * - minLength: 1
     * @var string
     */
    public $DebtorName;
    /**
     * Constructor method for InformationType
     * @uses InformationType::setInternalKey()
     * @uses InformationType::setExternalKey()
     * @uses InformationType::setOwnerInternalKey()
     * @uses InformationType::setOwnerExternalKey()
     * @uses InformationType::setActDate()
     * @uses InformationType::setKindData()
     * @uses InformationType::setDebtorName()
     * @param int $internalKey
     * @param string $externalKey
     * @param int $ownerInternalKey
     * @param string $ownerExternalKey
     * @param string $actDate
     * @param string $kindData
     * @param string $debtorName
     */
    public function __construct($internalKey = null, $externalKey = null, $ownerInternalKey = null, $ownerExternalKey = null, $actDate = null, $kindData = null, $debtorName = null)
    {
        $this
            ->setInternalKey($internalKey)
            ->setExternalKey($externalKey)
            ->setOwnerInternalKey($ownerInternalKey)
            ->setOwnerExternalKey($ownerExternalKey)
            ->setActDate($actDate)
            ->setKindData($kindData)
            ->setDebtorName($debtorName);
    }
    /**
     * Get InternalKey value
     * @return int|null
     */
    public function getInternalKey()
    {
        return $this->InternalKey;
    }
    /**
     * Set InternalKey value
     * @param int $internalKey
     * @return \StructType\InformationType
     */
    public function setInternalKey($internalKey = null)
    {
        $this->InternalKey = $internalKey;
        return $this;
    }
    /**
     * Get ExternalKey value
     * @return string|null
     */
    public function getExternalKey()
    {
        return $this->ExternalKey;
    }
    /**
     * Set ExternalKey value
     * @param string $externalKey
     * @return \StructType\InformationType
     */
    public function setExternalKey($externalKey = null)
    {
        $this->ExternalKey = $externalKey;
        return $this;
    }
    /**
     * Get OwnerInternalKey value
     * @return int|null
     */
    public function getOwnerInternalKey()
    {
        return $this->OwnerInternalKey;
    }
    /**
     * Set OwnerInternalKey value
     * @param int $ownerInternalKey
     * @return \StructType\InformationType
     */
    public function setOwnerInternalKey($ownerInternalKey = null)
    {
        $this->OwnerInternalKey = $ownerInternalKey;
        return $this;
    }
    /**
     * Get OwnerExternalKey value
     * @return string|null
     */
    public function getOwnerExternalKey()
    {
        return $this->OwnerExternalKey;
    }
    /**
     * Set OwnerExternalKey value
     * @param string $ownerExternalKey
     * @return \StructType\InformationType
     */
    public function setOwnerExternalKey($ownerExternalKey = null)
    {
        $this->OwnerExternalKey = $ownerExternalKey;
        return $this;
    }
    /**
     * Get ActDate value
     * @return string|null
     */
    public function getActDate()
    {
        return $this->ActDate;
    }
    /**
     * Set ActDate value
     * @param string $actDate
     * @return \StructType\InformationType
     */
    public function setActDate($actDate = null)
    {
        $this->ActDate = $actDate;
        return $this;
    }
    /**
     * Get KindData value
     * @return string|null
     */
    public function getKindData()
    {
        return $this->KindData;
    }
    /**
     * Set KindData value
     * @param string $kindData
     * @return \StructType\InformationType
     */
    public function setKindData($kindData = null)
    {
        $this->KindData = $kindData;
        return $this;
    }
    /**
     * Get DebtorName value
     * @return string|null
     */
    public function getDebtorName()
    {
        return $this->DebtorName;
    }
    /**
     * Set DebtorName value
     * @param string $debtorName
     * @return \StructType\InformationType
     */
    public function setDebtorName($debtorName = null)
    {
        $this->DebtorName = $debtorName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\InformationType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
