<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InformationDocument StructType
 * Meta informations extracted from the WSDL
 * - documentation: Сведения о документе
 * - type: tns:InformationDocument
 * @subpackage Structs
 */
class InformationDocument extends AbstractStructBase
{
    /**
     * The Organization
     * Meta informations extracted from the WSDL
     * - documentation: Код отправителя | Код отправителя | Код организации | NSI_MVV_Organization
     * - maxLength: 20
     * - minLength: 1
     * @var string
     */
    public $Organization;
    /**
     * The Department
     * Meta informations extracted from the WSDL
     * - documentation: Код подразделения отправителя | Код подразделения отправителя | Код подразделения организации | NSI_MVV_Department
     * - minOccurs: 0
     * - maxLength: 320
     * - minLength: 1
     * @var string
     */
    public $Department;
    /**
     * The OrganizationRecipient
     * Meta informations extracted from the WSDL
     * - documentation: Код получателя | Код получателя | Код организации | NSI_MVV_Organization
     * - maxLength: 20
     * - minLength: 1
     * @var string
     */
    public $OrganizationRecipient;
    /**
     * The DepartmentRecipient
     * Meta informations extracted from the WSDL
     * - documentation: Код подразделения получателя | Код подразделения получателя | Код подразделения организации | NSI_MVV_Department
     * - minOccurs: 0
     * - maxLength: 320
     * - minLength: 1
     * @var string
     */
    public $DepartmentRecipient;
    /**
     * The ID
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор документа отправителя | Идентификатор документа отправителя | Идентификатор объекта, присвоенный объекту АИС
     * внешнего контрагентом (ФНС, ПФР и прочие). Данный идентификатор должен быть уникальным для типа идентифицируемого документа в
     * пространстве обмена данными с конкретным внешним контрагентом.
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $ID;
    /**
     * The IncomingDocKey
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор входящего документа | Идентификатор входящего документа в рамках которого подготавливается документ (ответ) |
     * Идентификатор объекта, присвоенный объекту АИС внешнего контрагентом (ФНС, ПФР и прочие). Данный идентификатор должен быть уникальным
     * для типа идентифицируемого документа в пространстве обмена данными с конкретным внешним контрагентом.
     * - minOccurs: 0
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $IncomingDocKey;
    /**
     * The Type
     * Meta informations extracted from the WSDL
     * - documentation: Код типа документа | Код типа документа согласно классификатору документов АИС ФССП России | Тип документа АИС ФССП России (тип
     * документа ПКОСП) | Тип документа электронного документооборота | NSI_Document | Наименование объекта NCORE
     * - maxLength: 31 | 31
     * - minLength: 1 | 1
     * @var string
     */
    public $Type;
    /**
     * The DocumentDate
     * Meta informations extracted from the WSDL
     * - documentation: Регистрационная дата документа | Регистрационная дата отправляемого документа | Дата | Дата
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $DocumentDate;
    /**
     * The DocumentNumber
     * Meta informations extracted from the WSDL
     * - documentation: Регистрационный номер документа | Регистрационный номер отправляемого документа, в случае отсутствия может указываться
     * идентификатор в соответствии с размерностью поля | Номер документа
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $DocumentNumber;
    /**
     * The DocumentCaseNumber
     * Meta informations extracted from the WSDL
     * - documentation: Номер дела | Номер дела | Строка длиной от 1 до 50 символов
     * - minOccurs: 0
     * - maxLength: 50
     * - minLength: 1
     * @var string
     */
    public $DocumentCaseNumber;
    /**
     * The Filename
     * Meta informations extracted from the WSDL
     * - documentation: Имя файла | Имя передаваемого файла (zip-архива) | Строка длиной от 1 до 100 символов
     * - maxLength: 100
     * - minLength: 1
     * @var string
     */
    public $Filename;
    /**
     * The Content
     * Meta informations extracted from the WSDL
     * - documentation: Данные документа | В элементе передаются данные файла (контент вложения) в Base64, например: zip-архив
     * @var string
     */
    public $Content;
    /**
     * The IsUnstructuredFormat
     * Meta informations extracted from the WSDL
     * - documentation: Формат вложения структурированный | Устанавливается в значение true, если вложение (передается в элементе «Данные документа»)
     * имеет структурированный формат. Поле обязательно для заполнения, если документ передается между контрагентами в рамках обмена по видам
     * сведения ФССП России начиная с версии 1.1.0 | Обертка стандартного xs:boolean | Логический
     * - minOccurs: 0
     * @var bool
     */
    public $IsUnstructuredFormat;
    /**
     * The IsZippedPacket
     * Meta informations extracted from the WSDL
     * - documentation: Содержимое вложения упаковано Zip-алгоритмом | Устанавливается в true в случае, если вложение (передается в элементе «Данные
     * документа») упаковано Zip-алгоритмом. Поле обязательно для заполнения, если документ передается между контрагентами в рамках обмена по
     * видам сведения ФССП России начиная с версии 1.1.0 | Обертка стандартного xs:boolean | Логический
     * - minOccurs: 0
     * @var bool
     */
    public $IsZippedPacket;
    /**
     * The StructuredFormatType
     * Meta informations extracted from the WSDL
     * - documentation: Пространство имен структурированного формата | Указывается пространство имен для вложений, имеющих структурированный формат.
     * Поле обязательно для заполнения, если документ передается между контрагентами в рамках обмена по видам сведения ФССП России начиная с
     * версии 1.1.0
     * - minOccurs: 0
     * @var string
     */
    public $StructuredFormatType;
    /**
     * Constructor method for InformationDocument
     * @uses InformationDocument::setOrganization()
     * @uses InformationDocument::setDepartment()
     * @uses InformationDocument::setOrganizationRecipient()
     * @uses InformationDocument::setDepartmentRecipient()
     * @uses InformationDocument::setID()
     * @uses InformationDocument::setIncomingDocKey()
     * @uses InformationDocument::setType()
     * @uses InformationDocument::setDocumentDate()
     * @uses InformationDocument::setDocumentNumber()
     * @uses InformationDocument::setDocumentCaseNumber()
     * @uses InformationDocument::setFilename()
     * @uses InformationDocument::setContent()
     * @uses InformationDocument::setIsUnstructuredFormat()
     * @uses InformationDocument::setIsZippedPacket()
     * @uses InformationDocument::setStructuredFormatType()
     * @param string $organization
     * @param string $department
     * @param string $organizationRecipient
     * @param string $departmentRecipient
     * @param string $iD
     * @param string $incomingDocKey
     * @param string $type
     * @param string $documentDate
     * @param string $documentNumber
     * @param string $documentCaseNumber
     * @param string $filename
     * @param string $content
     * @param bool $isUnstructuredFormat
     * @param bool $isZippedPacket
     * @param string $structuredFormatType
     */
    public function __construct($organization = null, $department = null, $organizationRecipient = null, $departmentRecipient = null, $iD = null, $incomingDocKey = null, $type = null, $documentDate = null, $documentNumber = null, $documentCaseNumber = null, $filename = null, $content = null, $isUnstructuredFormat = null, $isZippedPacket = null, $structuredFormatType = null)
    {
        $this
            ->setOrganization($organization)
            ->setDepartment($department)
            ->setOrganizationRecipient($organizationRecipient)
            ->setDepartmentRecipient($departmentRecipient)
            ->setID($iD)
            ->setIncomingDocKey($incomingDocKey)
            ->setType($type)
            ->setDocumentDate($documentDate)
            ->setDocumentNumber($documentNumber)
            ->setDocumentCaseNumber($documentCaseNumber)
            ->setFilename($filename)
            ->setContent($content)
            ->setIsUnstructuredFormat($isUnstructuredFormat)
            ->setIsZippedPacket($isZippedPacket)
            ->setStructuredFormatType($structuredFormatType);
    }
    /**
     * Get Organization value
     * @return string|null
     */
    public function getOrganization()
    {
        return $this->Organization;
    }
    /**
     * Set Organization value
     * @param string $organization
     * @return \StructType\InformationDocument
     */
    public function setOrganization($organization = null)
    {
        $this->Organization = $organization;
        return $this;
    }
    /**
     * Get Department value
     * @return string|null
     */
    public function getDepartment()
    {
        return $this->Department;
    }
    /**
     * Set Department value
     * @param string $department
     * @return \StructType\InformationDocument
     */
    public function setDepartment($department = null)
    {
        $this->Department = $department;
        return $this;
    }
    /**
     * Get OrganizationRecipient value
     * @return string|null
     */
    public function getOrganizationRecipient()
    {
        return $this->OrganizationRecipient;
    }
    /**
     * Set OrganizationRecipient value
     * @param string $organizationRecipient
     * @return \StructType\InformationDocument
     */
    public function setOrganizationRecipient($organizationRecipient = null)
    {
        $this->OrganizationRecipient = $organizationRecipient;
        return $this;
    }
    /**
     * Get DepartmentRecipient value
     * @return string|null
     */
    public function getDepartmentRecipient()
    {
        return $this->DepartmentRecipient;
    }
    /**
     * Set DepartmentRecipient value
     * @param string $departmentRecipient
     * @return \StructType\InformationDocument
     */
    public function setDepartmentRecipient($departmentRecipient = null)
    {
        $this->DepartmentRecipient = $departmentRecipient;
        return $this;
    }
    /**
     * Get ID value
     * @return string|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param string $iD
     * @return \StructType\InformationDocument
     */
    public function setID($iD = null)
    {
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get IncomingDocKey value
     * @return string|null
     */
    public function getIncomingDocKey()
    {
        return $this->IncomingDocKey;
    }
    /**
     * Set IncomingDocKey value
     * @param string $incomingDocKey
     * @return \StructType\InformationDocument
     */
    public function setIncomingDocKey($incomingDocKey = null)
    {
        $this->IncomingDocKey = $incomingDocKey;
        return $this;
    }
    /**
     * Get Type value
     * @return string|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param string $type
     * @return \StructType\InformationDocument
     */
    public function setType($type = null)
    {
        $this->Type = $type;
        return $this;
    }
    /**
     * Get DocumentDate value
     * @return string|null
     */
    public function getDocumentDate()
    {
        return $this->DocumentDate;
    }
    /**
     * Set DocumentDate value
     * @param string $documentDate
     * @return \StructType\InformationDocument
     */
    public function setDocumentDate($documentDate = null)
    {
        $this->DocumentDate = $documentDate;
        return $this;
    }
    /**
     * Get DocumentNumber value
     * @return string|null
     */
    public function getDocumentNumber()
    {
        return $this->DocumentNumber;
    }
    /**
     * Set DocumentNumber value
     * @param string $documentNumber
     * @return \StructType\InformationDocument
     */
    public function setDocumentNumber($documentNumber = null)
    {
        $this->DocumentNumber = $documentNumber;
        return $this;
    }
    /**
     * Get DocumentCaseNumber value
     * @return string|null
     */
    public function getDocumentCaseNumber()
    {
        return $this->DocumentCaseNumber;
    }
    /**
     * Set DocumentCaseNumber value
     * @param string $documentCaseNumber
     * @return \StructType\InformationDocument
     */
    public function setDocumentCaseNumber($documentCaseNumber = null)
    {
        $this->DocumentCaseNumber = $documentCaseNumber;
        return $this;
    }
    /**
     * Get Filename value
     * @return string|null
     */
    public function getFilename()
    {
        return $this->Filename;
    }
    /**
     * Set Filename value
     * @param string $filename
     * @return \StructType\InformationDocument
     */
    public function setFilename($filename = null)
    {
        $this->Filename = $filename;
        return $this;
    }
    /**
     * Get Content value
     * @return string|null
     */
    public function getContent()
    {
        return $this->Content;
    }
    /**
     * Set Content value
     * @param string $content
     * @return \StructType\InformationDocument
     */
    public function setContent($content = null)
    {
        $this->Content = $content;
        return $this;
    }
    /**
     * Get IsUnstructuredFormat value
     * @return bool|null
     */
    public function getIsUnstructuredFormat()
    {
        return $this->IsUnstructuredFormat;
    }
    /**
     * Set IsUnstructuredFormat value
     * @param bool $isUnstructuredFormat
     * @return \StructType\InformationDocument
     */
    public function setIsUnstructuredFormat($isUnstructuredFormat = null)
    {
        $this->IsUnstructuredFormat = $isUnstructuredFormat;
        return $this;
    }
    /**
     * Get IsZippedPacket value
     * @return bool|null
     */
    public function getIsZippedPacket()
    {
        return $this->IsZippedPacket;
    }
    /**
     * Set IsZippedPacket value
     * @param bool $isZippedPacket
     * @return \StructType\InformationDocument
     */
    public function setIsZippedPacket($isZippedPacket = null)
    {
        $this->IsZippedPacket = $isZippedPacket;
        return $this;
    }
    /**
     * Get StructuredFormatType value
     * @return string|null
     */
    public function getStructuredFormatType()
    {
        return $this->StructuredFormatType;
    }
    /**
     * Set StructuredFormatType value
     * @param string $structuredFormatType
     * @return \StructType\InformationDocument
     */
    public function setStructuredFormatType($structuredFormatType = null)
    {
        $this->StructuredFormatType = $structuredFormatType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\InformationDocument
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
