<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for IncomingForcedExecDocumentBrief StructType
 * Meta informations extracted from the WSDL
 * - documentation: Тип данных документа «Входящий документ принудительного исполнения (краткая форма)» используется для предоставления
 * информации внешнему контрагенту о документе в составе списка документов.
 * - type: tns:IncomingForcedExecDocumentBrief
 * @subpackage Structs
 */
class IncomingForcedExecDocumentBrief extends AbstractStructBase
{
    /**
     * The ExternalKey
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор документа в АИС внешних контрагентов | Идентификатор объекта, присвоенный объекту АИС внешнего контрагентом
     * (ФНС, ПФР и прочие). Данный идентификатор должен быть уникальным для типа идентифицируемого документа в пространстве обмена данными с
     * конкретным внешним контрагентом.
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $ExternalKey;
    /**
     * The DocType
     * Meta informations extracted from the WSDL
     * - documentation: Тип документа АИС ФССП России (тип документа ПКОСП) | Тип документа электронного документооборота | NSI_Document | Наименование
     * объекта NCORE
     * - maxLength: 31 | 31
     * - minLength: 1 | 1
     * @var string
     */
    public $DocType;
    /**
     * The DocNumber
     * Meta informations extracted from the WSDL
     * - documentation: Номер документа
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $DocNumber;
    /**
     * The DocDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата | Дата
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $DocDate;
    /**
     * The SideProperties
     * Meta informations extracted from the WSDL
     * - documentation: Реквизиты стороны ИП
     * @var \StructType\ContragentDatumType
     */
    public $SideProperties;
    /**
     * The Status
     * Meta informations extracted from the WSDL
     * - documentation: Статус заявления
     * @var string
     */
    public $Status;
    /**
     * Constructor method for IncomingForcedExecDocumentBrief
     * @uses IncomingForcedExecDocumentBrief::setExternalKey()
     * @uses IncomingForcedExecDocumentBrief::setDocType()
     * @uses IncomingForcedExecDocumentBrief::setDocNumber()
     * @uses IncomingForcedExecDocumentBrief::setDocDate()
     * @uses IncomingForcedExecDocumentBrief::setSideProperties()
     * @uses IncomingForcedExecDocumentBrief::setStatus()
     * @param string $externalKey
     * @param string $docType
     * @param string $docNumber
     * @param string $docDate
     * @param \StructType\ContragentDatumType $sideProperties
     * @param string $status
     */
    public function __construct($externalKey = null, $docType = null, $docNumber = null, $docDate = null, \StructType\ContragentDatumType $sideProperties = null, $status = null)
    {
        $this
            ->setExternalKey($externalKey)
            ->setDocType($docType)
            ->setDocNumber($docNumber)
            ->setDocDate($docDate)
            ->setSideProperties($sideProperties)
            ->setStatus($status);
    }
    /**
     * Get ExternalKey value
     * @return string|null
     */
    public function getExternalKey()
    {
        return $this->ExternalKey;
    }
    /**
     * Set ExternalKey value
     * @param string $externalKey
     * @return \StructType\IncomingForcedExecDocumentBrief
     */
    public function setExternalKey($externalKey = null)
    {
        $this->ExternalKey = $externalKey;
        return $this;
    }
    /**
     * Get DocType value
     * @return string|null
     */
    public function getDocType()
    {
        return $this->DocType;
    }
    /**
     * Set DocType value
     * @param string $docType
     * @return \StructType\IncomingForcedExecDocumentBrief
     */
    public function setDocType($docType = null)
    {
        $this->DocType = $docType;
        return $this;
    }
    /**
     * Get DocNumber value
     * @return string|null
     */
    public function getDocNumber()
    {
        return $this->DocNumber;
    }
    /**
     * Set DocNumber value
     * @param string $docNumber
     * @return \StructType\IncomingForcedExecDocumentBrief
     */
    public function setDocNumber($docNumber = null)
    {
        $this->DocNumber = $docNumber;
        return $this;
    }
    /**
     * Get DocDate value
     * @return string|null
     */
    public function getDocDate()
    {
        return $this->DocDate;
    }
    /**
     * Set DocDate value
     * @param string $docDate
     * @return \StructType\IncomingForcedExecDocumentBrief
     */
    public function setDocDate($docDate = null)
    {
        $this->DocDate = $docDate;
        return $this;
    }
    /**
     * Get SideProperties value
     * @return \StructType\ContragentDatumType|null
     */
    public function getSideProperties()
    {
        return $this->SideProperties;
    }
    /**
     * Set SideProperties value
     * @param \StructType\ContragentDatumType $sideProperties
     * @return \StructType\IncomingForcedExecDocumentBrief
     */
    public function setSideProperties(\StructType\ContragentDatumType $sideProperties = null)
    {
        $this->SideProperties = $sideProperties;
        return $this;
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @uses \EnumType\ApplicationStatus::valueIsValid()
     * @uses \EnumType\ApplicationStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \StructType\IncomingForcedExecDocumentBrief
     */
    public function setStatus($status = null)
    {
        $this->Status = $status;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\IncomingForcedExecDocumentBrief
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
