<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for IncomingEMailMessage StructType
 * Meta informations extracted from the WSDL
 * - documentation: Входящее сообщение ведомственной электронной почты
 * - type: tns:IncomingEMailMessage
 * @subpackage Structs
 */
class IncomingEMailMessage extends AbstractStructBase
{
    /**
     * The Recipient
     * Meta informations extracted from the WSDL
     * - documentation: Получатель | Адрес электронной почты
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * - maxLength: 100
     * - minLength: 1
     * @var string[]
     */
    public $Recipient;
    /**
     * The InternalKey
     * Meta informations extracted from the WSDL
     * - documentation: Ключ сообщения (присваивается сервером МВВ) | Ключ объекта, присвоенний информационной системой ФССП РФ при создании объекта
     * или при получении объекта от контрагента
     * - maxInclusive: 9223372036854775807
     * - minInclusive: -9223372036854775808
     * @var int
     */
    public $InternalKey;
    /**
     * The MessageId
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор сообщения почтового сервера | Идентификатор сообщения электронной почты
     * - maxLength: 255
     * - minLength: 1
     * @var string
     */
    public $MessageId;
    /**
     * The Sender
     * Meta informations extracted from the WSDL
     * - documentation: Отправитель | Адрес электронной почты
     * - maxLength: 100
     * - minLength: 1
     * @var string
     */
    public $Sender;
    /**
     * The CC
     * Meta informations extracted from the WSDL
     * - documentation: Копия | Адрес электронной почты
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - maxLength: 100
     * - minLength: 1
     * @var string[]
     */
    public $CC;
    /**
     * The Subject
     * Meta informations extracted from the WSDL
     * - documentation: Тема | Строка длиной от 1 до 1000 символов
     * - maxLength: 1000
     * - minLength: 1
     * @var string
     */
    public $Subject;
    /**
     * The Header
     * Meta informations extracted from the WSDL
     * - documentation: Заголовки
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\EMailHeaderType[]
     */
    public $Header;
    /**
     * The Text
     * Meta informations extracted from the WSDL
     * - documentation: Текст сообщения | Массив произвольных данных (текстовый)
     * @var string
     */
    public $Text;
    /**
     * The Attachment
     * Meta informations extracted from the WSDL
     * - documentation: Вложения
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\AttachmentType[]
     */
    public $Attachment;
    /**
     * Constructor method for IncomingEMailMessage
     * @uses IncomingEMailMessage::setRecipient()
     * @uses IncomingEMailMessage::setInternalKey()
     * @uses IncomingEMailMessage::setMessageId()
     * @uses IncomingEMailMessage::setSender()
     * @uses IncomingEMailMessage::setCC()
     * @uses IncomingEMailMessage::setSubject()
     * @uses IncomingEMailMessage::setHeader()
     * @uses IncomingEMailMessage::setText()
     * @uses IncomingEMailMessage::setAttachment()
     * @param string[] $recipient
     * @param int $internalKey
     * @param string $messageId
     * @param string $sender
     * @param string[] $cC
     * @param string $subject
     * @param \StructType\EMailHeaderType[] $header
     * @param string $text
     * @param \StructType\AttachmentType[] $attachment
     */
    public function __construct(array $recipient = array(), $internalKey = null, $messageId = null, $sender = null, array $cC = array(), $subject = null, array $header = array(), $text = null, array $attachment = array())
    {
        $this
            ->setRecipient($recipient)
            ->setInternalKey($internalKey)
            ->setMessageId($messageId)
            ->setSender($sender)
            ->setCC($cC)
            ->setSubject($subject)
            ->setHeader($header)
            ->setText($text)
            ->setAttachment($attachment);
    }
    /**
     * Get Recipient value
     * @return string[]
     */
    public function getRecipient()
    {
        return $this->Recipient;
    }
    /**
     * Set Recipient value
     * @throws \InvalidArgumentException
     * @param string[] $recipient
     * @return \StructType\IncomingEMailMessage
     */
    public function setRecipient(array $recipient = array())
    {
        $this->Recipient = $recipient;
        return $this;
    }
    /**
     * Add item to Recipient value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\IncomingEMailMessage
     */
    public function addToRecipient($item)
    {
        $this->Recipient[] = $item;
        return $this;
    }
    /**
     * Get InternalKey value
     * @return int|null
     */
    public function getInternalKey()
    {
        return $this->InternalKey;
    }
    /**
     * Set InternalKey value
     * @param int $internalKey
     * @return \StructType\IncomingEMailMessage
     */
    public function setInternalKey($internalKey = null)
    {
        $this->InternalKey = $internalKey;
        return $this;
    }
    /**
     * Get MessageId value
     * @return string|null
     */
    public function getMessageId()
    {
        return $this->MessageId;
    }
    /**
     * Set MessageId value
     * @param string $messageId
     * @return \StructType\IncomingEMailMessage
     */
    public function setMessageId($messageId = null)
    {
        $this->MessageId = $messageId;
        return $this;
    }
    /**
     * Get Sender value
     * @return string|null
     */
    public function getSender()
    {
        return $this->Sender;
    }
    /**
     * Set Sender value
     * @param string $sender
     * @return \StructType\IncomingEMailMessage
     */
    public function setSender($sender = null)
    {
        $this->Sender = $sender;
        return $this;
    }
    /**
     * Get CC value
     * @return string[]|null
     */
    public function getCC()
    {
        return $this->CC;
    }
    /**
     * Set CC value
     * @throws \InvalidArgumentException
     * @param string[] $cC
     * @return \StructType\IncomingEMailMessage
     */
    public function setCC(array $cC = array())
    {
        $this->CC = $cC;
        return $this;
    }
    /**
     * Add item to CC value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\IncomingEMailMessage
     */
    public function addToCC($item)
    {
        $this->CC[] = $item;
        return $this;
    }
    /**
     * Get Subject value
     * @return string|null
     */
    public function getSubject()
    {
        return $this->Subject;
    }
    /**
     * Set Subject value
     * @param string $subject
     * @return \StructType\IncomingEMailMessage
     */
    public function setSubject($subject = null)
    {
        $this->Subject = $subject;
        return $this;
    }
    /**
     * Get Header value
     * @return \StructType\EMailHeaderType[]|null
     */
    public function getHeader()
    {
        return $this->Header;
    }
    /**
     * Set Header value
     * @throws \InvalidArgumentException
     * @param \StructType\EMailHeaderType[] $header
     * @return \StructType\IncomingEMailMessage
     */
    public function setHeader(array $header = array())
    {
        $this->Header = $header;
        return $this;
    }
    /**
     * Add item to Header value
     * @throws \InvalidArgumentException
     * @param \StructType\EMailHeaderType $item
     * @return \StructType\IncomingEMailMessage
     */
    public function addToHeader(\StructType\EMailHeaderType $item)
    {
        $this->Header[] = $item;
        return $this;
    }
    /**
     * Get Text value
     * @return string|null
     */
    public function getText()
    {
        return $this->Text;
    }
    /**
     * Set Text value
     * @param string $text
     * @return \StructType\IncomingEMailMessage
     */
    public function setText($text = null)
    {
        $this->Text = $text;
        return $this;
    }
    /**
     * Get Attachment value
     * @return \StructType\AttachmentType[]|null
     */
    public function getAttachment()
    {
        return $this->Attachment;
    }
    /**
     * Set Attachment value
     * @throws \InvalidArgumentException
     * @param \StructType\AttachmentType[] $attachment
     * @return \StructType\IncomingEMailMessage
     */
    public function setAttachment(array $attachment = array())
    {
        $this->Attachment = $attachment;
        return $this;
    }
    /**
     * Add item to Attachment value
     * @throws \InvalidArgumentException
     * @param \StructType\AttachmentType $item
     * @return \StructType\IncomingEMailMessage
     */
    public function addToAttachment(\StructType\AttachmentType $item)
    {
        $this->Attachment[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\IncomingEMailMessage
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
