<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for IdentificationDataType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Тип сведений IdentificationDataType "Удостоверение личности" | Используется для передачи информации о документах физического лица
 * @subpackage Structs
 */
class IdentificationDataType extends InformationType
{
    /**
     * The TypeDoc
     * Meta informations extracted from the WSDL
     * - documentation: Код типа документа | Код типа документа из справочника документов, удостоверяющих личность | Код типа документа,
     * удостоверяющего личность
     * - length: 2
     * - pattern: [0-9]{2}
     * @var string
     */
    public $TypeDoc;
    /**
     * The NameDoc
     * Meta informations extracted from the WSDL
     * - documentation: Наименование типа документа | Строка длиной от 1 до 255 символов
     * - minOccurs: 0
     * - maxLength: 255
     * - minLength: 1
     * @var string
     */
    public $NameDoc;
    /**
     * The SerDoc
     * Meta informations extracted from the WSDL
     * - documentation: Серия документа | Серия документа, удостоверяющего личность. В случае невозможности разделить серию и номер документа, серия
     * документа хранится вместе с номером в поле "Номер документа" | Строка длиной от 1 до 25 символов
     * - minOccurs: 0
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $SerDoc;
    /**
     * The NumDoc
     * Meta informations extracted from the WSDL
     * - documentation: Номер документа | Номер документа, удостоверяющего личность | Строка длиной от 1 до 25 символов
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $NumDoc;
    /**
     * The IssuedDoc
     * Meta informations extracted from the WSDL
     * - documentation: Наименование подразделения | Наименование подразделения, выдавшего документ | Строка длиной от 1 до 300 символов
     * - minOccurs: 0
     * - maxLength: 300
     * - minLength: 1
     * @var string
     */
    public $IssuedDoc;
    /**
     * The DateDoc
     * Meta informations extracted from the WSDL
     * - documentation: Дата выдачи документа | Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $DateDoc;
    /**
     * The CodeDep
     * Meta informations extracted from the WSDL
     * - documentation: Код подразделения | Строка длиной от 1 до 7 символов
     * - minOccurs: 0
     * - maxLength: 7
     * - minLength: 1
     * @var string
     */
    public $CodeDep;
    /**
     * The FIODoc
     * Meta informations extracted from the WSDL
     * - documentation: ФИО | Фамилия, имя, отчество по документу. Используется только для обмена с организациями, поддерживающими передачу этих данных
     * - minOccurs: 0
     * @var \StructType\FioType
     */
    public $FIODoc;
    /**
     * The birthDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата рождения | Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $birthDate;
    /**
     * The birthPlace
     * Meta informations extracted from the WSDL
     * - documentation: Место рождения | Строка длиной от 1 до 300 символов
     * - minOccurs: 0
     * - maxLength: 300
     * - minLength: 1
     * @var string
     */
    public $birthPlace;
    /**
     * The isValid
     * Meta informations extracted from the WSDL
     * - documentation: Признак действующего документа | Обертка стандартного xs:boolean | Логический
     * - minOccurs: 0
     * @var bool
     */
    public $isValid;
    /**
     * The invalidateReasonCode
     * Meta informations extracted from the WSDL
     * - documentation: Код причины недействительности | Код причины недействительности документа
     * - minOccurs: 0
     * - length: 1
     * @var string
     */
    public $invalidateReasonCode;
    /**
     * The INN
     * Meta informations extracted from the WSDL
     * - documentation: ИНН | ИНН Физического лица
     * - minOccurs: 0
     * - length: 12
     * - pattern: ([0-9]{1}[1-9]{1}|[1-9]{1}[0-9]{1})[0-9]{10}
     * @var string
     */
    public $INN;
    /**
     * The gender
     * Meta informations extracted from the WSDL
     * - documentation: Пол
     * - minOccurs: 0
     * @var string
     */
    public $gender;
    /**
     * The countryCode
     * Meta informations extracted from the WSDL
     * - documentation: Код страны | Код страны буквенный | Трехзначный (альфа-3) буквенный код страны мира по классификатору ОКСМ
     * - minOccurs: 0
     * - length: 3
     * @var string
     */
    public $countryCode;
    /**
     * The StrAddr
     * Meta informations extracted from the WSDL
     * - documentation: Адрес | Адрес по документу. Используется только для обмена с организациями, поддерживающими передачу этих данных | Строка
     * длиной от 1 до 300 символов
     * - minOccurs: 0
     * - maxLength: 300
     * - minLength: 1
     * @var string
     */
    public $StrAddr;
    /**
     * Constructor method for IdentificationDataType
     * @uses IdentificationDataType::setTypeDoc()
     * @uses IdentificationDataType::setNameDoc()
     * @uses IdentificationDataType::setSerDoc()
     * @uses IdentificationDataType::setNumDoc()
     * @uses IdentificationDataType::setIssuedDoc()
     * @uses IdentificationDataType::setDateDoc()
     * @uses IdentificationDataType::setCodeDep()
     * @uses IdentificationDataType::setFIODoc()
     * @uses IdentificationDataType::setBirthDate()
     * @uses IdentificationDataType::setBirthPlace()
     * @uses IdentificationDataType::setIsValid()
     * @uses IdentificationDataType::setInvalidateReasonCode()
     * @uses IdentificationDataType::setINN()
     * @uses IdentificationDataType::setGender()
     * @uses IdentificationDataType::setCountryCode()
     * @uses IdentificationDataType::setStrAddr()
     * @param string $typeDoc
     * @param string $nameDoc
     * @param string $serDoc
     * @param string $numDoc
     * @param string $issuedDoc
     * @param string $dateDoc
     * @param string $codeDep
     * @param \StructType\FioType $fIODoc
     * @param string $birthDate
     * @param string $birthPlace
     * @param bool $isValid
     * @param string $invalidateReasonCode
     * @param string $iNN
     * @param string $gender
     * @param string $countryCode
     * @param string $strAddr
     */
    public function __construct($typeDoc = null, $nameDoc = null, $serDoc = null, $numDoc = null, $issuedDoc = null, $dateDoc = null, $codeDep = null, \StructType\FioType $fIODoc = null, $birthDate = null, $birthPlace = null, $isValid = null, $invalidateReasonCode = null, $iNN = null, $gender = null, $countryCode = null, $strAddr = null)
    {
        $this
            ->setTypeDoc($typeDoc)
            ->setNameDoc($nameDoc)
            ->setSerDoc($serDoc)
            ->setNumDoc($numDoc)
            ->setIssuedDoc($issuedDoc)
            ->setDateDoc($dateDoc)
            ->setCodeDep($codeDep)
            ->setFIODoc($fIODoc)
            ->setBirthDate($birthDate)
            ->setBirthPlace($birthPlace)
            ->setIsValid($isValid)
            ->setInvalidateReasonCode($invalidateReasonCode)
            ->setINN($iNN)
            ->setGender($gender)
            ->setCountryCode($countryCode)
            ->setStrAddr($strAddr);
    }
    /**
     * Get TypeDoc value
     * @return string|null
     */
    public function getTypeDoc()
    {
        return $this->TypeDoc;
    }
    /**
     * Set TypeDoc value
     * @param string $typeDoc
     * @return \StructType\IdentificationDataType
     */
    public function setTypeDoc($typeDoc = null)
    {
        $this->TypeDoc = $typeDoc;
        return $this;
    }
    /**
     * Get NameDoc value
     * @return string|null
     */
    public function getNameDoc()
    {
        return $this->NameDoc;
    }
    /**
     * Set NameDoc value
     * @param string $nameDoc
     * @return \StructType\IdentificationDataType
     */
    public function setNameDoc($nameDoc = null)
    {
        $this->NameDoc = $nameDoc;
        return $this;
    }
    /**
     * Get SerDoc value
     * @return string|null
     */
    public function getSerDoc()
    {
        return $this->SerDoc;
    }
    /**
     * Set SerDoc value
     * @param string $serDoc
     * @return \StructType\IdentificationDataType
     */
    public function setSerDoc($serDoc = null)
    {
        $this->SerDoc = $serDoc;
        return $this;
    }
    /**
     * Get NumDoc value
     * @return string|null
     */
    public function getNumDoc()
    {
        return $this->NumDoc;
    }
    /**
     * Set NumDoc value
     * @param string $numDoc
     * @return \StructType\IdentificationDataType
     */
    public function setNumDoc($numDoc = null)
    {
        $this->NumDoc = $numDoc;
        return $this;
    }
    /**
     * Get IssuedDoc value
     * @return string|null
     */
    public function getIssuedDoc()
    {
        return $this->IssuedDoc;
    }
    /**
     * Set IssuedDoc value
     * @param string $issuedDoc
     * @return \StructType\IdentificationDataType
     */
    public function setIssuedDoc($issuedDoc = null)
    {
        $this->IssuedDoc = $issuedDoc;
        return $this;
    }
    /**
     * Get DateDoc value
     * @return string|null
     */
    public function getDateDoc()
    {
        return $this->DateDoc;
    }
    /**
     * Set DateDoc value
     * @param string $dateDoc
     * @return \StructType\IdentificationDataType
     */
    public function setDateDoc($dateDoc = null)
    {
        $this->DateDoc = $dateDoc;
        return $this;
    }
    /**
     * Get CodeDep value
     * @return string|null
     */
    public function getCodeDep()
    {
        return $this->CodeDep;
    }
    /**
     * Set CodeDep value
     * @param string $codeDep
     * @return \StructType\IdentificationDataType
     */
    public function setCodeDep($codeDep = null)
    {
        $this->CodeDep = $codeDep;
        return $this;
    }
    /**
     * Get FIODoc value
     * @return \StructType\FioType|null
     */
    public function getFIODoc()
    {
        return $this->FIODoc;
    }
    /**
     * Set FIODoc value
     * @param \StructType\FioType $fIODoc
     * @return \StructType\IdentificationDataType
     */
    public function setFIODoc(\StructType\FioType $fIODoc = null)
    {
        $this->FIODoc = $fIODoc;
        return $this;
    }
    /**
     * Get birthDate value
     * @return string|null
     */
    public function getBirthDate()
    {
        return $this->birthDate;
    }
    /**
     * Set birthDate value
     * @param string $birthDate
     * @return \StructType\IdentificationDataType
     */
    public function setBirthDate($birthDate = null)
    {
        $this->birthDate = $birthDate;
        return $this;
    }
    /**
     * Get birthPlace value
     * @return string|null
     */
    public function getBirthPlace()
    {
        return $this->birthPlace;
    }
    /**
     * Set birthPlace value
     * @param string $birthPlace
     * @return \StructType\IdentificationDataType
     */
    public function setBirthPlace($birthPlace = null)
    {
        $this->birthPlace = $birthPlace;
        return $this;
    }
    /**
     * Get isValid value
     * @return bool|null
     */
    public function getIsValid()
    {
        return $this->isValid;
    }
    /**
     * Set isValid value
     * @param bool $isValid
     * @return \StructType\IdentificationDataType
     */
    public function setIsValid($isValid = null)
    {
        $this->isValid = $isValid;
        return $this;
    }
    /**
     * Get invalidateReasonCode value
     * @return string|null
     */
    public function getInvalidateReasonCode()
    {
        return $this->invalidateReasonCode;
    }
    /**
     * Set invalidateReasonCode value
     * @param string $invalidateReasonCode
     * @return \StructType\IdentificationDataType
     */
    public function setInvalidateReasonCode($invalidateReasonCode = null)
    {
        $this->invalidateReasonCode = $invalidateReasonCode;
        return $this;
    }
    /**
     * Get INN value
     * @return string|null
     */
    public function getINN()
    {
        return $this->INN;
    }
    /**
     * Set INN value
     * @param string $iNN
     * @return \StructType\IdentificationDataType
     */
    public function setINN($iNN = null)
    {
        $this->INN = $iNN;
        return $this;
    }
    /**
     * Get gender value
     * @return string|null
     */
    public function getGender()
    {
        return $this->gender;
    }
    /**
     * Set gender value
     * @uses \EnumType\GenderCodeType::valueIsValid()
     * @uses \EnumType\GenderCodeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $gender
     * @return \StructType\IdentificationDataType
     */
    public function setGender($gender = null)
    {
        $this->gender = $gender;
        return $this;
    }
    /**
     * Get countryCode value
     * @return string|null
     */
    public function getCountryCode()
    {
        return $this->countryCode;
    }
    /**
     * Set countryCode value
     * @param string $countryCode
     * @return \StructType\IdentificationDataType
     */
    public function setCountryCode($countryCode = null)
    {
        $this->countryCode = $countryCode;
        return $this;
    }
    /**
     * Get StrAddr value
     * @return string|null
     */
    public function getStrAddr()
    {
        return $this->StrAddr;
    }
    /**
     * Set StrAddr value
     * @param string $strAddr
     * @return \StructType\IdentificationDataType
     */
    public function setStrAddr($strAddr = null)
    {
        $this->StrAddr = $strAddr;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\IdentificationDataType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
