<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for IdDocTypeProperty StructType
 * Meta informations extracted from the WSDL
 * - documentation: Код типа документа, удостоверяющего личность
 * @subpackage Structs
 */
class IdDocTypeProperty extends AbstractStructBase
{
    /**
     * The code
     * Meta informations extracted from the WSDL
     * - documentation: Код вида документа | Код типа документа, удостоверяющего личность
     * - minOccurs: 0
     * - length: 2
     * - pattern: [0-9]{2}
     * @var string
     */
    public $code;
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - documentation: Наименование вида документа | Строка длиной от 1 до 150 символов
     * - minOccurs: 0
     * - maxLength: 150
     * - minLength: 1
     * @var string
     */
    public $name;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - documentation: Описание документа | Строка длиной от 1 до 1000 символов
     * - minOccurs: 0
     * - maxLength: 1000
     * - minLength: 1
     * @var string
     */
    public $description;
    /**
     * Constructor method for IdDocTypeProperty
     * @uses IdDocTypeProperty::setCode()
     * @uses IdDocTypeProperty::setName()
     * @uses IdDocTypeProperty::setDescription()
     * @param string $code
     * @param string $name
     * @param string $description
     */
    public function __construct($code = null, $name = null, $description = null)
    {
        $this
            ->setCode($code)
            ->setName($name)
            ->setDescription($description);
    }
    /**
     * Get code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->code;
    }
    /**
     * Set code value
     * @param string $code
     * @return \StructType\IdDocTypeProperty
     */
    public function setCode($code = null)
    {
        $this->code = $code;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\IdDocTypeProperty
     */
    public function setName($name = null)
    {
        $this->name = $name;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\IdDocTypeProperty
     */
    public function setDescription($description = null)
    {
        $this->description = $description;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\IdDocTypeProperty
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
