<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for IPSideRequestType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Тип данных IPSideRequestType «Регистрация запроса стороны ИП в ОСП (абстрактный)»
 * @subpackage Structs
 */
abstract class IPSideRequestType extends AbstractStructBase
{
    /**
     * The reqeustKey
     * Meta informations extracted from the WSDL
     * - documentation: Ключ запроса ЕПГУ | Идентификатор объекта, присвоенный объекту АИС внешнего контрагентом (ФНС, ПФР и прочие). Данный
     * идентификатор должен быть уникальным для типа идентифицируемого документа в пространстве обмена данными с конкретным внешним
     * контрагентом.
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $reqeustKey;
    /**
     * The sideType
     * Meta informations extracted from the WSDL
     * - documentation: Тип стороны ИП
     * - minOccurs: 0
     * @var string
     */
    public $sideType;
    /**
     * The side
     * Meta informations extracted from the WSDL
     * - documentation: Сторона ИП
     * @var \StructType\ContragentDatumType
     */
    public $side;
    /**
     * The representative
     * Meta informations extracted from the WSDL
     * - documentation: Представитель | Заполняется в том случае, если пользователь портала госуслуг представляет сторону ИП
     * - minOccurs: 0
     * @var \StructType\ContragentDatumType
     */
    public $representative;
    /**
     * The debtor
     * Meta informations extracted from the WSDL
     * - documentation: Должник
     * @var \StructType\ContragentDatumType
     */
    public $debtor;
    /**
     * The ospCode
     * Meta informations extracted from the WSDL
     * - documentation: Код отдела судебных приставов | Код ОСП, в адрес которого направляется заявление | Ведомственный классификатор отделов
     * судебных приставов | NSI_Departments
     * - length: 5
     * - pattern: [0-9]{5}
     * @var string
     */
    public $ospCode;
    /**
     * The requestDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата запроса | Дата | Дата
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $requestDate;
    /**
     * The EApplication
     * Meta informations extracted from the WSDL
     * - documentation: Электронное обращение
     * - minOccurs: 0
     * @var \StructType\EmbeddedDocumentType
     */
    public $EApplication;
    /**
     * Constructor method for IPSideRequestType
     * @uses IPSideRequestType::setReqeustKey()
     * @uses IPSideRequestType::setSideType()
     * @uses IPSideRequestType::setSide()
     * @uses IPSideRequestType::setRepresentative()
     * @uses IPSideRequestType::setDebtor()
     * @uses IPSideRequestType::setOspCode()
     * @uses IPSideRequestType::setRequestDate()
     * @uses IPSideRequestType::setEApplication()
     * @param string $reqeustKey
     * @param string $sideType
     * @param \StructType\ContragentDatumType $side
     * @param \StructType\ContragentDatumType $representative
     * @param \StructType\ContragentDatumType $debtor
     * @param string $ospCode
     * @param string $requestDate
     * @param \StructType\EmbeddedDocumentType $eApplication
     */
    public function __construct($reqeustKey = null, $sideType = null, \StructType\ContragentDatumType $side = null, \StructType\ContragentDatumType $representative = null, \StructType\ContragentDatumType $debtor = null, $ospCode = null, $requestDate = null, \StructType\EmbeddedDocumentType $eApplication = null)
    {
        $this
            ->setReqeustKey($reqeustKey)
            ->setSideType($sideType)
            ->setSide($side)
            ->setRepresentative($representative)
            ->setDebtor($debtor)
            ->setOspCode($ospCode)
            ->setRequestDate($requestDate)
            ->setEApplication($eApplication);
    }
    /**
     * Get reqeustKey value
     * @return string|null
     */
    public function getReqeustKey()
    {
        return $this->reqeustKey;
    }
    /**
     * Set reqeustKey value
     * @param string $reqeustKey
     * @return \StructType\IPSideRequestType
     */
    public function setReqeustKey($reqeustKey = null)
    {
        $this->reqeustKey = $reqeustKey;
        return $this;
    }
    /**
     * Get sideType value
     * @return string|null
     */
    public function getSideType()
    {
        return $this->sideType;
    }
    /**
     * Set sideType value
     * @uses \EnumType\IPSideType::valueIsValid()
     * @uses \EnumType\IPSideType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $sideType
     * @return \StructType\IPSideRequestType
     */
    public function setSideType($sideType = null)
    {
        $this->sideType = $sideType;
        return $this;
    }
    /**
     * Get side value
     * @return \StructType\ContragentDatumType|null
     */
    public function getSide()
    {
        return $this->side;
    }
    /**
     * Set side value
     * @param \StructType\ContragentDatumType $side
     * @return \StructType\IPSideRequestType
     */
    public function setSide(\StructType\ContragentDatumType $side = null)
    {
        $this->side = $side;
        return $this;
    }
    /**
     * Get representative value
     * @return \StructType\ContragentDatumType|null
     */
    public function getRepresentative()
    {
        return $this->representative;
    }
    /**
     * Set representative value
     * @param \StructType\ContragentDatumType $representative
     * @return \StructType\IPSideRequestType
     */
    public function setRepresentative(\StructType\ContragentDatumType $representative = null)
    {
        $this->representative = $representative;
        return $this;
    }
    /**
     * Get debtor value
     * @return \StructType\ContragentDatumType|null
     */
    public function getDebtor()
    {
        return $this->debtor;
    }
    /**
     * Set debtor value
     * @param \StructType\ContragentDatumType $debtor
     * @return \StructType\IPSideRequestType
     */
    public function setDebtor(\StructType\ContragentDatumType $debtor = null)
    {
        $this->debtor = $debtor;
        return $this;
    }
    /**
     * Get ospCode value
     * @return string|null
     */
    public function getOspCode()
    {
        return $this->ospCode;
    }
    /**
     * Set ospCode value
     * @param string $ospCode
     * @return \StructType\IPSideRequestType
     */
    public function setOspCode($ospCode = null)
    {
        $this->ospCode = $ospCode;
        return $this;
    }
    /**
     * Get requestDate value
     * @return string|null
     */
    public function getRequestDate()
    {
        return $this->requestDate;
    }
    /**
     * Set requestDate value
     * @param string $requestDate
     * @return \StructType\IPSideRequestType
     */
    public function setRequestDate($requestDate = null)
    {
        $this->requestDate = $requestDate;
        return $this;
    }
    /**
     * Get EApplication value
     * @return \StructType\EmbeddedDocumentType|null
     */
    public function getEApplication()
    {
        return $this->EApplication;
    }
    /**
     * Set EApplication value
     * @param \StructType\EmbeddedDocumentType $eApplication
     * @return \StructType\IPSideRequestType
     */
    public function setEApplication(\StructType\EmbeddedDocumentType $eApplication = null)
    {
        $this->EApplication = $eApplication;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\IPSideRequestType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
