<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for IPSideAnswer StructType
 * Meta informations extracted from the WSDL
 * - documentation: Ответ стороне ИП | Документ содержит ответ на запрос стороны исполнительного производства о ходе исполнительного
 * производства, в частности, сведения о документах по ИП
 * - type: tns:IPSideAnswer
 * @subpackage Structs
 */
class IPSideAnswer extends AbstractStructBase
{
    /**
     * The InternalKey
     * Meta informations extracted from the WSDL
     * - documentation: Ключ ФССП РФ | Ключ объекта, присвоенний информационной системой ФССП РФ при создании объекта или при получении объекта от
     * контрагента
     * - maxInclusive: 9223372036854775807
     * - minInclusive: -9223372036854775808
     * @var int
     */
    public $InternalKey;
    /**
     * The QueryExternalKey
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор запроса АИС ВК | Идентификатор объекта, присвоенный объекту АИС внешнего контрагентом (ФНС, ПФР и прочие). Данный
     * идентификатор должен быть уникальным для типа идентифицируемого документа в пространстве обмена данными с конкретным внешним
     * контрагентом.
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $QueryExternalKey;
    /**
     * The IpInternalKey
     * Meta informations extracted from the WSDL
     * - documentation: Ключ ИП ФССП РФ | Ключ объекта, присвоенний информационной системой ФССП РФ при создании объекта или при получении объекта от
     * контрагента
     * - maxInclusive: 9223372036854775807
     * - minInclusive: -9223372036854775808
     * @var int
     */
    public $IpInternalKey;
    /**
     * The ActDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата актуальности | Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $ActDate;
    /**
     * The IPDocsInfo
     * Meta informations extracted from the WSDL
     * - documentation: Документы ИП
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\IPDocInfoType[]
     */
    public $IPDocsInfo;
    /**
     * The IPAcctRecords
     * Meta informations extracted from the WSDL
     * - documentation: Расчёты ИП
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\IPAccountingType[]
     */
    public $IPAcctRecords;
    /**
     * Constructor method for IPSideAnswer
     * @uses IPSideAnswer::setInternalKey()
     * @uses IPSideAnswer::setQueryExternalKey()
     * @uses IPSideAnswer::setIpInternalKey()
     * @uses IPSideAnswer::setActDate()
     * @uses IPSideAnswer::setIPDocsInfo()
     * @uses IPSideAnswer::setIPAcctRecords()
     * @param int $internalKey
     * @param string $queryExternalKey
     * @param int $ipInternalKey
     * @param string $actDate
     * @param \StructType\IPDocInfoType[] $iPDocsInfo
     * @param \StructType\IPAccountingType[] $iPAcctRecords
     */
    public function __construct($internalKey = null, $queryExternalKey = null, $ipInternalKey = null, $actDate = null, array $iPDocsInfo = array(), array $iPAcctRecords = array())
    {
        $this
            ->setInternalKey($internalKey)
            ->setQueryExternalKey($queryExternalKey)
            ->setIpInternalKey($ipInternalKey)
            ->setActDate($actDate)
            ->setIPDocsInfo($iPDocsInfo)
            ->setIPAcctRecords($iPAcctRecords);
    }
    /**
     * Get InternalKey value
     * @return int|null
     */
    public function getInternalKey()
    {
        return $this->InternalKey;
    }
    /**
     * Set InternalKey value
     * @param int $internalKey
     * @return \StructType\IPSideAnswer
     */
    public function setInternalKey($internalKey = null)
    {
        $this->InternalKey = $internalKey;
        return $this;
    }
    /**
     * Get QueryExternalKey value
     * @return string|null
     */
    public function getQueryExternalKey()
    {
        return $this->QueryExternalKey;
    }
    /**
     * Set QueryExternalKey value
     * @param string $queryExternalKey
     * @return \StructType\IPSideAnswer
     */
    public function setQueryExternalKey($queryExternalKey = null)
    {
        $this->QueryExternalKey = $queryExternalKey;
        return $this;
    }
    /**
     * Get IpInternalKey value
     * @return int|null
     */
    public function getIpInternalKey()
    {
        return $this->IpInternalKey;
    }
    /**
     * Set IpInternalKey value
     * @param int $ipInternalKey
     * @return \StructType\IPSideAnswer
     */
    public function setIpInternalKey($ipInternalKey = null)
    {
        $this->IpInternalKey = $ipInternalKey;
        return $this;
    }
    /**
     * Get ActDate value
     * @return string|null
     */
    public function getActDate()
    {
        return $this->ActDate;
    }
    /**
     * Set ActDate value
     * @param string $actDate
     * @return \StructType\IPSideAnswer
     */
    public function setActDate($actDate = null)
    {
        $this->ActDate = $actDate;
        return $this;
    }
    /**
     * Get IPDocsInfo value
     * @return \StructType\IPDocInfoType[]|null
     */
    public function getIPDocsInfo()
    {
        return $this->IPDocsInfo;
    }
    /**
     * Set IPDocsInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\IPDocInfoType[] $iPDocsInfo
     * @return \StructType\IPSideAnswer
     */
    public function setIPDocsInfo(array $iPDocsInfo = array())
    {
        $this->IPDocsInfo = $iPDocsInfo;
        return $this;
    }
    /**
     * Add item to IPDocsInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\IPDocInfoType $item
     * @return \StructType\IPSideAnswer
     */
    public function addToIPDocsInfo(\StructType\IPDocInfoType $item)
    {
        $this->IPDocsInfo[] = $item;
        return $this;
    }
    /**
     * Get IPAcctRecords value
     * @return \StructType\IPAccountingType[]|null
     */
    public function getIPAcctRecords()
    {
        return $this->IPAcctRecords;
    }
    /**
     * Set IPAcctRecords value
     * @throws \InvalidArgumentException
     * @param \StructType\IPAccountingType[] $iPAcctRecords
     * @return \StructType\IPSideAnswer
     */
    public function setIPAcctRecords(array $iPAcctRecords = array())
    {
        $this->IPAcctRecords = $iPAcctRecords;
        return $this;
    }
    /**
     * Add item to IPAcctRecords value
     * @throws \InvalidArgumentException
     * @param \StructType\IPAccountingType $item
     * @return \StructType\IPSideAnswer
     */
    public function addToIPAcctRecords(\StructType\IPAccountingType $item)
    {
        $this->IPAcctRecords[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\IPSideAnswer
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
