<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for IPDocInfoType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Документы ИП | Содержит ответ на запрос стороны исполнительного производства о ходе исполнительного производства, в
 * частности, сведения о документах по ИП
 * - type: tns:IPDocInfoType
 * @subpackage Structs
 */
class IPDocInfoType extends AbstractStructBase
{
    /**
     * The InternalKey
     * Meta informations extracted from the WSDL
     * - documentation: Ключ ФССП РФ | Ключ объекта, присвоенний информационной системой ФССП РФ при создании объекта или при получении объекта от
     * контрагента
     * - maxInclusive: 9223372036854775807
     * - minInclusive: -9223372036854775808
     * @var int
     */
    public $InternalKey;
    /**
     * The IpInternalKey
     * Meta informations extracted from the WSDL
     * - documentation: Ключ ИП ФССП РФ | Ключ объекта, присвоенний информационной системой ФССП РФ при создании объекта или при получении объекта от
     * контрагента
     * - minOccurs: 0
     * - maxInclusive: 9223372036854775807
     * - minInclusive: -9223372036854775808
     * @var int
     */
    public $IpInternalKey;
    /**
     * The DocDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата события или документа | Дата | Дата
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $DocDate;
    /**
     * The SPIId
     * Meta informations extracted from the WSDL
     * - documentation: Код СПИ сделавший запрос | Ключ объекта, присвоенний информационной системой ФССП РФ при создании объекта или при получении
     * объекта от контрагента
     * - maxInclusive: 9223372036854775807
     * - minInclusive: -9223372036854775808
     * @var int
     */
    public $SPIId;
    /**
     * The SPIFio
     * Meta informations extracted from the WSDL
     * - documentation: ФИО СПИ | Полное имя физического лица (фамилия, имя, отчество)
     * - maxLength: 100
     * - minLength: 1
     * @var string
     */
    public $SPIFio;
    /**
     * The SPIPost
     * Meta informations extracted from the WSDL
     * - documentation: Код должности СПИ | Код должности СПИ
     * - minOccurs: 0
     * - maxLength: 25
     * - minLength: 1
     * - pattern: [0-9\-\.\s]+
     * @var string
     */
    public $SPIPost;
    /**
     * The DocNum
     * Meta informations extracted from the WSDL
     * - documentation: Номер документа | Номер документа
     * - minOccurs: 0
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $DocNum;
    /**
     * The DocType
     * Meta informations extracted from the WSDL
     * - documentation: Тип документа или события | Тип документа АИС ФССП России (тип документа ПКОСП) | Тип документа электронного документооборота |
     * NSI_Document | Наименование объекта NCORE
     * - minOccurs: 0
     * - maxLength: 31 | 31
     * - minLength: 1 | 1
     * @var string
     */
    public $DocType;
    /**
     * The StartDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата начала действия | Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $StartDate;
    /**
     * The FinDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата окончания действия | Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $FinDate;
    /**
     * The Counterpart
     * Meta informations extracted from the WSDL
     * - documentation: Контрагент | Строка длиной от 1 до 300 символов
     * - minOccurs: 0
     * - maxLength: 300
     * - minLength: 1
     * @var string
     */
    public $Counterpart;
    /**
     * The Reason
     * Meta informations extracted from the WSDL
     * - documentation: Текст основания принятия решения | Строка длиной от 1 до 300 символов
     * - maxLength: 300
     * - minLength: 1
     * @var string
     */
    public $Reason;
    /**
     * The Article
     * Meta informations extracted from the WSDL
     * - documentation: Статья основания принятия решения | Строка длиной от 1 до 10 символов
     * - maxLength: 10
     * - minLength: 1
     * @var string
     */
    public $Article;
    /**
     * The Point
     * Meta informations extracted from the WSDL
     * - documentation: Пункт статьи | Пункт статьи основания | Строка длиной от 1 до 10 символов
     * - minOccurs: 0
     * - maxLength: 10
     * - minLength: 1
     * @var string
     */
    public $Point;
    /**
     * The ArticlePart
     * Meta informations extracted from the WSDL
     * - documentation: Подпункт статьи основания решения | Строка длиной от 1 до 10 символов
     * - maxLength: 10
     * - minLength: 1
     * @var string
     */
    public $ArticlePart;
    /**
     * Constructor method for IPDocInfoType
     * @uses IPDocInfoType::setInternalKey()
     * @uses IPDocInfoType::setIpInternalKey()
     * @uses IPDocInfoType::setDocDate()
     * @uses IPDocInfoType::setSPIId()
     * @uses IPDocInfoType::setSPIFio()
     * @uses IPDocInfoType::setSPIPost()
     * @uses IPDocInfoType::setDocNum()
     * @uses IPDocInfoType::setDocType()
     * @uses IPDocInfoType::setStartDate()
     * @uses IPDocInfoType::setFinDate()
     * @uses IPDocInfoType::setCounterpart()
     * @uses IPDocInfoType::setReason()
     * @uses IPDocInfoType::setArticle()
     * @uses IPDocInfoType::setPoint()
     * @uses IPDocInfoType::setArticlePart()
     * @param int $internalKey
     * @param int $ipInternalKey
     * @param string $docDate
     * @param int $sPIId
     * @param string $sPIFio
     * @param string $sPIPost
     * @param string $docNum
     * @param string $docType
     * @param string $startDate
     * @param string $finDate
     * @param string $counterpart
     * @param string $reason
     * @param string $article
     * @param string $point
     * @param string $articlePart
     */
    public function __construct($internalKey = null, $ipInternalKey = null, $docDate = null, $sPIId = null, $sPIFio = null, $sPIPost = null, $docNum = null, $docType = null, $startDate = null, $finDate = null, $counterpart = null, $reason = null, $article = null, $point = null, $articlePart = null)
    {
        $this
            ->setInternalKey($internalKey)
            ->setIpInternalKey($ipInternalKey)
            ->setDocDate($docDate)
            ->setSPIId($sPIId)
            ->setSPIFio($sPIFio)
            ->setSPIPost($sPIPost)
            ->setDocNum($docNum)
            ->setDocType($docType)
            ->setStartDate($startDate)
            ->setFinDate($finDate)
            ->setCounterpart($counterpart)
            ->setReason($reason)
            ->setArticle($article)
            ->setPoint($point)
            ->setArticlePart($articlePart);
    }
    /**
     * Get InternalKey value
     * @return int|null
     */
    public function getInternalKey()
    {
        return $this->InternalKey;
    }
    /**
     * Set InternalKey value
     * @param int $internalKey
     * @return \StructType\IPDocInfoType
     */
    public function setInternalKey($internalKey = null)
    {
        $this->InternalKey = $internalKey;
        return $this;
    }
    /**
     * Get IpInternalKey value
     * @return int|null
     */
    public function getIpInternalKey()
    {
        return $this->IpInternalKey;
    }
    /**
     * Set IpInternalKey value
     * @param int $ipInternalKey
     * @return \StructType\IPDocInfoType
     */
    public function setIpInternalKey($ipInternalKey = null)
    {
        $this->IpInternalKey = $ipInternalKey;
        return $this;
    }
    /**
     * Get DocDate value
     * @return string|null
     */
    public function getDocDate()
    {
        return $this->DocDate;
    }
    /**
     * Set DocDate value
     * @param string $docDate
     * @return \StructType\IPDocInfoType
     */
    public function setDocDate($docDate = null)
    {
        $this->DocDate = $docDate;
        return $this;
    }
    /**
     * Get SPIId value
     * @return int|null
     */
    public function getSPIId()
    {
        return $this->SPIId;
    }
    /**
     * Set SPIId value
     * @param int $sPIId
     * @return \StructType\IPDocInfoType
     */
    public function setSPIId($sPIId = null)
    {
        $this->SPIId = $sPIId;
        return $this;
    }
    /**
     * Get SPIFio value
     * @return string|null
     */
    public function getSPIFio()
    {
        return $this->SPIFio;
    }
    /**
     * Set SPIFio value
     * @param string $sPIFio
     * @return \StructType\IPDocInfoType
     */
    public function setSPIFio($sPIFio = null)
    {
        $this->SPIFio = $sPIFio;
        return $this;
    }
    /**
     * Get SPIPost value
     * @return string|null
     */
    public function getSPIPost()
    {
        return $this->SPIPost;
    }
    /**
     * Set SPIPost value
     * @param string $sPIPost
     * @return \StructType\IPDocInfoType
     */
    public function setSPIPost($sPIPost = null)
    {
        $this->SPIPost = $sPIPost;
        return $this;
    }
    /**
     * Get DocNum value
     * @return string|null
     */
    public function getDocNum()
    {
        return $this->DocNum;
    }
    /**
     * Set DocNum value
     * @param string $docNum
     * @return \StructType\IPDocInfoType
     */
    public function setDocNum($docNum = null)
    {
        $this->DocNum = $docNum;
        return $this;
    }
    /**
     * Get DocType value
     * @return string|null
     */
    public function getDocType()
    {
        return $this->DocType;
    }
    /**
     * Set DocType value
     * @param string $docType
     * @return \StructType\IPDocInfoType
     */
    public function setDocType($docType = null)
    {
        $this->DocType = $docType;
        return $this;
    }
    /**
     * Get StartDate value
     * @return string|null
     */
    public function getStartDate()
    {
        return $this->StartDate;
    }
    /**
     * Set StartDate value
     * @param string $startDate
     * @return \StructType\IPDocInfoType
     */
    public function setStartDate($startDate = null)
    {
        $this->StartDate = $startDate;
        return $this;
    }
    /**
     * Get FinDate value
     * @return string|null
     */
    public function getFinDate()
    {
        return $this->FinDate;
    }
    /**
     * Set FinDate value
     * @param string $finDate
     * @return \StructType\IPDocInfoType
     */
    public function setFinDate($finDate = null)
    {
        $this->FinDate = $finDate;
        return $this;
    }
    /**
     * Get Counterpart value
     * @return string|null
     */
    public function getCounterpart()
    {
        return $this->Counterpart;
    }
    /**
     * Set Counterpart value
     * @param string $counterpart
     * @return \StructType\IPDocInfoType
     */
    public function setCounterpart($counterpart = null)
    {
        $this->Counterpart = $counterpart;
        return $this;
    }
    /**
     * Get Reason value
     * @return string|null
     */
    public function getReason()
    {
        return $this->Reason;
    }
    /**
     * Set Reason value
     * @param string $reason
     * @return \StructType\IPDocInfoType
     */
    public function setReason($reason = null)
    {
        $this->Reason = $reason;
        return $this;
    }
    /**
     * Get Article value
     * @return string|null
     */
    public function getArticle()
    {
        return $this->Article;
    }
    /**
     * Set Article value
     * @param string $article
     * @return \StructType\IPDocInfoType
     */
    public function setArticle($article = null)
    {
        $this->Article = $article;
        return $this;
    }
    /**
     * Get Point value
     * @return string|null
     */
    public function getPoint()
    {
        return $this->Point;
    }
    /**
     * Set Point value
     * @param string $point
     * @return \StructType\IPDocInfoType
     */
    public function setPoint($point = null)
    {
        $this->Point = $point;
        return $this;
    }
    /**
     * Get ArticlePart value
     * @return string|null
     */
    public function getArticlePart()
    {
        return $this->ArticlePart;
    }
    /**
     * Set ArticlePart value
     * @param string $articlePart
     * @return \StructType\IPDocInfoType
     */
    public function setArticlePart($articlePart = null)
    {
        $this->ArticlePart = $articlePart;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\IPDocInfoType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
