<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for IPDataRequest StructType
 * Meta informations extracted from the WSDL
 * - documentation: Запрос информации о наличии и реквизитах ИП | ЭП
 * - type: tns:IPDataRequest
 * @subpackage Structs
 */
class IPDataRequest extends RequestByDatum
{
    /**
     * The IdSubj
     * Meta informations extracted from the WSDL
     * - documentation: Код предмета исполнения | Код предмета исполнения | NSI_IDoc_Subj_Exec
     * - minOccurs: 0
     * - maxLength: 8
     * - minLength: 1
     * @var string
     */
    public $IdSubj;
    /**
     * The Signature
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: ds:Signature
     * @var \StructType\SignatureType[]
     */
    public $Signature;
    /**
     * Constructor method for IPDataRequest
     * @uses IPDataRequest::setIdSubj()
     * @uses IPDataRequest::setSignature()
     * @param string $idSubj
     * @param \StructType\SignatureType[] $signature
     */
    public function __construct($idSubj = null, array $signature = array())
    {
        $this
            ->setIdSubj($idSubj)
            ->setSignature($signature);
    }
    /**
     * Get IdSubj value
     * @return string|null
     */
    public function getIdSubj()
    {
        return $this->IdSubj;
    }
    /**
     * Set IdSubj value
     * @param string $idSubj
     * @return \StructType\IPDataRequest
     */
    public function setIdSubj($idSubj = null)
    {
        $this->IdSubj = $idSubj;
        return $this;
    }
    /**
     * Get Signature value
     * @return \StructType\SignatureType[]|null
     */
    public function getSignature()
    {
        return $this->Signature;
    }
    /**
     * Set Signature value
     * @throws \InvalidArgumentException
     * @param \StructType\SignatureType[] $signature
     * @return \StructType\IPDataRequest
     */
    public function setSignature(array $signature = array())
    {
        $this->Signature = $signature;
        return $this;
    }
    /**
     * Add item to Signature value
     * @throws \InvalidArgumentException
     * @param \StructType\SignatureType $item
     * @return \StructType\IPDataRequest
     */
    public function addToSignature(\StructType\SignatureType $item)
    {
        $this->Signature[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\IPDataRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
