<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for IPAccountingType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Расчеты ИП | Содержит ответ на запрос стороны исполнительного производства о ходе исполнительного производства, в частности,
 * движение денежных средств по ИП
 * - type: tns:IPAccountingType
 * @subpackage Structs
 */
class IPAccountingType extends AbstractStructBase
{
    /**
     * The InternalKey
     * Meta informations extracted from the WSDL
     * - documentation: Ключ ФССП РФ | Ключ объекта, присвоенний информационной системой ФССП РФ при создании объекта или при получении объекта от
     * контрагента
     * - maxInclusive: 9223372036854775807
     * - minInclusive: -9223372036854775808
     * @var int
     */
    public $InternalKey;
    /**
     * The IpInternalKey
     * Meta informations extracted from the WSDL
     * - documentation: Ключ ИП ФССП РФ | Ключ объекта, присвоенний информационной системой ФССП РФ при создании объекта или при получении объекта от
     * контрагента
     * - maxInclusive: 9223372036854775807
     * - minInclusive: -9223372036854775808
     * @var int
     */
    public $IpInternalKey;
    /**
     * The AccDate
     * Meta informations extracted from the WSDL
     * - documentation: Учетная дата записи в регистре | Дата | Дата
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $AccDate;
    /**
     * The DocType
     * Meta informations extracted from the WSDL
     * - documentation: Тип платежного документа | Тип документа АИС ФССП России (тип документа ПКОСП) | Тип документа электронного документооборота |
     * NSI_Document | Наименование объекта NCORE
     * - maxLength: 31 | 31
     * - minLength: 1 | 1
     * @var string
     */
    public $DocType;
    /**
     * The DocDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата события или документа | Дата | Дата
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $DocDate;
    /**
     * The DocNum
     * Meta informations extracted from the WSDL
     * - documentation: Номер документа | Строка длиной от 1 до 20 символов
     * - minOccurs: 0
     * - maxLength: 20
     * - minLength: 1
     * @var string
     */
    public $DocNum;
    /**
     * The RegType
     * Meta informations extracted from the WSDL
     * - documentation: Код типа регистра | Код типа регистра
     * - length: 3
     * @var string
     */
    public $RegType;
    /**
     * The DestType
     * Meta informations extracted from the WSDL
     * - documentation: Тип документа или события | Вид назначения денежных средств
     * - maxLength: 2
     * - minLength: 1
     * @var string
     */
    public $DestType;
    /**
     * The Amount
     * Meta informations extracted from the WSDL
     * - documentation: Сумма | Сумма
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $Amount;
    /**
     * Constructor method for IPAccountingType
     * @uses IPAccountingType::setInternalKey()
     * @uses IPAccountingType::setIpInternalKey()
     * @uses IPAccountingType::setAccDate()
     * @uses IPAccountingType::setDocType()
     * @uses IPAccountingType::setDocDate()
     * @uses IPAccountingType::setDocNum()
     * @uses IPAccountingType::setRegType()
     * @uses IPAccountingType::setDestType()
     * @uses IPAccountingType::setAmount()
     * @param int $internalKey
     * @param int $ipInternalKey
     * @param string $accDate
     * @param string $docType
     * @param string $docDate
     * @param string $docNum
     * @param string $regType
     * @param string $destType
     * @param float $amount
     */
    public function __construct($internalKey = null, $ipInternalKey = null, $accDate = null, $docType = null, $docDate = null, $docNum = null, $regType = null, $destType = null, $amount = null)
    {
        $this
            ->setInternalKey($internalKey)
            ->setIpInternalKey($ipInternalKey)
            ->setAccDate($accDate)
            ->setDocType($docType)
            ->setDocDate($docDate)
            ->setDocNum($docNum)
            ->setRegType($regType)
            ->setDestType($destType)
            ->setAmount($amount);
    }
    /**
     * Get InternalKey value
     * @return int|null
     */
    public function getInternalKey()
    {
        return $this->InternalKey;
    }
    /**
     * Set InternalKey value
     * @param int $internalKey
     * @return \StructType\IPAccountingType
     */
    public function setInternalKey($internalKey = null)
    {
        $this->InternalKey = $internalKey;
        return $this;
    }
    /**
     * Get IpInternalKey value
     * @return int|null
     */
    public function getIpInternalKey()
    {
        return $this->IpInternalKey;
    }
    /**
     * Set IpInternalKey value
     * @param int $ipInternalKey
     * @return \StructType\IPAccountingType
     */
    public function setIpInternalKey($ipInternalKey = null)
    {
        $this->IpInternalKey = $ipInternalKey;
        return $this;
    }
    /**
     * Get AccDate value
     * @return string|null
     */
    public function getAccDate()
    {
        return $this->AccDate;
    }
    /**
     * Set AccDate value
     * @param string $accDate
     * @return \StructType\IPAccountingType
     */
    public function setAccDate($accDate = null)
    {
        $this->AccDate = $accDate;
        return $this;
    }
    /**
     * Get DocType value
     * @return string|null
     */
    public function getDocType()
    {
        return $this->DocType;
    }
    /**
     * Set DocType value
     * @param string $docType
     * @return \StructType\IPAccountingType
     */
    public function setDocType($docType = null)
    {
        $this->DocType = $docType;
        return $this;
    }
    /**
     * Get DocDate value
     * @return string|null
     */
    public function getDocDate()
    {
        return $this->DocDate;
    }
    /**
     * Set DocDate value
     * @param string $docDate
     * @return \StructType\IPAccountingType
     */
    public function setDocDate($docDate = null)
    {
        $this->DocDate = $docDate;
        return $this;
    }
    /**
     * Get DocNum value
     * @return string|null
     */
    public function getDocNum()
    {
        return $this->DocNum;
    }
    /**
     * Set DocNum value
     * @param string $docNum
     * @return \StructType\IPAccountingType
     */
    public function setDocNum($docNum = null)
    {
        $this->DocNum = $docNum;
        return $this;
    }
    /**
     * Get RegType value
     * @return string|null
     */
    public function getRegType()
    {
        return $this->RegType;
    }
    /**
     * Set RegType value
     * @param string $regType
     * @return \StructType\IPAccountingType
     */
    public function setRegType($regType = null)
    {
        $this->RegType = $regType;
        return $this;
    }
    /**
     * Get DestType value
     * @return string|null
     */
    public function getDestType()
    {
        return $this->DestType;
    }
    /**
     * Set DestType value
     * @param string $destType
     * @return \StructType\IPAccountingType
     */
    public function setDestType($destType = null)
    {
        $this->DestType = $destType;
        return $this;
    }
    /**
     * Get Amount value
     * @return float|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param float $amount
     * @return \StructType\IPAccountingType
     */
    public function setAmount($amount = null)
    {
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\IPAccountingType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
