<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for IP StructType
 * Meta informations extracted from the WSDL
 * - documentation: Тип данных IP «Исполнительное производство» | Тип данных содержит исчерпывающие сведения об исполнительном производстве.
 * @subpackage Structs
 */
class IP extends AbstractStructBase
{
    /**
     * The InternalKey
     * Meta informations extracted from the WSDL
     * - documentation: Ключ ФССП России | Уникальный идентификатор исполнительного производства АИС ФССП России | Ключ объекта, присвоенний
     * информационной системой ФССП РФ при создании объекта или при получении объекта от контрагента
     * - maxInclusive: 9223372036854775807
     * - minInclusive: -9223372036854775808
     * @var int
     */
    public $InternalKey;
    /**
     * The IdExternalKey
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор ИД АИС ВК | Идентификатор исполнительного документа, переданного ранее внешним контрагентом. Заполняется в том
     * случае, если ИД получен от того же внешнего контрагента, которому направляются сведения об ИП | Идентификатор объекта, присвоенный
     * объекту АИС внешнего контрагентом (ФНС, ПФР и прочие). Данный идентификатор должен быть уникальным для типа идентифицируемого документа
     * в пространстве обмена данными с конкретным внешним контрагентом.
     * - minOccurs: 0
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $IdExternalKey;
    /**
     * The IPNum
     * Meta informations extracted from the WSDL
     * - documentation: Номер ИП строковый | Номер документа
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $IPNum;
    /**
     * The IPDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата возбуждения ИП | Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $IPDate;
    /**
     * The IPName
     * Meta informations extracted from the WSDL
     * - documentation: Наименование ИП | Текст: 1. Для простых ИП: «Исполнительное производство». 2. Для сводных ИП : "Сводное исполнительное
     * производство" | Строка длиной от 1 до 100 символов
     * - maxLength: 100
     * - minLength: 1
     * @var string
     */
    public $IPName;
    /**
     * The IDType
     * Meta informations extracted from the WSDL
     * - documentation: Тип ИД | Тип исполнительного документа, на основании которого возбуждено ИП
     * - minOccurs: 0
     * @var string
     */
    public $IDType;
    /**
     * The IDName
     * Meta informations extracted from the WSDL
     * - documentation: Наименование типа ИД | Строка длиной от 1 до 100 символов
     * - minOccurs: 0
     * - maxLength: 100
     * - minLength: 1
     * @var string
     */
    public $IDName;
    /**
     * The IDOrgCode
     * Meta informations extracted from the WSDL
     * - documentation: Код органа, выдавшего ИД | Код организации | NSI_MVV_Organization
     * - minOccurs: 0
     * - maxLength: 20
     * - minLength: 1
     * @var string
     */
    public $IDOrgCode;
    /**
     * The IDOrgName
     * Meta informations extracted from the WSDL
     * - documentation: Наименование органа, выдавшего ИД | Строка длиной от 1 до 300 символов
     * - minOccurs: 0
     * - maxLength: 300
     * - minLength: 1
     * @var string
     */
    public $IDOrgName;
    /**
     * The IDNum
     * Meta informations extracted from the WSDL
     * - documentation: Номер ИД | Номер документа
     * - minOccurs: 0
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $IDNum;
    /**
     * The IDDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата ИД | Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $IDDate;
    /**
     * The AktDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата вступления | Дата вступления в законную силу судебного акта, акта другого органа или должностного лица либо указание на
     * немедленное исполнение | Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $AktDate;
    /**
     * The IDSubj
     * Meta informations extracted from the WSDL
     * - documentation: Код предмета исполнения | Код предмета исполнения | NSI_IDoc_Subj_Exec
     * - minOccurs: 0
     * - maxLength: 8
     * - minLength: 1
     * @var string
     */
    public $IDSubj;
    /**
     * The IDSubjName
     * Meta informations extracted from the WSDL
     * - documentation: Наименование предмета исполнения | Строка длиной от 1 до 300 символов
     * - minOccurs: 0
     * - maxLength: 300
     * - minLength: 1
     * @var string
     */
    public $IDSubjName;
    /**
     * The IDSum
     * Meta informations extracted from the WSDL
     * - documentation: Сумма долга по ИД | Сумма
     * - minOccurs: 0
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $IDSum;
    /**
     * The IPDebt
     * Meta informations extracted from the WSDL
     * - documentation: Сумма долга по ИД на момент запроса | Сумма
     * - minOccurs: 0
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $IPDebt;
    /**
     * The DebtorType
     * Meta informations extracted from the WSDL
     * - documentation: Тип должника
     * @var string
     */
    public $DebtorType;
    /**
     * The DebtorName
     * Meta informations extracted from the WSDL
     * - documentation: ФИО полностью/наименование должника | Строка длиной от 1 до 1000 символов
     * - maxLength: 1000
     * - minLength: 1
     * @var string
     */
    public $DebtorName;
    /**
     * The DebtorFio
     * Meta informations extracted from the WSDL
     * - documentation: Фамиия, имя, отчество должника по частям | Заполняется только в том случае, если в отделе судебных приставов есть возможность
     * заполнить наименование должника раздельно
     * - minOccurs: 0
     * @var \StructType\FioType
     */
    public $DebtorFio;
    /**
     * The DebtorAdr
     * Meta informations extracted from the WSDL
     * - documentation: Адрес должника по ИД | Адрес должника в формате «Код страны» + «запятая» + «Адрес в формате 9 запятых по КЛАДР» или (в случае
     * отсутствия кода страны) в произвольном формате | Строка длиной от 1 до 300 символов
     * - maxLength: 300
     * - minLength: 1
     * @var string
     */
    public $DebtorAdr;
    /**
     * The DebtorINN
     * Meta informations extracted from the WSDL
     * - documentation: ИНН ЮЛ/ИП | ИНН
     * - minOccurs: 0
     * - maxLength: 12
     * - minLength: 10
     * - pattern: (([0-9]{1}[1-9]{1}|[1-9]{1}[0-9]{1})[0-9]{8})|(([0-9]{1}[1-9]{1}|[1-9]{1}[0-9]{1})[0-9]{10})
     * @var string
     */
    public $DebtorINN;
    /**
     * The DebtorKPP
     * Meta informations extracted from the WSDL
     * - documentation: КПП | Код причины постановки на учет ЮЛ | КПП
     * - minOccurs: 0
     * - length: 9
     * - pattern: ([0-9]{1}[1-9]{1}|[1-9]{1}[0-9]{1})[0-9]{7}
     * @var string
     */
    public $DebtorKPP;
    /**
     * The DebtorOGRN
     * Meta informations extracted from the WSDL
     * - documentation: ОГРН/ОГРНИП | ОГРН/ОГРНИП ЮЛ/ИП | Основной государственный регистрационный номер (ОГРН)/Основной государственный
     * регистрационный номер индивидуального предпринимателя (ОГРНИП)
     * - minOccurs: 0
     * - maxLength: 15
     * - minLength: 13
     * - pattern: ([0-9]{13})|([0-9]{15})
     * @var string
     */
    public $DebtorOGRN;
    /**
     * The DebtorBirthDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата рождения ФЛ | Заполняется при наличии данных о дате рождения. В противном случае заполняется только поле «Год рождения» |
     * Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $DebtorBirthDate;
    /**
     * The DebtorBirthYear
     * Meta informations extracted from the WSDL
     * - documentation: Год рождения ФЛ | Год (выпуска, рождения и т. п.)
     * - minOccurs: 0
     * - maxInclusive: 2099
     * - minInclusive: 1900
     * @var string
     */
    public $DebtorBirthYear;
    /**
     * The DebtorGender
     * Meta informations extracted from the WSDL
     * - documentation: Пол должника ФЛ
     * - minOccurs: 0
     * @var string
     */
    public $DebtorGender;
    /**
     * The DebtorBirthPlace
     * Meta informations extracted from the WSDL
     * - documentation: Место рождения ФЛ | Строка длиной от 1 до 300 символов
     * - minOccurs: 0
     * - maxLength: 300
     * - minLength: 1
     * @var string
     */
    public $DebtorBirthPlace;
    /**
     * The DebtorSnils
     * Meta informations extracted from the WSDL
     * - documentation: СНИЛС ФЛ | СНИЛС
     * - minOccurs: 0
     * - length: 11
     * - pattern: [0-9]{11}
     * @var string
     */
    public $DebtorSnils;
    /**
     * The OSPCode
     * Meta informations extracted from the WSDL
     * - documentation: ОСП | Ведомственный классификатор отделов судебных приставов | NSI_Departments
     * - minOccurs: 0
     * - length: 5
     * - pattern: [0-9]{5}
     * @var string
     */
    public $OSPCode;
    /**
     * The OSPName
     * Meta informations extracted from the WSDL
     * - documentation: Наименование ОСП | Строка длиной от 1 до 100 символов
     * - minOccurs: 0
     * - maxLength: 100
     * - minLength: 1
     * @var string
     */
    public $OSPName;
    /**
     * The SPI
     * Meta informations extracted from the WSDL
     * - documentation: Код СПИ, ведущего ИП | Ключ объекта, присвоенний информационной системой ФССП РФ при создании объекта или при получении объекта
     * от контрагента
     * - maxInclusive: 9223372036854775807
     * - minInclusive: -9223372036854775808
     * @var int
     */
    public $SPI;
    /**
     * The SPIFio
     * Meta informations extracted from the WSDL
     * - documentation: ФИО полностью СПИ, ведущего ИП | Полное имя физического лица (фамилия, имя, отчество)
     * - maxLength: 100
     * - minLength: 1
     * @var string
     */
    public $SPIFio;
    /**
     * The OldIPNumber
     * Meta informations extracted from the WSDL
     * - documentation: Номера прошлых ИП | Номер документа
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - maxLength: 25
     * - minLength: 1
     * @var string[]
     */
    public $OldIPNumber;
    /**
     * The ChargeOffQueue
     * Meta informations extracted from the WSDL
     * - documentation: Очерёдность списание средств со счета
     * - minOccurs: 0
     * @var string
     */
    public $ChargeOffQueue;
    /**
     * Constructor method for IP
     * @uses IP::setInternalKey()
     * @uses IP::setIdExternalKey()
     * @uses IP::setIPNum()
     * @uses IP::setIPDate()
     * @uses IP::setIPName()
     * @uses IP::setIDType()
     * @uses IP::setIDName()
     * @uses IP::setIDOrgCode()
     * @uses IP::setIDOrgName()
     * @uses IP::setIDNum()
     * @uses IP::setIDDate()
     * @uses IP::setAktDate()
     * @uses IP::setIDSubj()
     * @uses IP::setIDSubjName()
     * @uses IP::setIDSum()
     * @uses IP::setIPDebt()
     * @uses IP::setDebtorType()
     * @uses IP::setDebtorName()
     * @uses IP::setDebtorFio()
     * @uses IP::setDebtorAdr()
     * @uses IP::setDebtorINN()
     * @uses IP::setDebtorKPP()
     * @uses IP::setDebtorOGRN()
     * @uses IP::setDebtorBirthDate()
     * @uses IP::setDebtorBirthYear()
     * @uses IP::setDebtorGender()
     * @uses IP::setDebtorBirthPlace()
     * @uses IP::setDebtorSnils()
     * @uses IP::setOSPCode()
     * @uses IP::setOSPName()
     * @uses IP::setSPI()
     * @uses IP::setSPIFio()
     * @uses IP::setOldIPNumber()
     * @uses IP::setChargeOffQueue()
     * @param int $internalKey
     * @param string $idExternalKey
     * @param string $iPNum
     * @param string $iPDate
     * @param string $iPName
     * @param string $iDType
     * @param string $iDName
     * @param string $iDOrgCode
     * @param string $iDOrgName
     * @param string $iDNum
     * @param string $iDDate
     * @param string $aktDate
     * @param string $iDSubj
     * @param string $iDSubjName
     * @param float $iDSum
     * @param float $iPDebt
     * @param string $debtorType
     * @param string $debtorName
     * @param \StructType\FioType $debtorFio
     * @param string $debtorAdr
     * @param string $debtorINN
     * @param string $debtorKPP
     * @param string $debtorOGRN
     * @param string $debtorBirthDate
     * @param string $debtorBirthYear
     * @param string $debtorGender
     * @param string $debtorBirthPlace
     * @param string $debtorSnils
     * @param string $oSPCode
     * @param string $oSPName
     * @param int $sPI
     * @param string $sPIFio
     * @param string[] $oldIPNumber
     * @param string $chargeOffQueue
     */
    public function __construct($internalKey = null, $idExternalKey = null, $iPNum = null, $iPDate = null, $iPName = null, $iDType = null, $iDName = null, $iDOrgCode = null, $iDOrgName = null, $iDNum = null, $iDDate = null, $aktDate = null, $iDSubj = null, $iDSubjName = null, $iDSum = null, $iPDebt = null, $debtorType = null, $debtorName = null, \StructType\FioType $debtorFio = null, $debtorAdr = null, $debtorINN = null, $debtorKPP = null, $debtorOGRN = null, $debtorBirthDate = null, $debtorBirthYear = null, $debtorGender = null, $debtorBirthPlace = null, $debtorSnils = null, $oSPCode = null, $oSPName = null, $sPI = null, $sPIFio = null, array $oldIPNumber = array(), $chargeOffQueue = null)
    {
        $this
            ->setInternalKey($internalKey)
            ->setIdExternalKey($idExternalKey)
            ->setIPNum($iPNum)
            ->setIPDate($iPDate)
            ->setIPName($iPName)
            ->setIDType($iDType)
            ->setIDName($iDName)
            ->setIDOrgCode($iDOrgCode)
            ->setIDOrgName($iDOrgName)
            ->setIDNum($iDNum)
            ->setIDDate($iDDate)
            ->setAktDate($aktDate)
            ->setIDSubj($iDSubj)
            ->setIDSubjName($iDSubjName)
            ->setIDSum($iDSum)
            ->setIPDebt($iPDebt)
            ->setDebtorType($debtorType)
            ->setDebtorName($debtorName)
            ->setDebtorFio($debtorFio)
            ->setDebtorAdr($debtorAdr)
            ->setDebtorINN($debtorINN)
            ->setDebtorKPP($debtorKPP)
            ->setDebtorOGRN($debtorOGRN)
            ->setDebtorBirthDate($debtorBirthDate)
            ->setDebtorBirthYear($debtorBirthYear)
            ->setDebtorGender($debtorGender)
            ->setDebtorBirthPlace($debtorBirthPlace)
            ->setDebtorSnils($debtorSnils)
            ->setOSPCode($oSPCode)
            ->setOSPName($oSPName)
            ->setSPI($sPI)
            ->setSPIFio($sPIFio)
            ->setOldIPNumber($oldIPNumber)
            ->setChargeOffQueue($chargeOffQueue);
    }
    /**
     * Get InternalKey value
     * @return int|null
     */
    public function getInternalKey()
    {
        return $this->InternalKey;
    }
    /**
     * Set InternalKey value
     * @param int $internalKey
     * @return \StructType\IP
     */
    public function setInternalKey($internalKey = null)
    {
        $this->InternalKey = $internalKey;
        return $this;
    }
    /**
     * Get IdExternalKey value
     * @return string|null
     */
    public function getIdExternalKey()
    {
        return $this->IdExternalKey;
    }
    /**
     * Set IdExternalKey value
     * @param string $idExternalKey
     * @return \StructType\IP
     */
    public function setIdExternalKey($idExternalKey = null)
    {
        $this->IdExternalKey = $idExternalKey;
        return $this;
    }
    /**
     * Get IPNum value
     * @return string|null
     */
    public function getIPNum()
    {
        return $this->IPNum;
    }
    /**
     * Set IPNum value
     * @param string $iPNum
     * @return \StructType\IP
     */
    public function setIPNum($iPNum = null)
    {
        $this->IPNum = $iPNum;
        return $this;
    }
    /**
     * Get IPDate value
     * @return string|null
     */
    public function getIPDate()
    {
        return $this->IPDate;
    }
    /**
     * Set IPDate value
     * @param string $iPDate
     * @return \StructType\IP
     */
    public function setIPDate($iPDate = null)
    {
        $this->IPDate = $iPDate;
        return $this;
    }
    /**
     * Get IPName value
     * @return string|null
     */
    public function getIPName()
    {
        return $this->IPName;
    }
    /**
     * Set IPName value
     * @param string $iPName
     * @return \StructType\IP
     */
    public function setIPName($iPName = null)
    {
        $this->IPName = $iPName;
        return $this;
    }
    /**
     * Get IDType value
     * @return string|null
     */
    public function getIDType()
    {
        return $this->IDType;
    }
    /**
     * Set IDType value
     * @uses \EnumType\IdType::valueIsValid()
     * @uses \EnumType\IdType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $iDType
     * @return \StructType\IP
     */
    public function setIDType($iDType = null)
    {
        $this->IDType = $iDType;
        return $this;
    }
    /**
     * Get IDName value
     * @return string|null
     */
    public function getIDName()
    {
        return $this->IDName;
    }
    /**
     * Set IDName value
     * @param string $iDName
     * @return \StructType\IP
     */
    public function setIDName($iDName = null)
    {
        $this->IDName = $iDName;
        return $this;
    }
    /**
     * Get IDOrgCode value
     * @return string|null
     */
    public function getIDOrgCode()
    {
        return $this->IDOrgCode;
    }
    /**
     * Set IDOrgCode value
     * @param string $iDOrgCode
     * @return \StructType\IP
     */
    public function setIDOrgCode($iDOrgCode = null)
    {
        $this->IDOrgCode = $iDOrgCode;
        return $this;
    }
    /**
     * Get IDOrgName value
     * @return string|null
     */
    public function getIDOrgName()
    {
        return $this->IDOrgName;
    }
    /**
     * Set IDOrgName value
     * @param string $iDOrgName
     * @return \StructType\IP
     */
    public function setIDOrgName($iDOrgName = null)
    {
        $this->IDOrgName = $iDOrgName;
        return $this;
    }
    /**
     * Get IDNum value
     * @return string|null
     */
    public function getIDNum()
    {
        return $this->IDNum;
    }
    /**
     * Set IDNum value
     * @param string $iDNum
     * @return \StructType\IP
     */
    public function setIDNum($iDNum = null)
    {
        $this->IDNum = $iDNum;
        return $this;
    }
    /**
     * Get IDDate value
     * @return string|null
     */
    public function getIDDate()
    {
        return $this->IDDate;
    }
    /**
     * Set IDDate value
     * @param string $iDDate
     * @return \StructType\IP
     */
    public function setIDDate($iDDate = null)
    {
        $this->IDDate = $iDDate;
        return $this;
    }
    /**
     * Get AktDate value
     * @return string|null
     */
    public function getAktDate()
    {
        return $this->AktDate;
    }
    /**
     * Set AktDate value
     * @param string $aktDate
     * @return \StructType\IP
     */
    public function setAktDate($aktDate = null)
    {
        $this->AktDate = $aktDate;
        return $this;
    }
    /**
     * Get IDSubj value
     * @return string|null
     */
    public function getIDSubj()
    {
        return $this->IDSubj;
    }
    /**
     * Set IDSubj value
     * @param string $iDSubj
     * @return \StructType\IP
     */
    public function setIDSubj($iDSubj = null)
    {
        $this->IDSubj = $iDSubj;
        return $this;
    }
    /**
     * Get IDSubjName value
     * @return string|null
     */
    public function getIDSubjName()
    {
        return $this->IDSubjName;
    }
    /**
     * Set IDSubjName value
     * @param string $iDSubjName
     * @return \StructType\IP
     */
    public function setIDSubjName($iDSubjName = null)
    {
        $this->IDSubjName = $iDSubjName;
        return $this;
    }
    /**
     * Get IDSum value
     * @return float|null
     */
    public function getIDSum()
    {
        return $this->IDSum;
    }
    /**
     * Set IDSum value
     * @param float $iDSum
     * @return \StructType\IP
     */
    public function setIDSum($iDSum = null)
    {
        $this->IDSum = $iDSum;
        return $this;
    }
    /**
     * Get IPDebt value
     * @return float|null
     */
    public function getIPDebt()
    {
        return $this->IPDebt;
    }
    /**
     * Set IPDebt value
     * @param float $iPDebt
     * @return \StructType\IP
     */
    public function setIPDebt($iPDebt = null)
    {
        $this->IPDebt = $iPDebt;
        return $this;
    }
    /**
     * Get DebtorType value
     * @return string|null
     */
    public function getDebtorType()
    {
        return $this->DebtorType;
    }
    /**
     * Set DebtorType value
     * @uses \EnumType\ContragentType::valueIsValid()
     * @uses \EnumType\ContragentType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $debtorType
     * @return \StructType\IP
     */
    public function setDebtorType($debtorType = null)
    {
        $this->DebtorType = $debtorType;
        return $this;
    }
    /**
     * Get DebtorName value
     * @return string|null
     */
    public function getDebtorName()
    {
        return $this->DebtorName;
    }
    /**
     * Set DebtorName value
     * @param string $debtorName
     * @return \StructType\IP
     */
    public function setDebtorName($debtorName = null)
    {
        $this->DebtorName = $debtorName;
        return $this;
    }
    /**
     * Get DebtorFio value
     * @return \StructType\FioType|null
     */
    public function getDebtorFio()
    {
        return $this->DebtorFio;
    }
    /**
     * Set DebtorFio value
     * @param \StructType\FioType $debtorFio
     * @return \StructType\IP
     */
    public function setDebtorFio(\StructType\FioType $debtorFio = null)
    {
        $this->DebtorFio = $debtorFio;
        return $this;
    }
    /**
     * Get DebtorAdr value
     * @return string|null
     */
    public function getDebtorAdr()
    {
        return $this->DebtorAdr;
    }
    /**
     * Set DebtorAdr value
     * @param string $debtorAdr
     * @return \StructType\IP
     */
    public function setDebtorAdr($debtorAdr = null)
    {
        $this->DebtorAdr = $debtorAdr;
        return $this;
    }
    /**
     * Get DebtorINN value
     * @return string|null
     */
    public function getDebtorINN()
    {
        return $this->DebtorINN;
    }
    /**
     * Set DebtorINN value
     * @param string $debtorINN
     * @return \StructType\IP
     */
    public function setDebtorINN($debtorINN = null)
    {
        $this->DebtorINN = $debtorINN;
        return $this;
    }
    /**
     * Get DebtorKPP value
     * @return string|null
     */
    public function getDebtorKPP()
    {
        return $this->DebtorKPP;
    }
    /**
     * Set DebtorKPP value
     * @param string $debtorKPP
     * @return \StructType\IP
     */
    public function setDebtorKPP($debtorKPP = null)
    {
        $this->DebtorKPP = $debtorKPP;
        return $this;
    }
    /**
     * Get DebtorOGRN value
     * @return string|null
     */
    public function getDebtorOGRN()
    {
        return $this->DebtorOGRN;
    }
    /**
     * Set DebtorOGRN value
     * @param string $debtorOGRN
     * @return \StructType\IP
     */
    public function setDebtorOGRN($debtorOGRN = null)
    {
        $this->DebtorOGRN = $debtorOGRN;
        return $this;
    }
    /**
     * Get DebtorBirthDate value
     * @return string|null
     */
    public function getDebtorBirthDate()
    {
        return $this->DebtorBirthDate;
    }
    /**
     * Set DebtorBirthDate value
     * @param string $debtorBirthDate
     * @return \StructType\IP
     */
    public function setDebtorBirthDate($debtorBirthDate = null)
    {
        $this->DebtorBirthDate = $debtorBirthDate;
        return $this;
    }
    /**
     * Get DebtorBirthYear value
     * @return string|null
     */
    public function getDebtorBirthYear()
    {
        return $this->DebtorBirthYear;
    }
    /**
     * Set DebtorBirthYear value
     * @param string $debtorBirthYear
     * @return \StructType\IP
     */
    public function setDebtorBirthYear($debtorBirthYear = null)
    {
        $this->DebtorBirthYear = $debtorBirthYear;
        return $this;
    }
    /**
     * Get DebtorGender value
     * @return string|null
     */
    public function getDebtorGender()
    {
        return $this->DebtorGender;
    }
    /**
     * Set DebtorGender value
     * @uses \EnumType\GenderCodeType::valueIsValid()
     * @uses \EnumType\GenderCodeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $debtorGender
     * @return \StructType\IP
     */
    public function setDebtorGender($debtorGender = null)
    {
        $this->DebtorGender = $debtorGender;
        return $this;
    }
    /**
     * Get DebtorBirthPlace value
     * @return string|null
     */
    public function getDebtorBirthPlace()
    {
        return $this->DebtorBirthPlace;
    }
    /**
     * Set DebtorBirthPlace value
     * @param string $debtorBirthPlace
     * @return \StructType\IP
     */
    public function setDebtorBirthPlace($debtorBirthPlace = null)
    {
        $this->DebtorBirthPlace = $debtorBirthPlace;
        return $this;
    }
    /**
     * Get DebtorSnils value
     * @return string|null
     */
    public function getDebtorSnils()
    {
        return $this->DebtorSnils;
    }
    /**
     * Set DebtorSnils value
     * @param string $debtorSnils
     * @return \StructType\IP
     */
    public function setDebtorSnils($debtorSnils = null)
    {
        $this->DebtorSnils = $debtorSnils;
        return $this;
    }
    /**
     * Get OSPCode value
     * @return string|null
     */
    public function getOSPCode()
    {
        return $this->OSPCode;
    }
    /**
     * Set OSPCode value
     * @param string $oSPCode
     * @return \StructType\IP
     */
    public function setOSPCode($oSPCode = null)
    {
        $this->OSPCode = $oSPCode;
        return $this;
    }
    /**
     * Get OSPName value
     * @return string|null
     */
    public function getOSPName()
    {
        return $this->OSPName;
    }
    /**
     * Set OSPName value
     * @param string $oSPName
     * @return \StructType\IP
     */
    public function setOSPName($oSPName = null)
    {
        $this->OSPName = $oSPName;
        return $this;
    }
    /**
     * Get SPI value
     * @return int|null
     */
    public function getSPI()
    {
        return $this->SPI;
    }
    /**
     * Set SPI value
     * @param int $sPI
     * @return \StructType\IP
     */
    public function setSPI($sPI = null)
    {
        $this->SPI = $sPI;
        return $this;
    }
    /**
     * Get SPIFio value
     * @return string|null
     */
    public function getSPIFio()
    {
        return $this->SPIFio;
    }
    /**
     * Set SPIFio value
     * @param string $sPIFio
     * @return \StructType\IP
     */
    public function setSPIFio($sPIFio = null)
    {
        $this->SPIFio = $sPIFio;
        return $this;
    }
    /**
     * Get OldIPNumber value
     * @return string[]|null
     */
    public function getOldIPNumber()
    {
        return $this->OldIPNumber;
    }
    /**
     * Set OldIPNumber value
     * @throws \InvalidArgumentException
     * @param string[] $oldIPNumber
     * @return \StructType\IP
     */
    public function setOldIPNumber(array $oldIPNumber = array())
    {
        $this->OldIPNumber = $oldIPNumber;
        return $this;
    }
    /**
     * Add item to OldIPNumber value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\IP
     */
    public function addToOldIPNumber($item)
    {
        $this->OldIPNumber[] = $item;
        return $this;
    }
    /**
     * Get ChargeOffQueue value
     * @return string|null
     */
    public function getChargeOffQueue()
    {
        return $this->ChargeOffQueue;
    }
    /**
     * Set ChargeOffQueue value
     * @uses \EnumType\ChargeOffQueueType::valueIsValid()
     * @uses \EnumType\ChargeOffQueueType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $chargeOffQueue
     * @return \StructType\IP
     */
    public function setChargeOffQueue($chargeOffQueue = null)
    {
        $this->ChargeOffQueue = $chargeOffQueue;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\IP
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
