<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HijackingType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Сведения об угоне
 * @subpackage Structs
 */
class HijackingType extends AbstractStructBase
{
    /**
     * The HijackingDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата угона | Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $HijackingDate;
    /**
     * The HijackingEndDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата исключения из угона | Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $HijackingEndDate;
    /**
     * The CaseNumber
     * Meta informations extracted from the WSDL
     * - documentation: Номер дела | Строка длиной от 1 до 50 символов
     * - minOccurs: 0
     * - maxLength: 50
     * - minLength: 1
     * @var string
     */
    public $CaseNumber;
    /**
     * Constructor method for HijackingType
     * @uses HijackingType::setHijackingDate()
     * @uses HijackingType::setHijackingEndDate()
     * @uses HijackingType::setCaseNumber()
     * @param string $hijackingDate
     * @param string $hijackingEndDate
     * @param string $caseNumber
     */
    public function __construct($hijackingDate = null, $hijackingEndDate = null, $caseNumber = null)
    {
        $this
            ->setHijackingDate($hijackingDate)
            ->setHijackingEndDate($hijackingEndDate)
            ->setCaseNumber($caseNumber);
    }
    /**
     * Get HijackingDate value
     * @return string|null
     */
    public function getHijackingDate()
    {
        return $this->HijackingDate;
    }
    /**
     * Set HijackingDate value
     * @param string $hijackingDate
     * @return \StructType\HijackingType
     */
    public function setHijackingDate($hijackingDate = null)
    {
        $this->HijackingDate = $hijackingDate;
        return $this;
    }
    /**
     * Get HijackingEndDate value
     * @return string|null
     */
    public function getHijackingEndDate()
    {
        return $this->HijackingEndDate;
    }
    /**
     * Set HijackingEndDate value
     * @param string $hijackingEndDate
     * @return \StructType\HijackingType
     */
    public function setHijackingEndDate($hijackingEndDate = null)
    {
        $this->HijackingEndDate = $hijackingEndDate;
        return $this;
    }
    /**
     * Get CaseNumber value
     * @return string|null
     */
    public function getCaseNumber()
    {
        return $this->CaseNumber;
    }
    /**
     * Set CaseNumber value
     * @param string $caseNumber
     * @return \StructType\HijackingType
     */
    public function setCaseNumber($caseNumber = null)
    {
        $this->CaseNumber = $caseNumber;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\HijackingType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
