<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetMessagesRs StructType
 * Meta informations extracted from the WSDL
 * - documentation: Ответ - сообщения
 * @subpackage Structs
 */
class GetMessagesRs extends Response
{
    /**
     * The hasMore
     * Meta informations extracted from the WSDL
     * - documentation: Признак наличия сообщений помимо передаваемого ответа
     * @var bool
     */
    public $hasMore;
    /**
     * The results
     * Meta informations extracted from the WSDL
     * - documentation: Результаты приема сообщений веб-сервисом ФССП России
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\MessageResultCollection
     */
    public $results;
    /**
     * The messages
     * Meta informations extracted from the WSDL
     * - documentation: Сообщение | В настоящее время выполняется передача одного сообщения.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\MessageCollection
     */
    public $messages;
    /**
     * Constructor method for GetMessagesRs
     * @uses GetMessagesRs::setHasMore()
     * @uses GetMessagesRs::setResults()
     * @uses GetMessagesRs::setMessages()
     * @param bool $hasMore
     * @param \StructType\MessageResultCollection $results
     * @param \StructType\MessageCollection $messages
     */
    public function __construct($hasMore = null, \StructType\MessageResultCollection $results = null, \StructType\MessageCollection $messages = null)
    {
        $this
            ->setHasMore($hasMore)
            ->setResults($results)
            ->setMessages($messages);
    }
    /**
     * Get hasMore value
     * @return bool|null
     */
    public function getHasMore()
    {
        return $this->hasMore;
    }
    /**
     * Set hasMore value
     * @param bool $hasMore
     * @return \StructType\GetMessagesRs
     */
    public function setHasMore($hasMore = null)
    {
        $this->hasMore = $hasMore;
        return $this;
    }
    /**
     * Get results value
     * @return \StructType\MessageResultCollection|null
     */
    public function getResults()
    {
        return $this->results;
    }
    /**
     * Set results value
     * @param \StructType\MessageResultCollection $results
     * @return \StructType\GetMessagesRs
     */
    public function setResults(\StructType\MessageResultCollection $results = null)
    {
        $this->results = $results;
        return $this;
    }
    /**
     * Get messages value
     * @return \StructType\MessageCollection|null
     */
    public function getMessages()
    {
        return $this->messages;
    }
    /**
     * Set messages value
     * @param \StructType\MessageCollection $messages
     * @return \StructType\GetMessagesRs
     */
    public function setMessages(\StructType\MessageCollection $messages = null)
    {
        $this->messages = $messages;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetMessagesRs
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
