<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FishQuotaCurYearDatumType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Сведения о наличии квот на вылов биоресурсов на текущий год
 * @subpackage Structs
 */
class FishQuotaCurYearDatumType extends FishDatumType
{
    /**
     * The year
     * Meta informations extracted from the WSDL
     * - documentation: Год квоты | Год (выпуска, рождения и т. п.)
     * - maxInclusive: 2099
     * - minInclusive: 1900
     * @var string
     */
    public $year;
    /**
     * The volume
     * Meta informations extracted from the WSDL
     * - documentation: Объем | Количество
     * - fractionDigits: 3
     * - totalDigits: 15
     * @var float
     */
    public $volume;
    /**
     * The OKEICode
     * Meta informations extracted from the WSDL
     * - documentation: Код единицы по ОКЕИ | Код ОКЕИ
     * - length: 3
     * @var string
     */
    public $OKEICode;
    /**
     * The OKEIName
     * Meta informations extracted from the WSDL
     * - documentation: Наименование единицы по ОКЕИ | Строка длиной от 1 до 100 символов
     * - maxLength: 100
     * - minLength: 1
     * @var string
     */
    public $OKEIName;
    /**
     * Constructor method for FishQuotaCurYearDatumType
     * @uses FishQuotaCurYearDatumType::setYear()
     * @uses FishQuotaCurYearDatumType::setVolume()
     * @uses FishQuotaCurYearDatumType::setOKEICode()
     * @uses FishQuotaCurYearDatumType::setOKEIName()
     * @param string $year
     * @param float $volume
     * @param string $oKEICode
     * @param string $oKEIName
     */
    public function __construct($year = null, $volume = null, $oKEICode = null, $oKEIName = null)
    {
        $this
            ->setYear($year)
            ->setVolume($volume)
            ->setOKEICode($oKEICode)
            ->setOKEIName($oKEIName);
    }
    /**
     * Get year value
     * @return string|null
     */
    public function getYear()
    {
        return $this->year;
    }
    /**
     * Set year value
     * @param string $year
     * @return \StructType\FishQuotaCurYearDatumType
     */
    public function setYear($year = null)
    {
        $this->year = $year;
        return $this;
    }
    /**
     * Get volume value
     * @return float|null
     */
    public function getVolume()
    {
        return $this->volume;
    }
    /**
     * Set volume value
     * @param float $volume
     * @return \StructType\FishQuotaCurYearDatumType
     */
    public function setVolume($volume = null)
    {
        $this->volume = $volume;
        return $this;
    }
    /**
     * Get OKEICode value
     * @return string|null
     */
    public function getOKEICode()
    {
        return $this->OKEICode;
    }
    /**
     * Set OKEICode value
     * @param string $oKEICode
     * @return \StructType\FishQuotaCurYearDatumType
     */
    public function setOKEICode($oKEICode = null)
    {
        $this->OKEICode = $oKEICode;
        return $this;
    }
    /**
     * Get OKEIName value
     * @return string|null
     */
    public function getOKEIName()
    {
        return $this->OKEIName;
    }
    /**
     * Set OKEIName value
     * @param string $oKEIName
     * @return \StructType\FishQuotaCurYearDatumType
     */
    public function setOKEIName($oKEIName = null)
    {
        $this->OKEIName = $oKEIName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\FishQuotaCurYearDatumType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
