<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FishQuotaContractDatumType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Сведения о наличии договора на закрепление долей квот добычи (вылова) биоресурсов
 * @subpackage Structs
 */
class FishQuotaContractDatumType extends FishDatumType
{
    /**
     * The quotaCode
     * Meta informations extracted from the WSDL
     * - documentation: Код вида квоты | Строка длиной от 1 до 10 символов
     * - maxLength: 10
     * - minLength: 1
     * @var string
     */
    public $quotaCode;
    /**
     * The quotaName
     * Meta informations extracted from the WSDL
     * - documentation: Наименование вида квоты | Строка длиной от 1 до 100 символов
     * - maxLength: 100
     * - minLength: 1
     * @var string
     */
    public $quotaName;
    /**
     * The part
     * Meta informations extracted from the WSDL
     * - documentation: Процент доли | Количество
     * - minOccurs: 0
     * - fractionDigits: 3
     * - totalDigits: 15
     * @var float
     */
    public $part;
    /**
     * The startDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата начала договора | Дата | Дата
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $startDate;
    /**
     * The finishDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата окончания договора | Дата | Дата
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $finishDate;
    /**
     * The chDocCode
     * Meta informations extracted from the WSDL
     * - documentation: Код документа изменения | Строка длиной от 1 до 10 символов
     * - minOccurs: 0
     * - maxLength: 10
     * - minLength: 1
     * @var string
     */
    public $chDocCode;
    /**
     * The chDocType
     * Meta informations extracted from the WSDL
     * - documentation: Наименование документа изменения | Строка длиной от 1 до 100 символов
     * - minOccurs: 0
     * - maxLength: 100
     * - minLength: 1
     * @var string
     */
    public $chDocType;
    /**
     * The chDocDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата документа изменения | Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $chDocDate;
    /**
     * The chDocNumber
     * Meta informations extracted from the WSDL
     * - documentation: Номер документа изменения | Номер документа
     * - minOccurs: 0
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $chDocNumber;
    /**
     * The chDocGround
     * Meta informations extracted from the WSDL
     * - documentation: Основание документа изменения | Строка длиной от 1 до 300 символов
     * - minOccurs: 0
     * - maxLength: 300
     * - minLength: 1
     * @var string
     */
    public $chDocGround;
    /**
     * Constructor method for FishQuotaContractDatumType
     * @uses FishQuotaContractDatumType::setQuotaCode()
     * @uses FishQuotaContractDatumType::setQuotaName()
     * @uses FishQuotaContractDatumType::setPart()
     * @uses FishQuotaContractDatumType::setStartDate()
     * @uses FishQuotaContractDatumType::setFinishDate()
     * @uses FishQuotaContractDatumType::setChDocCode()
     * @uses FishQuotaContractDatumType::setChDocType()
     * @uses FishQuotaContractDatumType::setChDocDate()
     * @uses FishQuotaContractDatumType::setChDocNumber()
     * @uses FishQuotaContractDatumType::setChDocGround()
     * @param string $quotaCode
     * @param string $quotaName
     * @param float $part
     * @param string $startDate
     * @param string $finishDate
     * @param string $chDocCode
     * @param string $chDocType
     * @param string $chDocDate
     * @param string $chDocNumber
     * @param string $chDocGround
     */
    public function __construct($quotaCode = null, $quotaName = null, $part = null, $startDate = null, $finishDate = null, $chDocCode = null, $chDocType = null, $chDocDate = null, $chDocNumber = null, $chDocGround = null)
    {
        $this
            ->setQuotaCode($quotaCode)
            ->setQuotaName($quotaName)
            ->setPart($part)
            ->setStartDate($startDate)
            ->setFinishDate($finishDate)
            ->setChDocCode($chDocCode)
            ->setChDocType($chDocType)
            ->setChDocDate($chDocDate)
            ->setChDocNumber($chDocNumber)
            ->setChDocGround($chDocGround);
    }
    /**
     * Get quotaCode value
     * @return string|null
     */
    public function getQuotaCode()
    {
        return $this->quotaCode;
    }
    /**
     * Set quotaCode value
     * @param string $quotaCode
     * @return \StructType\FishQuotaContractDatumType
     */
    public function setQuotaCode($quotaCode = null)
    {
        $this->quotaCode = $quotaCode;
        return $this;
    }
    /**
     * Get quotaName value
     * @return string|null
     */
    public function getQuotaName()
    {
        return $this->quotaName;
    }
    /**
     * Set quotaName value
     * @param string $quotaName
     * @return \StructType\FishQuotaContractDatumType
     */
    public function setQuotaName($quotaName = null)
    {
        $this->quotaName = $quotaName;
        return $this;
    }
    /**
     * Get part value
     * @return float|null
     */
    public function getPart()
    {
        return $this->part;
    }
    /**
     * Set part value
     * @param float $part
     * @return \StructType\FishQuotaContractDatumType
     */
    public function setPart($part = null)
    {
        $this->part = $part;
        return $this;
    }
    /**
     * Get startDate value
     * @return string|null
     */
    public function getStartDate()
    {
        return $this->startDate;
    }
    /**
     * Set startDate value
     * @param string $startDate
     * @return \StructType\FishQuotaContractDatumType
     */
    public function setStartDate($startDate = null)
    {
        $this->startDate = $startDate;
        return $this;
    }
    /**
     * Get finishDate value
     * @return string|null
     */
    public function getFinishDate()
    {
        return $this->finishDate;
    }
    /**
     * Set finishDate value
     * @param string $finishDate
     * @return \StructType\FishQuotaContractDatumType
     */
    public function setFinishDate($finishDate = null)
    {
        $this->finishDate = $finishDate;
        return $this;
    }
    /**
     * Get chDocCode value
     * @return string|null
     */
    public function getChDocCode()
    {
        return $this->chDocCode;
    }
    /**
     * Set chDocCode value
     * @param string $chDocCode
     * @return \StructType\FishQuotaContractDatumType
     */
    public function setChDocCode($chDocCode = null)
    {
        $this->chDocCode = $chDocCode;
        return $this;
    }
    /**
     * Get chDocType value
     * @return string|null
     */
    public function getChDocType()
    {
        return $this->chDocType;
    }
    /**
     * Set chDocType value
     * @param string $chDocType
     * @return \StructType\FishQuotaContractDatumType
     */
    public function setChDocType($chDocType = null)
    {
        $this->chDocType = $chDocType;
        return $this;
    }
    /**
     * Get chDocDate value
     * @return string|null
     */
    public function getChDocDate()
    {
        return $this->chDocDate;
    }
    /**
     * Set chDocDate value
     * @param string $chDocDate
     * @return \StructType\FishQuotaContractDatumType
     */
    public function setChDocDate($chDocDate = null)
    {
        $this->chDocDate = $chDocDate;
        return $this;
    }
    /**
     * Get chDocNumber value
     * @return string|null
     */
    public function getChDocNumber()
    {
        return $this->chDocNumber;
    }
    /**
     * Set chDocNumber value
     * @param string $chDocNumber
     * @return \StructType\FishQuotaContractDatumType
     */
    public function setChDocNumber($chDocNumber = null)
    {
        $this->chDocNumber = $chDocNumber;
        return $this;
    }
    /**
     * Get chDocGround value
     * @return string|null
     */
    public function getChDocGround()
    {
        return $this->chDocGround;
    }
    /**
     * Set chDocGround value
     * @param string $chDocGround
     * @return \StructType\FishQuotaContractDatumType
     */
    public function setChDocGround($chDocGround = null)
    {
        $this->chDocGround = $chDocGround;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\FishQuotaContractDatumType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
