<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FishNonquotaContractDatumType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Сведения о договорах пользования водными биоресурсами, которые отнесены к объектам рыболовства и общий допустимый улов
 * которых не устанавливается
 * @subpackage Structs
 */
class FishNonquotaContractDatumType extends FishDatumType
{
    /**
     * The volume
     * Meta informations extracted from the WSDL
     * - documentation: Объем | Количество
     * - fractionDigits: 3
     * - totalDigits: 15
     * @var float
     */
    public $volume;
    /**
     * The OKEICode
     * Meta informations extracted from the WSDL
     * - documentation: Код единицы по ОКЕИ | Код ОКЕИ
     * - length: 3
     * @var string
     */
    public $OKEICode;
    /**
     * The OKEIName
     * Meta informations extracted from the WSDL
     * - documentation: Наименование единицы по ОКЕИ | Строка длиной от 1 до 100 символов
     * - maxLength: 100
     * - minLength: 1
     * @var string
     */
    public $OKEIName;
    /**
     * The startDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата начала договора | Дата | Дата
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $startDate;
    /**
     * The finishDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата окончания договора | Дата | Дата
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $finishDate;
    /**
     * The finDocDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата соглашения о расторжении | Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $finDocDate;
    /**
     * The finDocNumber
     * Meta informations extracted from the WSDL
     * - documentation: Номер соглашения о расторжении | Номер документа
     * - minOccurs: 0
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $finDocNumber;
    /**
     * The finDocGround
     * Meta informations extracted from the WSDL
     * - documentation: Основание расторжения договора | Строка длиной от 1 до 300 символов
     * - minOccurs: 0
     * - maxLength: 300
     * - minLength: 1
     * @var string
     */
    public $finDocGround;
    /**
     * Constructor method for FishNonquotaContractDatumType
     * @uses FishNonquotaContractDatumType::setVolume()
     * @uses FishNonquotaContractDatumType::setOKEICode()
     * @uses FishNonquotaContractDatumType::setOKEIName()
     * @uses FishNonquotaContractDatumType::setStartDate()
     * @uses FishNonquotaContractDatumType::setFinishDate()
     * @uses FishNonquotaContractDatumType::setFinDocDate()
     * @uses FishNonquotaContractDatumType::setFinDocNumber()
     * @uses FishNonquotaContractDatumType::setFinDocGround()
     * @param float $volume
     * @param string $oKEICode
     * @param string $oKEIName
     * @param string $startDate
     * @param string $finishDate
     * @param string $finDocDate
     * @param string $finDocNumber
     * @param string $finDocGround
     */
    public function __construct($volume = null, $oKEICode = null, $oKEIName = null, $startDate = null, $finishDate = null, $finDocDate = null, $finDocNumber = null, $finDocGround = null)
    {
        $this
            ->setVolume($volume)
            ->setOKEICode($oKEICode)
            ->setOKEIName($oKEIName)
            ->setStartDate($startDate)
            ->setFinishDate($finishDate)
            ->setFinDocDate($finDocDate)
            ->setFinDocNumber($finDocNumber)
            ->setFinDocGround($finDocGround);
    }
    /**
     * Get volume value
     * @return float|null
     */
    public function getVolume()
    {
        return $this->volume;
    }
    /**
     * Set volume value
     * @param float $volume
     * @return \StructType\FishNonquotaContractDatumType
     */
    public function setVolume($volume = null)
    {
        $this->volume = $volume;
        return $this;
    }
    /**
     * Get OKEICode value
     * @return string|null
     */
    public function getOKEICode()
    {
        return $this->OKEICode;
    }
    /**
     * Set OKEICode value
     * @param string $oKEICode
     * @return \StructType\FishNonquotaContractDatumType
     */
    public function setOKEICode($oKEICode = null)
    {
        $this->OKEICode = $oKEICode;
        return $this;
    }
    /**
     * Get OKEIName value
     * @return string|null
     */
    public function getOKEIName()
    {
        return $this->OKEIName;
    }
    /**
     * Set OKEIName value
     * @param string $oKEIName
     * @return \StructType\FishNonquotaContractDatumType
     */
    public function setOKEIName($oKEIName = null)
    {
        $this->OKEIName = $oKEIName;
        return $this;
    }
    /**
     * Get startDate value
     * @return string|null
     */
    public function getStartDate()
    {
        return $this->startDate;
    }
    /**
     * Set startDate value
     * @param string $startDate
     * @return \StructType\FishNonquotaContractDatumType
     */
    public function setStartDate($startDate = null)
    {
        $this->startDate = $startDate;
        return $this;
    }
    /**
     * Get finishDate value
     * @return string|null
     */
    public function getFinishDate()
    {
        return $this->finishDate;
    }
    /**
     * Set finishDate value
     * @param string $finishDate
     * @return \StructType\FishNonquotaContractDatumType
     */
    public function setFinishDate($finishDate = null)
    {
        $this->finishDate = $finishDate;
        return $this;
    }
    /**
     * Get finDocDate value
     * @return string|null
     */
    public function getFinDocDate()
    {
        return $this->finDocDate;
    }
    /**
     * Set finDocDate value
     * @param string $finDocDate
     * @return \StructType\FishNonquotaContractDatumType
     */
    public function setFinDocDate($finDocDate = null)
    {
        $this->finDocDate = $finDocDate;
        return $this;
    }
    /**
     * Get finDocNumber value
     * @return string|null
     */
    public function getFinDocNumber()
    {
        return $this->finDocNumber;
    }
    /**
     * Set finDocNumber value
     * @param string $finDocNumber
     * @return \StructType\FishNonquotaContractDatumType
     */
    public function setFinDocNumber($finDocNumber = null)
    {
        $this->finDocNumber = $finDocNumber;
        return $this;
    }
    /**
     * Get finDocGround value
     * @return string|null
     */
    public function getFinDocGround()
    {
        return $this->finDocGround;
    }
    /**
     * Set finDocGround value
     * @param string $finDocGround
     * @return \StructType\FishNonquotaContractDatumType
     */
    public function setFinDocGround($finDocGround = null)
    {
        $this->finDocGround = $finDocGround;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\FishNonquotaContractDatumType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
