<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FileInfo StructType
 * Meta informations extracted from the WSDL
 * - documentation: Информация о файле
 * @subpackage Structs
 */
class FileInfo extends AbstractStructBase
{
    /**
     * The encoding
     * Meta informations extracted from the WSDL
     * - documentation: Кодировка текстового файла | Код таблицы символов в формате "IANA CHARACTER SETS"
     * - maxLength: 40
     * - minLength: 1
     * @var string
     */
    public $encoding;
    /**
     * The size
     * Meta informations extracted from the WSDL
     * - documentation: Полный размер файла в байтах | Размер файла
     * - minInclusive: 0
     * @var int
     */
    public $size;
    /**
     * The type
     * Meta informations extracted from the WSDL
     * - documentation: Тип файла
     * @var string
     */
    public $type;
    /**
     * The digest
     * Meta informations extracted from the WSDL
     * - documentation: Значение хэш-функции ГОСТ 3411-94, вычисленной из данных файла
     * - length: 32
     * @var string
     */
    public $digest;
    /**
     * The signature_digest
     * Meta informations extracted from the WSDL
     * - documentation: Значение хэш-функции ГОСТ 3411-94, вычисленной из данных detached-подписи, при её наличии
     * - length: 32
     * @var string
     */
    public $signature_digest;
    /**
     * The pack_id
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор пакета | Заполняется для пакетного режима передачи данных | Идентификатор объекта | Атрибут документа
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $pack_id;
    /**
     * The env_id
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор конверта | Заполняется для пакетного режима передачи данных | Идентификатор объекта | Атрибут документа
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $env_id;
    /**
     * The doc_id
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор документа | Заполняется для типа файла DOCUMENT, ALL_ATTACHMENTS, SINGLE_ATTACHMENT | Идентификатор объекта | Атрибут документа
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $doc_id;
    /**
     * The attachmentTypeCode
     * Meta informations extracted from the WSDL
     * - documentation: Тип вложения
     * - maxLength: 31
     * - minLength: 1
     * @var string
     */
    public $attachmentTypeCode;
    /**
     * The systemCode1
     * Meta informations extracted from the WSDL
     * - documentation: Системный код 1
     * - maxLength: 31
     * - minLength: 1
     * @var string
     */
    public $systemCode1;
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - documentation: Имя файла | Имя файла
     * - maxLength: 255
     * - minLength: 1
     * @var string
     */
    public $name;
    /**
     * The content_type
     * Meta informations extracted from the WSDL
     * - documentation: MIME-тип содержимого файла | MIME-тип данных | MIME-тип данных
     * - maxLength: 255
     * - minLength: 1
     * @var string
     */
    public $content_type;
    /**
     * The attachment_id
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор вложения | Заполняется для типа файла SINGLE_ATTACHMENT | Идентификатор объекта | Атрибут документа
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $attachment_id;
    /**
     * Constructor method for FileInfo
     * @uses FileInfo::setEncoding()
     * @uses FileInfo::setSize()
     * @uses FileInfo::setType()
     * @uses FileInfo::setDigest()
     * @uses FileInfo::setSignature_digest()
     * @uses FileInfo::setPack_id()
     * @uses FileInfo::setEnv_id()
     * @uses FileInfo::setDoc_id()
     * @uses FileInfo::setAttachmentTypeCode()
     * @uses FileInfo::setSystemCode1()
     * @uses FileInfo::setName()
     * @uses FileInfo::setContent_type()
     * @uses FileInfo::setAttachment_id()
     * @param string $encoding
     * @param int $size
     * @param string $type
     * @param string $digest
     * @param string $signature_digest
     * @param string $pack_id
     * @param string $env_id
     * @param string $doc_id
     * @param string $attachmentTypeCode
     * @param string $systemCode1
     * @param string $name
     * @param string $content_type
     * @param string $attachment_id
     */
    public function __construct($encoding = null, $size = null, $type = null, $digest = null, $signature_digest = null, $pack_id = null, $env_id = null, $doc_id = null, $attachmentTypeCode = null, $systemCode1 = null, $name = null, $content_type = null, $attachment_id = null)
    {
        $this
            ->setEncoding($encoding)
            ->setSize($size)
            ->setType($type)
            ->setDigest($digest)
            ->setSignature_digest($signature_digest)
            ->setPack_id($pack_id)
            ->setEnv_id($env_id)
            ->setDoc_id($doc_id)
            ->setAttachmentTypeCode($attachmentTypeCode)
            ->setSystemCode1($systemCode1)
            ->setName($name)
            ->setContent_type($content_type)
            ->setAttachment_id($attachment_id);
    }
    /**
     * Get encoding value
     * @return string|null
     */
    public function getEncoding()
    {
        return $this->encoding;
    }
    /**
     * Set encoding value
     * @param string $encoding
     * @return \StructType\FileInfo
     */
    public function setEncoding($encoding = null)
    {
        $this->encoding = $encoding;
        return $this;
    }
    /**
     * Get size value
     * @return int|null
     */
    public function getSize()
    {
        return $this->size;
    }
    /**
     * Set size value
     * @param int $size
     * @return \StructType\FileInfo
     */
    public function setSize($size = null)
    {
        $this->size = $size;
        return $this;
    }
    /**
     * Get type value
     * @return string|null
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @uses \EnumType\FileType::valueIsValid()
     * @uses \EnumType\FileType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $type
     * @return \StructType\FileInfo
     */
    public function setType($type = null)
    {
        $this->type = $type;
        return $this;
    }
    /**
     * Get digest value
     * @return string|null
     */
    public function getDigest()
    {
        return $this->digest;
    }
    /**
     * Set digest value
     * @param string $digest
     * @return \StructType\FileInfo
     */
    public function setDigest($digest = null)
    {
        $this->digest = $digest;
        return $this;
    }
    /**
     * Get signature_digest value
     * @return string|null
     */
    public function getSignature_digest()
    {
        return $this->signature_digest;
    }
    /**
     * Set signature_digest value
     * @param string $signature_digest
     * @return \StructType\FileInfo
     */
    public function setSignature_digest($signature_digest = null)
    {
        $this->signature_digest = $signature_digest;
        return $this;
    }
    /**
     * Get pack_id value
     * @return string|null
     */
    public function getPack_id()
    {
        return $this->pack_id;
    }
    /**
     * Set pack_id value
     * @param string $pack_id
     * @return \StructType\FileInfo
     */
    public function setPack_id($pack_id = null)
    {
        $this->pack_id = $pack_id;
        return $this;
    }
    /**
     * Get env_id value
     * @return string|null
     */
    public function getEnv_id()
    {
        return $this->env_id;
    }
    /**
     * Set env_id value
     * @param string $env_id
     * @return \StructType\FileInfo
     */
    public function setEnv_id($env_id = null)
    {
        $this->env_id = $env_id;
        return $this;
    }
    /**
     * Get doc_id value
     * @return string|null
     */
    public function getDoc_id()
    {
        return $this->doc_id;
    }
    /**
     * Set doc_id value
     * @param string $doc_id
     * @return \StructType\FileInfo
     */
    public function setDoc_id($doc_id = null)
    {
        $this->doc_id = $doc_id;
        return $this;
    }
    /**
     * Get attachmentTypeCode value
     * @return string|null
     */
    public function getAttachmentTypeCode()
    {
        return $this->attachmentTypeCode;
    }
    /**
     * Set attachmentTypeCode value
     * @param string $attachmentTypeCode
     * @return \StructType\FileInfo
     */
    public function setAttachmentTypeCode($attachmentTypeCode = null)
    {
        $this->attachmentTypeCode = $attachmentTypeCode;
        return $this;
    }
    /**
     * Get systemCode1 value
     * @return string|null
     */
    public function getSystemCode1()
    {
        return $this->systemCode1;
    }
    /**
     * Set systemCode1 value
     * @param string $systemCode1
     * @return \StructType\FileInfo
     */
    public function setSystemCode1($systemCode1 = null)
    {
        $this->systemCode1 = $systemCode1;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\FileInfo
     */
    public function setName($name = null)
    {
        $this->name = $name;
        return $this;
    }
    /**
     * Get content_type value
     * @return string|null
     */
    public function getContent_type()
    {
        return $this->content_type;
    }
    /**
     * Set content_type value
     * @param string $content_type
     * @return \StructType\FileInfo
     */
    public function setContent_type($content_type = null)
    {
        $this->content_type = $content_type;
        return $this;
    }
    /**
     * Get attachment_id value
     * @return string|null
     */
    public function getAttachment_id()
    {
        return $this->attachment_id;
    }
    /**
     * Set attachment_id value
     * @param string $attachment_id
     * @return \StructType\FileInfo
     */
    public function setAttachment_id($attachment_id = null)
    {
        $this->attachment_id = $attachment_id;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\FileInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
