<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FileData StructType
 * Meta informations extracted from the WSDL
 * - documentation: Данные файла
 * @subpackage Structs
 */
class FileData extends AbstractStructBase
{
    /**
     * The _
     * @var string
     */
    public $_;
    /**
     * The encoding
     * Meta informations extracted from the WSDL
     * - documentation: Код таблицы символов в формате "IANA CHARACTER SETS"
     * - maxLength: 40
     * - minLength: 1
     * @var string
     */
    public $encoding;
    /**
     * The size
     * Meta informations extracted from the WSDL
     * - documentation: Размер файла
     * - minInclusive: 0
     * @var int
     */
    public $size;
    /**
     * The type
     * @var string
     */
    public $type;
    /**
     * The digest
     * Meta informations extracted from the WSDL
     * - length: 32
     * @var string
     */
    public $digest;
    /**
     * The signature_digest
     * Meta informations extracted from the WSDL
     * - length: 32
     * @var string
     */
    public $signature_digest;
    /**
     * The pack_id
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор объекта | Атрибут документа
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $pack_id;
    /**
     * The env_id
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор объекта | Атрибут документа
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $env_id;
    /**
     * The doc_id
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор объекта | Атрибут документа
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $doc_id;
    /**
     * The attachmentTypeCode
     * Meta informations extracted from the WSDL
     * - documentation: Тип вложения
     * - maxLength: 31
     * - minLength: 1
     * @var string
     */
    public $attachmentTypeCode;
    /**
     * The systemCode1
     * Meta informations extracted from the WSDL
     * - documentation: Системный код 1
     * - maxLength: 31
     * - minLength: 1
     * @var string
     */
    public $systemCode1;
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - documentation: Имя файла
     * - maxLength: 255
     * - minLength: 1
     * @var string
     */
    public $name;
    /**
     * The content_type
     * Meta informations extracted from the WSDL
     * - documentation: MIME-тип данных | MIME-тип данных
     * - maxLength: 255
     * - minLength: 1
     * @var string
     */
    public $content_type;
    /**
     * The attachment_id
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор объекта | Атрибут документа
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $attachment_id;
    /**
     * Constructor method for FileData
     * @uses FileData::set_()
     * @uses FileData::setEncoding()
     * @uses FileData::setSize()
     * @uses FileData::setType()
     * @uses FileData::setDigest()
     * @uses FileData::setSignature_digest()
     * @uses FileData::setPack_id()
     * @uses FileData::setEnv_id()
     * @uses FileData::setDoc_id()
     * @uses FileData::setAttachmentTypeCode()
     * @uses FileData::setSystemCode1()
     * @uses FileData::setName()
     * @uses FileData::setContent_type()
     * @uses FileData::setAttachment_id()
     * @param string $_
     * @param string $encoding
     * @param int $size
     * @param string $type
     * @param string $digest
     * @param string $signature_digest
     * @param string $pack_id
     * @param string $env_id
     * @param string $doc_id
     * @param string $attachmentTypeCode
     * @param string $systemCode1
     * @param string $name
     * @param string $content_type
     * @param string $attachment_id
     */
    public function __construct($_ = null, $encoding = null, $size = null, $type = null, $digest = null, $signature_digest = null, $pack_id = null, $env_id = null, $doc_id = null, $attachmentTypeCode = null, $systemCode1 = null, $name = null, $content_type = null, $attachment_id = null)
    {
        $this
            ->set_($_)
            ->setEncoding($encoding)
            ->setSize($size)
            ->setType($type)
            ->setDigest($digest)
            ->setSignature_digest($signature_digest)
            ->setPack_id($pack_id)
            ->setEnv_id($env_id)
            ->setDoc_id($doc_id)
            ->setAttachmentTypeCode($attachmentTypeCode)
            ->setSystemCode1($systemCode1)
            ->setName($name)
            ->setContent_type($content_type)
            ->setAttachment_id($attachment_id);
    }
    /**
     * Get _ value
     * @return string|null
     */
    public function get_()
    {
        return $this->_;
    }
    /**
     * Set _ value
     * @param string $_
     * @return \StructType\FileData
     */
    public function set_($_ = null)
    {
        $this->_ = $_;
        return $this;
    }
    /**
     * Get encoding value
     * @return string|null
     */
    public function getEncoding()
    {
        return $this->encoding;
    }
    /**
     * Set encoding value
     * @param string $encoding
     * @return \StructType\FileData
     */
    public function setEncoding($encoding = null)
    {
        $this->encoding = $encoding;
        return $this;
    }
    /**
     * Get size value
     * @return int|null
     */
    public function getSize()
    {
        return $this->size;
    }
    /**
     * Set size value
     * @param int $size
     * @return \StructType\FileData
     */
    public function setSize($size = null)
    {
        $this->size = $size;
        return $this;
    }
    /**
     * Get type value
     * @return string|null
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @uses \EnumType\FileType::valueIsValid()
     * @uses \EnumType\FileType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $type
     * @return \StructType\FileData
     */
    public function setType($type = null)
    {
        $this->type = $type;
        return $this;
    }
    /**
     * Get digest value
     * @return string|null
     */
    public function getDigest()
    {
        return $this->digest;
    }
    /**
     * Set digest value
     * @param string $digest
     * @return \StructType\FileData
     */
    public function setDigest($digest = null)
    {
        $this->digest = $digest;
        return $this;
    }
    /**
     * Get signature_digest value
     * @return string|null
     */
    public function getSignature_digest()
    {
        return $this->signature_digest;
    }
    /**
     * Set signature_digest value
     * @param string $signature_digest
     * @return \StructType\FileData
     */
    public function setSignature_digest($signature_digest = null)
    {
        $this->signature_digest = $signature_digest;
        return $this;
    }
    /**
     * Get pack_id value
     * @return string|null
     */
    public function getPack_id()
    {
        return $this->pack_id;
    }
    /**
     * Set pack_id value
     * @param string $pack_id
     * @return \StructType\FileData
     */
    public function setPack_id($pack_id = null)
    {
        $this->pack_id = $pack_id;
        return $this;
    }
    /**
     * Get env_id value
     * @return string|null
     */
    public function getEnv_id()
    {
        return $this->env_id;
    }
    /**
     * Set env_id value
     * @param string $env_id
     * @return \StructType\FileData
     */
    public function setEnv_id($env_id = null)
    {
        $this->env_id = $env_id;
        return $this;
    }
    /**
     * Get doc_id value
     * @return string|null
     */
    public function getDoc_id()
    {
        return $this->doc_id;
    }
    /**
     * Set doc_id value
     * @param string $doc_id
     * @return \StructType\FileData
     */
    public function setDoc_id($doc_id = null)
    {
        $this->doc_id = $doc_id;
        return $this;
    }
    /**
     * Get attachmentTypeCode value
     * @return string|null
     */
    public function getAttachmentTypeCode()
    {
        return $this->attachmentTypeCode;
    }
    /**
     * Set attachmentTypeCode value
     * @param string $attachmentTypeCode
     * @return \StructType\FileData
     */
    public function setAttachmentTypeCode($attachmentTypeCode = null)
    {
        $this->attachmentTypeCode = $attachmentTypeCode;
        return $this;
    }
    /**
     * Get systemCode1 value
     * @return string|null
     */
    public function getSystemCode1()
    {
        return $this->systemCode1;
    }
    /**
     * Set systemCode1 value
     * @param string $systemCode1
     * @return \StructType\FileData
     */
    public function setSystemCode1($systemCode1 = null)
    {
        $this->systemCode1 = $systemCode1;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\FileData
     */
    public function setName($name = null)
    {
        $this->name = $name;
        return $this;
    }
    /**
     * Get content_type value
     * @return string|null
     */
    public function getContent_type()
    {
        return $this->content_type;
    }
    /**
     * Set content_type value
     * @param string $content_type
     * @return \StructType\FileData
     */
    public function setContent_type($content_type = null)
    {
        $this->content_type = $content_type;
        return $this;
    }
    /**
     * Get attachment_id value
     * @return string|null
     */
    public function getAttachment_id()
    {
        return $this->attachment_id;
    }
    /**
     * Set attachment_id value
     * @param string $attachment_id
     * @return \StructType\FileData
     */
    public function setAttachment_id($attachment_id = null)
    {
        $this->attachment_id = $attachment_id;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\FileData
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
