<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ExtDebtFix StructType
 * Meta informations extracted from the WSDL
 * - documentation: Документ ExtDebtFix «Погашение ИД» | Содержит сведения о самостоятельном погашении долга должником по ИД непосредственно
 * взыскателю (не через депозитный счет). Сведения включают проверочную информацию о должнике в связи с неуникальностью реквизитов
 * исполнительного документа | ЭП
 * - type: tns:ExtDebtFix
 * @subpackage Structs
 */
class ExtDebtFix extends AbstractStructBase
{
    /**
     * The ExternalKey
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор АИС ВК | Идентификатор документа, присвоенный АИС внешнего контрагента. Уникален в рамках типа документа и
     * конкретного внешнего контрагента | Идентификатор объекта, присвоенный объекту АИС внешнего контрагентом (ФНС, ПФР и прочие). Данный
     * идентификатор должен быть уникальным для типа идентифицируемого документа в пространстве обмена данными с конкретным внешним
     * контрагентом.
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $ExternalKey;
    /**
     * The IdExternalKey
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор ИД АИС ВК | Идентификатор исполнительного документа, полученного ранее от АИС внешнего контрагента |
     * Идентификатор объекта, присвоенный объекту АИС внешнего контрагентом (ФНС, ПФР и прочие). Данный идентификатор должен быть уникальным
     * для типа идентифицируемого документа в пространстве обмена данными с конкретным внешним контрагентом.
     * - minOccurs: 0
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $IdExternalKey;
    /**
     * The IDNum
     * Meta informations extracted from the WSDL
     * - documentation: Номер ИД | Номер документа
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $IDNum;
    /**
     * The IDDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата ИД | Дата | Дата
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $IDDate;
    /**
     * The DebtorBirthDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата рождения должника (для ФЛ) | Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $DebtorBirthDate;
    /**
     * The DebtorBirthYear
     * Meta informations extracted from the WSDL
     * - documentation: Год рождения ФЛ | Год (выпуска, рождения и т. п.)
     * - minOccurs: 0
     * - maxInclusive: 2099
     * - minInclusive: 1900
     * @var string
     */
    public $DebtorBirthYear;
    /**
     * The DebtorINN
     * Meta informations extracted from the WSDL
     * - documentation: ИНН должника (для ИП/ЮЛ) | ИНН
     * - minOccurs: 0
     * - maxLength: 12
     * - minLength: 10
     * - pattern: (([0-9]{1}[1-9]{1}|[1-9]{1}[0-9]{1})[0-9]{8})|(([0-9]{1}[1-9]{1}|[1-9]{1}[0-9]{1})[0-9]{10})
     * @var string
     */
    public $DebtorINN;
    /**
     * The DebtorKPP
     * Meta informations extracted from the WSDL
     * - documentation: КПП должника | Код причины постановки на учет ЮЛ | КПП
     * - minOccurs: 0
     * - length: 9
     * - pattern: ([0-9]{1}[1-9]{1}|[1-9]{1}[0-9]{1})[0-9]{7}
     * @var string
     */
    public $DebtorKPP;
    /**
     * The DebtorOGRN
     * Meta informations extracted from the WSDL
     * - documentation: ОГРН/ОГРНИП | ОГРН/ОГРНИП ЮЛ/ИП | Основной государственный регистрационный номер (ОГРН)/Основной государственный
     * регистрационный номер индивидуального предпринимателя (ОГРНИП)
     * - minOccurs: 0
     * - maxLength: 15
     * - minLength: 13
     * - pattern: ([0-9]{13})|([0-9]{15})
     * @var string
     */
    public $DebtorOGRN;
    /**
     * The DebtorAdr
     * Meta informations extracted from the WSDL
     * - documentation: Адрес должника | Адрес должника в формате «Код страны» + «запятая» + «Адрес в формате 9 запятых по КЛАДР» или (в случае отсутствия
     * кода страны) в произвольном формате | Строка длиной от 1 до 300 символов
     * - maxLength: 300
     * - minLength: 1
     * @var string
     */
    public $DebtorAdr;
    /**
     * The PaySum
     * Meta informations extracted from the WSDL
     * - documentation: Сумма платежа | Сумма
     * - minOccurs: 0
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $PaySum;
    /**
     * The PDDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата платежного документа | Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $PDDate;
    /**
     * The PDNum
     * Meta informations extracted from the WSDL
     * - documentation: Номер платежного документа | Строка длиной от 1 до 36 символов
     * - minOccurs: 0
     * - maxLength: 36
     * - minLength: 1
     * @var string
     */
    public $PDNum;
    /**
     * The ChargeStatus
     * Meta informations extracted from the WSDL
     * - documentation: Статус платежа | Статус, отображающий изменение данных платежа, полученный от ГИС ГМП
     * - minOccurs: 0
     * @var string
     */
    public $ChargeStatus;
    /**
     * The IPNum
     * Meta informations extracted from the WSDL
     * - documentation: Номер ИП | Номер документа
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $IPNum;
    /**
     * The IsPayingOff
     * Meta informations extracted from the WSDL
     * - documentation: Уточнение или погашение
     * @var string
     */
    public $IsPayingOff;
    /**
     * The ExtDebtFixBase
     * Meta informations extracted from the WSDL
     * - documentation: Погашение ИД | Электронное обращение составленный в соответствии с форматом Приложения № 3 «Форматы электронного обращение» в
     * кодировке Base64
     * - minOccurs: 0
     * @var string
     */
    public $ExtDebtFixBase;
    /**
     * The SignatureBase
     * Meta informations extracted from the WSDL
     * - documentation: ЭП Погашение ИД | Электронное обращение составленный в соответствии с форматом Приложения № 3 «Форматы электронного
     * обращение» в кодировке Base64
     * - minOccurs: 0
     * @var string
     */
    public $SignatureBase;
    /**
     * The PaymentProperties
     * Meta informations extracted from the WSDL
     * - documentation: Реквизиты для перечисления | Реквизиты для перечисления взысканных сумм взыскателю (для налоговых платежей может быть указано
     * больше одного набора реквизитов). Тип данных описан в документе «Исполнительный документ»
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\PaymentProperties[]
     */
    public $PaymentProperties;
    /**
     * The attachments
     * Meta informations extracted from the WSDL
     * - documentation: Прикрепленные файлы
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\AttachmentType[]
     */
    public $attachments;
    /**
     * The SignDateTime
     * Meta informations extracted from the WSDL
     * - documentation: Дата и время формирования подписи | Дата и время | Дата и время
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01T00:00:00
     * - minInclusive: 1900-01-01T00:00:00
     * @var string
     */
    public $SignDateTime;
    /**
     * The Signature
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: ds:Signature
     * @var \StructType\SignatureType[]
     */
    public $Signature;
    /**
     * The Id
     * Meta informations extracted from the WSDL
     * - documentation: Атрибут документа | Идентификатор объекта | Атрибут документа
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $Id;
    /**
     * Constructor method for ExtDebtFix
     * @uses ExtDebtFix::setExternalKey()
     * @uses ExtDebtFix::setIdExternalKey()
     * @uses ExtDebtFix::setIDNum()
     * @uses ExtDebtFix::setIDDate()
     * @uses ExtDebtFix::setDebtorBirthDate()
     * @uses ExtDebtFix::setDebtorBirthYear()
     * @uses ExtDebtFix::setDebtorINN()
     * @uses ExtDebtFix::setDebtorKPP()
     * @uses ExtDebtFix::setDebtorOGRN()
     * @uses ExtDebtFix::setDebtorAdr()
     * @uses ExtDebtFix::setPaySum()
     * @uses ExtDebtFix::setPDDate()
     * @uses ExtDebtFix::setPDNum()
     * @uses ExtDebtFix::setChargeStatus()
     * @uses ExtDebtFix::setIPNum()
     * @uses ExtDebtFix::setIsPayingOff()
     * @uses ExtDebtFix::setExtDebtFixBase()
     * @uses ExtDebtFix::setSignatureBase()
     * @uses ExtDebtFix::setPaymentProperties()
     * @uses ExtDebtFix::setAttachments()
     * @uses ExtDebtFix::setSignDateTime()
     * @uses ExtDebtFix::setSignature()
     * @uses ExtDebtFix::setId()
     * @param string $externalKey
     * @param string $idExternalKey
     * @param string $iDNum
     * @param string $iDDate
     * @param string $debtorBirthDate
     * @param string $debtorBirthYear
     * @param string $debtorINN
     * @param string $debtorKPP
     * @param string $debtorOGRN
     * @param string $debtorAdr
     * @param float $paySum
     * @param string $pDDate
     * @param string $pDNum
     * @param string $chargeStatus
     * @param string $iPNum
     * @param string $isPayingOff
     * @param string $extDebtFixBase
     * @param string $signatureBase
     * @param \StructType\PaymentProperties[] $paymentProperties
     * @param \StructType\AttachmentType[] $attachments
     * @param string $signDateTime
     * @param \StructType\SignatureType[] $signature
     * @param string $id
     */
    public function __construct($externalKey = null, $idExternalKey = null, $iDNum = null, $iDDate = null, $debtorBirthDate = null, $debtorBirthYear = null, $debtorINN = null, $debtorKPP = null, $debtorOGRN = null, $debtorAdr = null, $paySum = null, $pDDate = null, $pDNum = null, $chargeStatus = null, $iPNum = null, $isPayingOff = null, $extDebtFixBase = null, $signatureBase = null, array $paymentProperties = array(), array $attachments = array(), $signDateTime = null, array $signature = array(), $id = null)
    {
        $this
            ->setExternalKey($externalKey)
            ->setIdExternalKey($idExternalKey)
            ->setIDNum($iDNum)
            ->setIDDate($iDDate)
            ->setDebtorBirthDate($debtorBirthDate)
            ->setDebtorBirthYear($debtorBirthYear)
            ->setDebtorINN($debtorINN)
            ->setDebtorKPP($debtorKPP)
            ->setDebtorOGRN($debtorOGRN)
            ->setDebtorAdr($debtorAdr)
            ->setPaySum($paySum)
            ->setPDDate($pDDate)
            ->setPDNum($pDNum)
            ->setChargeStatus($chargeStatus)
            ->setIPNum($iPNum)
            ->setIsPayingOff($isPayingOff)
            ->setExtDebtFixBase($extDebtFixBase)
            ->setSignatureBase($signatureBase)
            ->setPaymentProperties($paymentProperties)
            ->setAttachments($attachments)
            ->setSignDateTime($signDateTime)
            ->setSignature($signature)
            ->setId($id);
    }
    /**
     * Get ExternalKey value
     * @return string|null
     */
    public function getExternalKey()
    {
        return $this->ExternalKey;
    }
    /**
     * Set ExternalKey value
     * @param string $externalKey
     * @return \StructType\ExtDebtFix
     */
    public function setExternalKey($externalKey = null)
    {
        $this->ExternalKey = $externalKey;
        return $this;
    }
    /**
     * Get IdExternalKey value
     * @return string|null
     */
    public function getIdExternalKey()
    {
        return $this->IdExternalKey;
    }
    /**
     * Set IdExternalKey value
     * @param string $idExternalKey
     * @return \StructType\ExtDebtFix
     */
    public function setIdExternalKey($idExternalKey = null)
    {
        $this->IdExternalKey = $idExternalKey;
        return $this;
    }
    /**
     * Get IDNum value
     * @return string|null
     */
    public function getIDNum()
    {
        return $this->IDNum;
    }
    /**
     * Set IDNum value
     * @param string $iDNum
     * @return \StructType\ExtDebtFix
     */
    public function setIDNum($iDNum = null)
    {
        $this->IDNum = $iDNum;
        return $this;
    }
    /**
     * Get IDDate value
     * @return string|null
     */
    public function getIDDate()
    {
        return $this->IDDate;
    }
    /**
     * Set IDDate value
     * @param string $iDDate
     * @return \StructType\ExtDebtFix
     */
    public function setIDDate($iDDate = null)
    {
        $this->IDDate = $iDDate;
        return $this;
    }
    /**
     * Get DebtorBirthDate value
     * @return string|null
     */
    public function getDebtorBirthDate()
    {
        return $this->DebtorBirthDate;
    }
    /**
     * Set DebtorBirthDate value
     * @param string $debtorBirthDate
     * @return \StructType\ExtDebtFix
     */
    public function setDebtorBirthDate($debtorBirthDate = null)
    {
        $this->DebtorBirthDate = $debtorBirthDate;
        return $this;
    }
    /**
     * Get DebtorBirthYear value
     * @return string|null
     */
    public function getDebtorBirthYear()
    {
        return $this->DebtorBirthYear;
    }
    /**
     * Set DebtorBirthYear value
     * @param string $debtorBirthYear
     * @return \StructType\ExtDebtFix
     */
    public function setDebtorBirthYear($debtorBirthYear = null)
    {
        $this->DebtorBirthYear = $debtorBirthYear;
        return $this;
    }
    /**
     * Get DebtorINN value
     * @return string|null
     */
    public function getDebtorINN()
    {
        return $this->DebtorINN;
    }
    /**
     * Set DebtorINN value
     * @param string $debtorINN
     * @return \StructType\ExtDebtFix
     */
    public function setDebtorINN($debtorINN = null)
    {
        $this->DebtorINN = $debtorINN;
        return $this;
    }
    /**
     * Get DebtorKPP value
     * @return string|null
     */
    public function getDebtorKPP()
    {
        return $this->DebtorKPP;
    }
    /**
     * Set DebtorKPP value
     * @param string $debtorKPP
     * @return \StructType\ExtDebtFix
     */
    public function setDebtorKPP($debtorKPP = null)
    {
        $this->DebtorKPP = $debtorKPP;
        return $this;
    }
    /**
     * Get DebtorOGRN value
     * @return string|null
     */
    public function getDebtorOGRN()
    {
        return $this->DebtorOGRN;
    }
    /**
     * Set DebtorOGRN value
     * @param string $debtorOGRN
     * @return \StructType\ExtDebtFix
     */
    public function setDebtorOGRN($debtorOGRN = null)
    {
        $this->DebtorOGRN = $debtorOGRN;
        return $this;
    }
    /**
     * Get DebtorAdr value
     * @return string|null
     */
    public function getDebtorAdr()
    {
        return $this->DebtorAdr;
    }
    /**
     * Set DebtorAdr value
     * @param string $debtorAdr
     * @return \StructType\ExtDebtFix
     */
    public function setDebtorAdr($debtorAdr = null)
    {
        $this->DebtorAdr = $debtorAdr;
        return $this;
    }
    /**
     * Get PaySum value
     * @return float|null
     */
    public function getPaySum()
    {
        return $this->PaySum;
    }
    /**
     * Set PaySum value
     * @param float $paySum
     * @return \StructType\ExtDebtFix
     */
    public function setPaySum($paySum = null)
    {
        $this->PaySum = $paySum;
        return $this;
    }
    /**
     * Get PDDate value
     * @return string|null
     */
    public function getPDDate()
    {
        return $this->PDDate;
    }
    /**
     * Set PDDate value
     * @param string $pDDate
     * @return \StructType\ExtDebtFix
     */
    public function setPDDate($pDDate = null)
    {
        $this->PDDate = $pDDate;
        return $this;
    }
    /**
     * Get PDNum value
     * @return string|null
     */
    public function getPDNum()
    {
        return $this->PDNum;
    }
    /**
     * Set PDNum value
     * @param string $pDNum
     * @return \StructType\ExtDebtFix
     */
    public function setPDNum($pDNum = null)
    {
        $this->PDNum = $pDNum;
        return $this;
    }
    /**
     * Get ChargeStatus value
     * @return string|null
     */
    public function getChargeStatus()
    {
        return $this->ChargeStatus;
    }
    /**
     * Set ChargeStatus value
     * @uses \EnumType\ChargeStatusType::valueIsValid()
     * @uses \EnumType\ChargeStatusType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $chargeStatus
     * @return \StructType\ExtDebtFix
     */
    public function setChargeStatus($chargeStatus = null)
    {
        $this->ChargeStatus = $chargeStatus;
        return $this;
    }
    /**
     * Get IPNum value
     * @return string|null
     */
    public function getIPNum()
    {
        return $this->IPNum;
    }
    /**
     * Set IPNum value
     * @param string $iPNum
     * @return \StructType\ExtDebtFix
     */
    public function setIPNum($iPNum = null)
    {
        $this->IPNum = $iPNum;
        return $this;
    }
    /**
     * Get IsPayingOff value
     * @return string|null
     */
    public function getIsPayingOff()
    {
        return $this->IsPayingOff;
    }
    /**
     * Set IsPayingOff value
     * @uses \EnumType\PayOffFlagType::valueIsValid()
     * @uses \EnumType\PayOffFlagType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $isPayingOff
     * @return \StructType\ExtDebtFix
     */
    public function setIsPayingOff($isPayingOff = null)
    {
        $this->IsPayingOff = $isPayingOff;
        return $this;
    }
    /**
     * Get ExtDebtFixBase value
     * @return string|null
     */
    public function getExtDebtFixBase()
    {
        return $this->ExtDebtFixBase;
    }
    /**
     * Set ExtDebtFixBase value
     * @param string $extDebtFixBase
     * @return \StructType\ExtDebtFix
     */
    public function setExtDebtFixBase($extDebtFixBase = null)
    {
        $this->ExtDebtFixBase = $extDebtFixBase;
        return $this;
    }
    /**
     * Get SignatureBase value
     * @return string|null
     */
    public function getSignatureBase()
    {
        return $this->SignatureBase;
    }
    /**
     * Set SignatureBase value
     * @param string $signatureBase
     * @return \StructType\ExtDebtFix
     */
    public function setSignatureBase($signatureBase = null)
    {
        $this->SignatureBase = $signatureBase;
        return $this;
    }
    /**
     * Get PaymentProperties value
     * @return \StructType\PaymentProperties[]|null
     */
    public function getPaymentProperties()
    {
        return $this->PaymentProperties;
    }
    /**
     * Set PaymentProperties value
     * @throws \InvalidArgumentException
     * @param \StructType\PaymentProperties[] $paymentProperties
     * @return \StructType\ExtDebtFix
     */
    public function setPaymentProperties(array $paymentProperties = array())
    {
        $this->PaymentProperties = $paymentProperties;
        return $this;
    }
    /**
     * Add item to PaymentProperties value
     * @throws \InvalidArgumentException
     * @param \StructType\PaymentProperties $item
     * @return \StructType\ExtDebtFix
     */
    public function addToPaymentProperties(\StructType\PaymentProperties $item)
    {
        $this->PaymentProperties[] = $item;
        return $this;
    }
    /**
     * Get attachments value
     * @return \StructType\AttachmentType[]|null
     */
    public function getAttachments()
    {
        return $this->attachments;
    }
    /**
     * Set attachments value
     * @throws \InvalidArgumentException
     * @param \StructType\AttachmentType[] $attachments
     * @return \StructType\ExtDebtFix
     */
    public function setAttachments(array $attachments = array())
    {
        $this->attachments = $attachments;
        return $this;
    }
    /**
     * Add item to attachments value
     * @throws \InvalidArgumentException
     * @param \StructType\AttachmentType $item
     * @return \StructType\ExtDebtFix
     */
    public function addToAttachments(\StructType\AttachmentType $item)
    {
        $this->attachments[] = $item;
        return $this;
    }
    /**
     * Get SignDateTime value
     * @return string|null
     */
    public function getSignDateTime()
    {
        return $this->SignDateTime;
    }
    /**
     * Set SignDateTime value
     * @param string $signDateTime
     * @return \StructType\ExtDebtFix
     */
    public function setSignDateTime($signDateTime = null)
    {
        $this->SignDateTime = $signDateTime;
        return $this;
    }
    /**
     * Get Signature value
     * @return \StructType\SignatureType[]|null
     */
    public function getSignature()
    {
        return $this->Signature;
    }
    /**
     * Set Signature value
     * @throws \InvalidArgumentException
     * @param \StructType\SignatureType[] $signature
     * @return \StructType\ExtDebtFix
     */
    public function setSignature(array $signature = array())
    {
        $this->Signature = $signature;
        return $this;
    }
    /**
     * Add item to Signature value
     * @throws \InvalidArgumentException
     * @param \StructType\SignatureType $item
     * @return \StructType\ExtDebtFix
     */
    public function addToSignature(\StructType\SignatureType $item)
    {
        $this->Signature[] = $item;
        return $this;
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \StructType\ExtDebtFix
     */
    public function setId($id = null)
    {
        $this->Id = $id;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ExtDebtFix
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
