<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ExitRestrictionActInfo StructType
 * Meta informations extracted from the WSDL
 * - documentation: Сведения о наличии постановления об ограничении выезда | ЭП
 * - type: tns:ExitRestrictionActInfo
 * @subpackage Structs
 */
class ExitRestrictionActInfo extends AbstractStructBase
{
    /**
     * The internalKey
     * Meta informations extracted from the WSDL
     * - documentation: Ключ ФССП России | Ключ объекта, присвоенний информационной системой ФССП РФ при создании объекта или при получении объекта от
     * контрагента
     * - maxInclusive: 9223372036854775807
     * - minInclusive: -9223372036854775808
     * @var int
     */
    public $internalKey;
    /**
     * The requestKey
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор запроса АИС ВК | Идентификатор объекта, присвоенный объекту АИС внешнего контрагентом (ФНС, ПФР и прочие). Данный
     * идентификатор должен быть уникальным для типа идентифицируемого документа в пространстве обмена данными с конкретным внешним
     * контрагентом.
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $requestKey;
    /**
     * The isActExists
     * Meta informations extracted from the WSDL
     * - documentation: Признак наличия постановления | Обертка стандартного xs:boolean | Логический
     * @var bool
     */
    public $isActExists;
    /**
     * The docDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата постановления | Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $docDate;
    /**
     * The docNumber
     * Meta informations extracted from the WSDL
     * - documentation: Номер постановления | Номер документа
     * - minOccurs: 0
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $docNumber;
    /**
     * The term
     * Meta informations extracted from the WSDL
     * - documentation: Срок действия | Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $term;
    /**
     * The spiKey
     * Meta informations extracted from the WSDL
     * - documentation: Код СПИ | Ключ объекта, присвоенний информационной системой ФССП РФ при создании объекта или при получении объекта от
     * контрагента
     * - minOccurs: 0
     * - maxInclusive: 9223372036854775807
     * - minInclusive: -9223372036854775808
     * @var int
     */
    public $spiKey;
    /**
     * The spiName
     * Meta informations extracted from the WSDL
     * - documentation: ФИО СПИ | Полное имя физического лица (фамилия, имя, отчество)
     * - minOccurs: 0
     * - maxLength: 100
     * - minLength: 1
     * @var string
     */
    public $spiName;
    /**
     * The spiPostCode
     * Meta informations extracted from the WSDL
     * - documentation: Код должности СПИ | Код должности СПИ
     * - minOccurs: 0
     * - maxLength: 25
     * - minLength: 1
     * - pattern: [0-9\-\.\s]+
     * @var string
     */
    public $spiPostCode;
    /**
     * The spiPostName
     * Meta informations extracted from the WSDL
     * - documentation: Наименование должности СПИ | Строка длиной от 1 до 50 символов
     * - minOccurs: 0
     * - maxLength: 50
     * - minLength: 1
     * @var string
     */
    public $spiPostName;
    /**
     * The docCode
     * Meta informations extracted from the WSDL
     * - documentation: Код документа | Тип документа АИС ФССП России (тип документа ПКОСП) | Тип документа электронного документооборота | NSI_Document |
     * Наименование объекта NCORE
     * - minOccurs: 0
     * - maxLength: 31 | 31
     * - minLength: 1 | 1
     * @var string
     */
    public $docCode;
    /**
     * The reason
     * Meta informations extracted from the WSDL
     * - documentation: Основание решения СПИ | Строка длиной от 1 до 300 символов
     * - minOccurs: 0
     * - maxLength: 300
     * - minLength: 1
     * @var string
     */
    public $reason;
    /**
     * The article
     * Meta informations extracted from the WSDL
     * - documentation: Статья | Строка длиной от 1 до 10 символов
     * - minOccurs: 0
     * - maxLength: 10
     * - minLength: 1
     * @var string
     */
    public $article;
    /**
     * The point
     * Meta informations extracted from the WSDL
     * - documentation: Пункт статьи | Пункт статьи основания | Строка длиной от 1 до 10 символов
     * - minOccurs: 0
     * - maxLength: 10
     * - minLength: 1
     * @var string
     */
    public $point;
    /**
     * The part
     * Meta informations extracted from the WSDL
     * - documentation: Подпункт | Строка длиной от 1 до 10 символов
     * - minOccurs: 0
     * - maxLength: 10
     * - minLength: 1
     * @var string
     */
    public $part;
    /**
     * The ip
     * Meta informations extracted from the WSDL
     * - documentation: ИП
     * - minOccurs: 0
     * @var \StructType\IP
     */
    public $ip;
    /**
     * The data
     * Meta informations extracted from the WSDL
     * - documentation: Сведения
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Data[]
     */
    public $data;
    /**
     * The SignDateTime
     * Meta informations extracted from the WSDL
     * - documentation: Дата и время формирования подписи | Дата и время | Дата и время
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01T00:00:00
     * - minInclusive: 1900-01-01T00:00:00
     * @var string
     */
    public $SignDateTime;
    /**
     * The Signature
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: ds:Signature
     * @var \StructType\SignatureType[]
     */
    public $Signature;
    /**
     * The Id
     * Meta informations extracted from the WSDL
     * - documentation: Атрибут документа | Идентификатор объекта | Атрибут документа
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $Id;
    /**
     * Constructor method for ExitRestrictionActInfo
     * @uses ExitRestrictionActInfo::setInternalKey()
     * @uses ExitRestrictionActInfo::setRequestKey()
     * @uses ExitRestrictionActInfo::setIsActExists()
     * @uses ExitRestrictionActInfo::setDocDate()
     * @uses ExitRestrictionActInfo::setDocNumber()
     * @uses ExitRestrictionActInfo::setTerm()
     * @uses ExitRestrictionActInfo::setSpiKey()
     * @uses ExitRestrictionActInfo::setSpiName()
     * @uses ExitRestrictionActInfo::setSpiPostCode()
     * @uses ExitRestrictionActInfo::setSpiPostName()
     * @uses ExitRestrictionActInfo::setDocCode()
     * @uses ExitRestrictionActInfo::setReason()
     * @uses ExitRestrictionActInfo::setArticle()
     * @uses ExitRestrictionActInfo::setPoint()
     * @uses ExitRestrictionActInfo::setPart()
     * @uses ExitRestrictionActInfo::setIp()
     * @uses ExitRestrictionActInfo::setData()
     * @uses ExitRestrictionActInfo::setSignDateTime()
     * @uses ExitRestrictionActInfo::setSignature()
     * @uses ExitRestrictionActInfo::setId()
     * @param int $internalKey
     * @param string $requestKey
     * @param bool $isActExists
     * @param string $docDate
     * @param string $docNumber
     * @param string $term
     * @param int $spiKey
     * @param string $spiName
     * @param string $spiPostCode
     * @param string $spiPostName
     * @param string $docCode
     * @param string $reason
     * @param string $article
     * @param string $point
     * @param string $part
     * @param \StructType\IP $ip
     * @param \StructType\Data[] $data
     * @param string $signDateTime
     * @param \StructType\SignatureType[] $signature
     * @param string $id
     */
    public function __construct($internalKey = null, $requestKey = null, $isActExists = null, $docDate = null, $docNumber = null, $term = null, $spiKey = null, $spiName = null, $spiPostCode = null, $spiPostName = null, $docCode = null, $reason = null, $article = null, $point = null, $part = null, \StructType\IP $ip = null, array $data = array(), $signDateTime = null, array $signature = array(), $id = null)
    {
        $this
            ->setInternalKey($internalKey)
            ->setRequestKey($requestKey)
            ->setIsActExists($isActExists)
            ->setDocDate($docDate)
            ->setDocNumber($docNumber)
            ->setTerm($term)
            ->setSpiKey($spiKey)
            ->setSpiName($spiName)
            ->setSpiPostCode($spiPostCode)
            ->setSpiPostName($spiPostName)
            ->setDocCode($docCode)
            ->setReason($reason)
            ->setArticle($article)
            ->setPoint($point)
            ->setPart($part)
            ->setIp($ip)
            ->setData($data)
            ->setSignDateTime($signDateTime)
            ->setSignature($signature)
            ->setId($id);
    }
    /**
     * Get internalKey value
     * @return int|null
     */
    public function getInternalKey()
    {
        return $this->internalKey;
    }
    /**
     * Set internalKey value
     * @param int $internalKey
     * @return \StructType\ExitRestrictionActInfo
     */
    public function setInternalKey($internalKey = null)
    {
        $this->internalKey = $internalKey;
        return $this;
    }
    /**
     * Get requestKey value
     * @return string|null
     */
    public function getRequestKey()
    {
        return $this->requestKey;
    }
    /**
     * Set requestKey value
     * @param string $requestKey
     * @return \StructType\ExitRestrictionActInfo
     */
    public function setRequestKey($requestKey = null)
    {
        $this->requestKey = $requestKey;
        return $this;
    }
    /**
     * Get isActExists value
     * @return bool|null
     */
    public function getIsActExists()
    {
        return $this->isActExists;
    }
    /**
     * Set isActExists value
     * @param bool $isActExists
     * @return \StructType\ExitRestrictionActInfo
     */
    public function setIsActExists($isActExists = null)
    {
        $this->isActExists = $isActExists;
        return $this;
    }
    /**
     * Get docDate value
     * @return string|null
     */
    public function getDocDate()
    {
        return $this->docDate;
    }
    /**
     * Set docDate value
     * @param string $docDate
     * @return \StructType\ExitRestrictionActInfo
     */
    public function setDocDate($docDate = null)
    {
        $this->docDate = $docDate;
        return $this;
    }
    /**
     * Get docNumber value
     * @return string|null
     */
    public function getDocNumber()
    {
        return $this->docNumber;
    }
    /**
     * Set docNumber value
     * @param string $docNumber
     * @return \StructType\ExitRestrictionActInfo
     */
    public function setDocNumber($docNumber = null)
    {
        $this->docNumber = $docNumber;
        return $this;
    }
    /**
     * Get term value
     * @return string|null
     */
    public function getTerm()
    {
        return $this->term;
    }
    /**
     * Set term value
     * @param string $term
     * @return \StructType\ExitRestrictionActInfo
     */
    public function setTerm($term = null)
    {
        $this->term = $term;
        return $this;
    }
    /**
     * Get spiKey value
     * @return int|null
     */
    public function getSpiKey()
    {
        return $this->spiKey;
    }
    /**
     * Set spiKey value
     * @param int $spiKey
     * @return \StructType\ExitRestrictionActInfo
     */
    public function setSpiKey($spiKey = null)
    {
        $this->spiKey = $spiKey;
        return $this;
    }
    /**
     * Get spiName value
     * @return string|null
     */
    public function getSpiName()
    {
        return $this->spiName;
    }
    /**
     * Set spiName value
     * @param string $spiName
     * @return \StructType\ExitRestrictionActInfo
     */
    public function setSpiName($spiName = null)
    {
        $this->spiName = $spiName;
        return $this;
    }
    /**
     * Get spiPostCode value
     * @return string|null
     */
    public function getSpiPostCode()
    {
        return $this->spiPostCode;
    }
    /**
     * Set spiPostCode value
     * @param string $spiPostCode
     * @return \StructType\ExitRestrictionActInfo
     */
    public function setSpiPostCode($spiPostCode = null)
    {
        $this->spiPostCode = $spiPostCode;
        return $this;
    }
    /**
     * Get spiPostName value
     * @return string|null
     */
    public function getSpiPostName()
    {
        return $this->spiPostName;
    }
    /**
     * Set spiPostName value
     * @param string $spiPostName
     * @return \StructType\ExitRestrictionActInfo
     */
    public function setSpiPostName($spiPostName = null)
    {
        $this->spiPostName = $spiPostName;
        return $this;
    }
    /**
     * Get docCode value
     * @return string|null
     */
    public function getDocCode()
    {
        return $this->docCode;
    }
    /**
     * Set docCode value
     * @param string $docCode
     * @return \StructType\ExitRestrictionActInfo
     */
    public function setDocCode($docCode = null)
    {
        $this->docCode = $docCode;
        return $this;
    }
    /**
     * Get reason value
     * @return string|null
     */
    public function getReason()
    {
        return $this->reason;
    }
    /**
     * Set reason value
     * @param string $reason
     * @return \StructType\ExitRestrictionActInfo
     */
    public function setReason($reason = null)
    {
        $this->reason = $reason;
        return $this;
    }
    /**
     * Get article value
     * @return string|null
     */
    public function getArticle()
    {
        return $this->article;
    }
    /**
     * Set article value
     * @param string $article
     * @return \StructType\ExitRestrictionActInfo
     */
    public function setArticle($article = null)
    {
        $this->article = $article;
        return $this;
    }
    /**
     * Get point value
     * @return string|null
     */
    public function getPoint()
    {
        return $this->point;
    }
    /**
     * Set point value
     * @param string $point
     * @return \StructType\ExitRestrictionActInfo
     */
    public function setPoint($point = null)
    {
        $this->point = $point;
        return $this;
    }
    /**
     * Get part value
     * @return string|null
     */
    public function getPart()
    {
        return $this->part;
    }
    /**
     * Set part value
     * @param string $part
     * @return \StructType\ExitRestrictionActInfo
     */
    public function setPart($part = null)
    {
        $this->part = $part;
        return $this;
    }
    /**
     * Get ip value
     * @return \StructType\IP|null
     */
    public function getIp()
    {
        return $this->ip;
    }
    /**
     * Set ip value
     * @param \StructType\IP $ip
     * @return \StructType\ExitRestrictionActInfo
     */
    public function setIp(\StructType\IP $ip = null)
    {
        $this->ip = $ip;
        return $this;
    }
    /**
     * Get data value
     * @return \StructType\Data[]|null
     */
    public function getData()
    {
        return $this->data;
    }
    /**
     * Set data value
     * @throws \InvalidArgumentException
     * @param \StructType\Data[] $data
     * @return \StructType\ExitRestrictionActInfo
     */
    public function setData(array $data = array())
    {
        $this->data = $data;
        return $this;
    }
    /**
     * Add item to data value
     * @throws \InvalidArgumentException
     * @param \StructType\Data $item
     * @return \StructType\ExitRestrictionActInfo
     */
    public function addToData(\StructType\Data $item)
    {
        $this->data[] = $item;
        return $this;
    }
    /**
     * Get SignDateTime value
     * @return string|null
     */
    public function getSignDateTime()
    {
        return $this->SignDateTime;
    }
    /**
     * Set SignDateTime value
     * @param string $signDateTime
     * @return \StructType\ExitRestrictionActInfo
     */
    public function setSignDateTime($signDateTime = null)
    {
        $this->SignDateTime = $signDateTime;
        return $this;
    }
    /**
     * Get Signature value
     * @return \StructType\SignatureType[]|null
     */
    public function getSignature()
    {
        return $this->Signature;
    }
    /**
     * Set Signature value
     * @throws \InvalidArgumentException
     * @param \StructType\SignatureType[] $signature
     * @return \StructType\ExitRestrictionActInfo
     */
    public function setSignature(array $signature = array())
    {
        $this->Signature = $signature;
        return $this;
    }
    /**
     * Add item to Signature value
     * @throws \InvalidArgumentException
     * @param \StructType\SignatureType $item
     * @return \StructType\ExitRestrictionActInfo
     */
    public function addToSignature(\StructType\SignatureType $item)
    {
        $this->Signature[] = $item;
        return $this;
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \StructType\ExitRestrictionActInfo
     */
    public function setId($id = null)
    {
        $this->Id = $id;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ExitRestrictionActInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
