<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EmbeddedDocumentType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Документ в формате принудительного исполнения в электронном виде | Используется для передачи юридически значимых документов
 * в соответствующем формате. Тип данных позволяет передавать документ в двоичной форме, подпись документа в формате PKCS#7, а также вложения
 * документа
 * @subpackage Structs
 */
class EmbeddedDocumentType extends AbstractStructBase
{
    /**
     * The DocType
     * Meta informations extracted from the WSDL
     * - documentation: Тип документа АИС ФССП России (тип документа ПКОСП) | Тип документа электронного документооборота | NSI_Document | Наименование
     * объекта NCORE
     * - maxLength: 31 | 31
     * - minLength: 1 | 1
     * @var string
     */
    public $DocType;
    /**
     * The DocNumber
     * Meta informations extracted from the WSDL
     * - documentation: Номер документа
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $DocNumber;
    /**
     * The DocDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата | Дата
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $DocDate;
    /**
     * The Content
     * Meta informations extracted from the WSDL
     * - documentation: Данные документа
     * @var string
     */
    public $Content;
    /**
     * The DigitalSignature
     * Meta informations extracted from the WSDL
     * - documentation: ЭП документа | Подпись документа в формате PKCS#7 detached
     * - minOccurs: 0
     * @var string
     */
    public $DigitalSignature;
    /**
     * The Attachments
     * Meta informations extracted from the WSDL
     * - documentation: Вложения
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\AttachmentType[]
     */
    public $Attachments;
    /**
     * Constructor method for EmbeddedDocumentType
     * @uses EmbeddedDocumentType::setDocType()
     * @uses EmbeddedDocumentType::setDocNumber()
     * @uses EmbeddedDocumentType::setDocDate()
     * @uses EmbeddedDocumentType::setContent()
     * @uses EmbeddedDocumentType::setDigitalSignature()
     * @uses EmbeddedDocumentType::setAttachments()
     * @param string $docType
     * @param string $docNumber
     * @param string $docDate
     * @param string $content
     * @param string $digitalSignature
     * @param \StructType\AttachmentType[] $attachments
     */
    public function __construct($docType = null, $docNumber = null, $docDate = null, $content = null, $digitalSignature = null, array $attachments = array())
    {
        $this
            ->setDocType($docType)
            ->setDocNumber($docNumber)
            ->setDocDate($docDate)
            ->setContent($content)
            ->setDigitalSignature($digitalSignature)
            ->setAttachments($attachments);
    }
    /**
     * Get DocType value
     * @return string|null
     */
    public function getDocType()
    {
        return $this->DocType;
    }
    /**
     * Set DocType value
     * @param string $docType
     * @return \StructType\EmbeddedDocumentType
     */
    public function setDocType($docType = null)
    {
        $this->DocType = $docType;
        return $this;
    }
    /**
     * Get DocNumber value
     * @return string|null
     */
    public function getDocNumber()
    {
        return $this->DocNumber;
    }
    /**
     * Set DocNumber value
     * @param string $docNumber
     * @return \StructType\EmbeddedDocumentType
     */
    public function setDocNumber($docNumber = null)
    {
        $this->DocNumber = $docNumber;
        return $this;
    }
    /**
     * Get DocDate value
     * @return string|null
     */
    public function getDocDate()
    {
        return $this->DocDate;
    }
    /**
     * Set DocDate value
     * @param string $docDate
     * @return \StructType\EmbeddedDocumentType
     */
    public function setDocDate($docDate = null)
    {
        $this->DocDate = $docDate;
        return $this;
    }
    /**
     * Get Content value
     * @return string|null
     */
    public function getContent()
    {
        return $this->Content;
    }
    /**
     * Set Content value
     * @param string $content
     * @return \StructType\EmbeddedDocumentType
     */
    public function setContent($content = null)
    {
        $this->Content = $content;
        return $this;
    }
    /**
     * Get DigitalSignature value
     * @return string|null
     */
    public function getDigitalSignature()
    {
        return $this->DigitalSignature;
    }
    /**
     * Set DigitalSignature value
     * @param string $digitalSignature
     * @return \StructType\EmbeddedDocumentType
     */
    public function setDigitalSignature($digitalSignature = null)
    {
        $this->DigitalSignature = $digitalSignature;
        return $this;
    }
    /**
     * Get Attachments value
     * @return \StructType\AttachmentType[]|null
     */
    public function getAttachments()
    {
        return $this->Attachments;
    }
    /**
     * Set Attachments value
     * @throws \InvalidArgumentException
     * @param \StructType\AttachmentType[] $attachments
     * @return \StructType\EmbeddedDocumentType
     */
    public function setAttachments(array $attachments = array())
    {
        $this->Attachments = $attachments;
        return $this;
    }
    /**
     * Add item to Attachments value
     * @throws \InvalidArgumentException
     * @param \StructType\AttachmentType $item
     * @return \StructType\EmbeddedDocumentType
     */
    public function addToAttachments(\StructType\AttachmentType $item)
    {
        $this->Attachments[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\EmbeddedDocumentType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
