<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EgrulEgripDatumType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Сведения о записи в ЕГРЮЛ или ЕГРИП
 * @subpackage Structs
 */
class EgrulEgripDatumType extends InformationType
{
    /**
     * The regId
     * Meta informations extracted from the WSDL
     * - documentation: Регистрационный номер в базе данных | Идентификатор записи в БД ФНС (для ЕГРЮЛ/ЕГРИП)
     * - totalDigits: 15
     * @var int
     */
    public $regId;
    /**
     * The regNumber
     * Meta informations extracted from the WSDL
     * - documentation: Государственный регистрационный номер записи | Основной государственный регистрационный номер (ОГРН)/Основной
     * государственный регистрационный номер индивидуального предпринимателя (ОГРНИП)
     * - maxLength: 15
     * - minLength: 13
     * - pattern: ([0-9]{13})|([0-9]{15})
     * @var string
     */
    public $regNumber;
    /**
     * The regDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата регистрации | Дата | Дата
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $regDate;
    /**
     * The regKindId
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор вида регистрации | Идентификатор записи в БД ФНС (для ЕГРЮЛ/ЕГРИП)
     * - totalDigits: 15
     * @var int
     */
    public $regKindId;
    /**
     * The regKindName
     * Meta informations extracted from the WSDL
     * - documentation: Наименование вида регистрации | Строка длиной от 1 до 255 символов
     * - maxLength: 255
     * - minLength: 1
     * @var string
     */
    public $regKindName;
    /**
     * The certSeries
     * Meta informations extracted from the WSDL
     * - documentation: Серия свидетельства | Строка длиной 2 символа
     * - minOccurs: 0
     * - length: 2
     * @var string
     */
    public $certSeries;
    /**
     * The certNumber
     * Meta informations extracted from the WSDL
     * - documentation: Номер свидетельства | Строка длиной 9 символов
     * - minOccurs: 0
     * - length: 9
     * @var string
     */
    public $certNumber;
    /**
     * The stateId
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор состояния записи | Идентификатор записи в БД ФНС (для ЕГРЮЛ/ЕГРИП)
     * - minOccurs: 0
     * - totalDigits: 15
     * @var int
     */
    public $stateId;
    /**
     * The stateName
     * Meta informations extracted from the WSDL
     * - documentation: Наименование состояния записи | Строка длиной от 1 до 255 символов
     * - minOccurs: 0
     * - maxLength: 255
     * - minLength: 1
     * @var string
     */
    public $stateName;
    /**
     * Constructor method for EgrulEgripDatumType
     * @uses EgrulEgripDatumType::setRegId()
     * @uses EgrulEgripDatumType::setRegNumber()
     * @uses EgrulEgripDatumType::setRegDate()
     * @uses EgrulEgripDatumType::setRegKindId()
     * @uses EgrulEgripDatumType::setRegKindName()
     * @uses EgrulEgripDatumType::setCertSeries()
     * @uses EgrulEgripDatumType::setCertNumber()
     * @uses EgrulEgripDatumType::setStateId()
     * @uses EgrulEgripDatumType::setStateName()
     * @param int $regId
     * @param string $regNumber
     * @param string $regDate
     * @param int $regKindId
     * @param string $regKindName
     * @param string $certSeries
     * @param string $certNumber
     * @param int $stateId
     * @param string $stateName
     */
    public function __construct($regId = null, $regNumber = null, $regDate = null, $regKindId = null, $regKindName = null, $certSeries = null, $certNumber = null, $stateId = null, $stateName = null)
    {
        $this
            ->setRegId($regId)
            ->setRegNumber($regNumber)
            ->setRegDate($regDate)
            ->setRegKindId($regKindId)
            ->setRegKindName($regKindName)
            ->setCertSeries($certSeries)
            ->setCertNumber($certNumber)
            ->setStateId($stateId)
            ->setStateName($stateName);
    }
    /**
     * Get regId value
     * @return int|null
     */
    public function getRegId()
    {
        return $this->regId;
    }
    /**
     * Set regId value
     * @param int $regId
     * @return \StructType\EgrulEgripDatumType
     */
    public function setRegId($regId = null)
    {
        $this->regId = $regId;
        return $this;
    }
    /**
     * Get regNumber value
     * @return string|null
     */
    public function getRegNumber()
    {
        return $this->regNumber;
    }
    /**
     * Set regNumber value
     * @param string $regNumber
     * @return \StructType\EgrulEgripDatumType
     */
    public function setRegNumber($regNumber = null)
    {
        $this->regNumber = $regNumber;
        return $this;
    }
    /**
     * Get regDate value
     * @return string|null
     */
    public function getRegDate()
    {
        return $this->regDate;
    }
    /**
     * Set regDate value
     * @param string $regDate
     * @return \StructType\EgrulEgripDatumType
     */
    public function setRegDate($regDate = null)
    {
        $this->regDate = $regDate;
        return $this;
    }
    /**
     * Get regKindId value
     * @return int|null
     */
    public function getRegKindId()
    {
        return $this->regKindId;
    }
    /**
     * Set regKindId value
     * @param int $regKindId
     * @return \StructType\EgrulEgripDatumType
     */
    public function setRegKindId($regKindId = null)
    {
        $this->regKindId = $regKindId;
        return $this;
    }
    /**
     * Get regKindName value
     * @return string|null
     */
    public function getRegKindName()
    {
        return $this->regKindName;
    }
    /**
     * Set regKindName value
     * @param string $regKindName
     * @return \StructType\EgrulEgripDatumType
     */
    public function setRegKindName($regKindName = null)
    {
        $this->regKindName = $regKindName;
        return $this;
    }
    /**
     * Get certSeries value
     * @return string|null
     */
    public function getCertSeries()
    {
        return $this->certSeries;
    }
    /**
     * Set certSeries value
     * @param string $certSeries
     * @return \StructType\EgrulEgripDatumType
     */
    public function setCertSeries($certSeries = null)
    {
        $this->certSeries = $certSeries;
        return $this;
    }
    /**
     * Get certNumber value
     * @return string|null
     */
    public function getCertNumber()
    {
        return $this->certNumber;
    }
    /**
     * Set certNumber value
     * @param string $certNumber
     * @return \StructType\EgrulEgripDatumType
     */
    public function setCertNumber($certNumber = null)
    {
        $this->certNumber = $certNumber;
        return $this;
    }
    /**
     * Get stateId value
     * @return int|null
     */
    public function getStateId()
    {
        return $this->stateId;
    }
    /**
     * Set stateId value
     * @param int $stateId
     * @return \StructType\EgrulEgripDatumType
     */
    public function setStateId($stateId = null)
    {
        $this->stateId = $stateId;
        return $this;
    }
    /**
     * Get stateName value
     * @return string|null
     */
    public function getStateName()
    {
        return $this->stateName;
    }
    /**
     * Set stateName value
     * @param string $stateName
     * @return \StructType\EgrulEgripDatumType
     */
    public function setStateName($stateName = null)
    {
        $this->stateName = $stateName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\EgrulEgripDatumType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
