<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EQNotifyAppResult StructType
 * Meta informations extracted from the WSDL
 * - documentation: Ответ на изменение статуса заявки записи на приём
 * - type: tns:EQNotifyAppResult
 * @subpackage Structs
 */
class EQNotifyAppResult extends AbstractStructBase
{
    /**
     * The RequestExternalKey
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор АИС ВК | Идентификатор объекта, присвоенный объекту АИС внешнего контрагентом (ФНС, ПФР и прочие). Данный
     * идентификатор должен быть уникальным для типа идентифицируемого документа в пространстве обмена данными с конкретным внешним
     * контрагентом.
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $RequestExternalKey;
    /**
     * The AppId
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор заявки | Ключ объекта, присвоенний информационной системой ФССП РФ при создании объекта или при получении
     * объекта от контрагента
     * - maxInclusive: 9223372036854775807
     * - minInclusive: -9223372036854775808
     * @var int
     */
    public $AppId;
    /**
     * The ResultStatus
     * Meta informations extracted from the WSDL
     * - documentation: Статус выполнения действия
     * @var string
     */
    public $ResultStatus;
    /**
     * The ErrorCode
     * Meta informations extracted from the WSDL
     * - documentation: Код ошибки | Целое | Целое
     * - minOccurs: 0
     * - maxInclusive: 2147483647
     * @var int
     */
    public $ErrorCode;
    /**
     * The ErrortText
     * Meta informations extracted from the WSDL
     * - documentation: Описание ошибки | Массив произвольных данных (текстовый)
     * - minOccurs: 0
     * @var string
     */
    public $ErrortText;
    /**
     * The AppResult
     * Meta informations extracted from the WSDL
     * - documentation: Результат обработка заявки
     * - minOccurs: 0
     * @var string
     */
    public $AppResult;
    /**
     * Constructor method for EQNotifyAppResult
     * @uses EQNotifyAppResult::setRequestExternalKey()
     * @uses EQNotifyAppResult::setAppId()
     * @uses EQNotifyAppResult::setResultStatus()
     * @uses EQNotifyAppResult::setErrorCode()
     * @uses EQNotifyAppResult::setErrortText()
     * @uses EQNotifyAppResult::setAppResult()
     * @param string $requestExternalKey
     * @param int $appId
     * @param string $resultStatus
     * @param int $errorCode
     * @param string $errortText
     * @param string $appResult
     */
    public function __construct($requestExternalKey = null, $appId = null, $resultStatus = null, $errorCode = null, $errortText = null, $appResult = null)
    {
        $this
            ->setRequestExternalKey($requestExternalKey)
            ->setAppId($appId)
            ->setResultStatus($resultStatus)
            ->setErrorCode($errorCode)
            ->setErrortText($errortText)
            ->setAppResult($appResult);
    }
    /**
     * Get RequestExternalKey value
     * @return string|null
     */
    public function getRequestExternalKey()
    {
        return $this->RequestExternalKey;
    }
    /**
     * Set RequestExternalKey value
     * @param string $requestExternalKey
     * @return \StructType\EQNotifyAppResult
     */
    public function setRequestExternalKey($requestExternalKey = null)
    {
        $this->RequestExternalKey = $requestExternalKey;
        return $this;
    }
    /**
     * Get AppId value
     * @return int|null
     */
    public function getAppId()
    {
        return $this->AppId;
    }
    /**
     * Set AppId value
     * @param int $appId
     * @return \StructType\EQNotifyAppResult
     */
    public function setAppId($appId = null)
    {
        $this->AppId = $appId;
        return $this;
    }
    /**
     * Get ResultStatus value
     * @return string|null
     */
    public function getResultStatus()
    {
        return $this->ResultStatus;
    }
    /**
     * Set ResultStatus value
     * @uses \EnumType\EQAppointmentStatusType::valueIsValid()
     * @uses \EnumType\EQAppointmentStatusType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $resultStatus
     * @return \StructType\EQNotifyAppResult
     */
    public function setResultStatus($resultStatus = null)
    {
        $this->ResultStatus = $resultStatus;
        return $this;
    }
    /**
     * Get ErrorCode value
     * @return int|null
     */
    public function getErrorCode()
    {
        return $this->ErrorCode;
    }
    /**
     * Set ErrorCode value
     * @param int $errorCode
     * @return \StructType\EQNotifyAppResult
     */
    public function setErrorCode($errorCode = null)
    {
        $this->ErrorCode = $errorCode;
        return $this;
    }
    /**
     * Get ErrortText value
     * @return string|null
     */
    public function getErrortText()
    {
        return $this->ErrortText;
    }
    /**
     * Set ErrortText value
     * @param string $errortText
     * @return \StructType\EQNotifyAppResult
     */
    public function setErrortText($errortText = null)
    {
        $this->ErrortText = $errortText;
        return $this;
    }
    /**
     * Get AppResult value
     * @return string|null
     */
    public function getAppResult()
    {
        return $this->AppResult;
    }
    /**
     * Set AppResult value
     * @param string $appResult
     * @return \StructType\EQNotifyAppResult
     */
    public function setAppResult($appResult = null)
    {
        $this->AppResult = $appResult;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\EQNotifyAppResult
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
