<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EQAppointmentDocResult StructType
 * Meta informations extracted from the WSDL
 * - documentation: Ответ на заявку для сервиса личного приёма
 * - type: tns:EQAppointmentDocResult
 * @subpackage Structs
 */
class EQAppointmentDocResult extends AbstractStructBase
{
    /**
     * The InternalKey
     * Meta informations extracted from the WSDL
     * - documentation: Ключ ФССП РФ | Ключ объекта, присвоенний информационной системой ФССП РФ при создании объекта или при получении объекта от
     * контрагента
     * - maxInclusive: 9223372036854775807
     * - minInclusive: -9223372036854775808
     * @var int
     */
    public $InternalKey;
    /**
     * The RequestExternalKey
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор заявки АИС ВК | Идентификатор объекта, присвоенный объекту АИС внешнего контрагентом (ФНС, ПФР и прочие). Данный
     * идентификатор должен быть уникальным для типа идентифицируемого документа в пространстве обмена данными с конкретным внешним
     * контрагентом.
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $RequestExternalKey;
    /**
     * The AppResult
     * Meta informations extracted from the WSDL
     * - documentation: Результат обработка заявки
     * - minOccurs: 0
     * @var string
     */
    public $AppResult;
    /**
     * Constructor method for EQAppointmentDocResult
     * @uses EQAppointmentDocResult::setInternalKey()
     * @uses EQAppointmentDocResult::setRequestExternalKey()
     * @uses EQAppointmentDocResult::setAppResult()
     * @param int $internalKey
     * @param string $requestExternalKey
     * @param string $appResult
     */
    public function __construct($internalKey = null, $requestExternalKey = null, $appResult = null)
    {
        $this
            ->setInternalKey($internalKey)
            ->setRequestExternalKey($requestExternalKey)
            ->setAppResult($appResult);
    }
    /**
     * Get InternalKey value
     * @return int|null
     */
    public function getInternalKey()
    {
        return $this->InternalKey;
    }
    /**
     * Set InternalKey value
     * @param int $internalKey
     * @return \StructType\EQAppointmentDocResult
     */
    public function setInternalKey($internalKey = null)
    {
        $this->InternalKey = $internalKey;
        return $this;
    }
    /**
     * Get RequestExternalKey value
     * @return string|null
     */
    public function getRequestExternalKey()
    {
        return $this->RequestExternalKey;
    }
    /**
     * Set RequestExternalKey value
     * @param string $requestExternalKey
     * @return \StructType\EQAppointmentDocResult
     */
    public function setRequestExternalKey($requestExternalKey = null)
    {
        $this->RequestExternalKey = $requestExternalKey;
        return $this;
    }
    /**
     * Get AppResult value
     * @return string|null
     */
    public function getAppResult()
    {
        return $this->AppResult;
    }
    /**
     * Set AppResult value
     * @param string $appResult
     * @return \StructType\EQAppointmentDocResult
     */
    public function setAppResult($appResult = null)
    {
        $this->AppResult = $appResult;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\EQAppointmentDocResult
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
