<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EApplicationType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Электронное обращение | Используется для передачи в ФССП России электронного обращения | ЭП
 * - type: tns:EApplicationType
 * @subpackage Structs
 */
class EApplicationType extends AbstractStructBase
{
    /**
     * The EApplicationKey
     * Meta informations extracted from the WSDL
     * - documentation: Уникальный ключ электронного заявления | Идентификатор объекта, присвоенный объекту АИС внешнего контрагентом (ФНС, ПФР и
     * прочие). Данный идентификатор должен быть уникальным для типа идентифицируемого документа в пространстве обмена данными с конкретным
     * внешним контрагентом.
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $EApplicationKey;
    /**
     * The EApplicationType
     * Meta informations extracted from the WSDL
     * - documentation: Тип заявления | Тип документа АИС ФССП России (тип документа ПКОСП) | Тип документа электронного документооборота | NSI_Document |
     * Наименование объекта NCORE
     * - maxLength: 31 | 31
     * - minLength: 1 | 1
     * @var string
     */
    public $EApplicationType;
    /**
     * The EApplicationDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата электронного заявления | Дата | Дата
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $EApplicationDate;
    /**
     * The PersonalInfromation
     * Meta informations extracted from the WSDL
     * - documentation: Сведения о Заявителе
     * @var \StructType\ContragentDatumType
     */
    public $PersonalInfromation;
    /**
     * The EApplicationBase
     * Meta informations extracted from the WSDL
     * - documentation: Электронное обращение | Электронное обращение составленный в соответствии с форматом Приложения № 3 «Форматы электронного
     * обращение» в кодировке Base64.
     * @var string
     */
    public $EApplicationBase;
    /**
     * The SignDateTime
     * Meta informations extracted from the WSDL
     * - documentation: Дата и время формирования подписи | Дата и время | Дата и время
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01T00:00:00
     * - minInclusive: 1900-01-01T00:00:00
     * @var string
     */
    public $SignDateTime;
    /**
     * The SignatureBase
     * Meta informations extracted from the WSDL
     * - documentation: ЭП электронного обращения | ЭП электронного обращения, элемента «EApplicationBase» в формате pkcs#7.
     * @var string
     */
    public $SignatureBase;
    /**
     * The Attachments
     * Meta informations extracted from the WSDL
     * - documentation: Прикрепленные файлы
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\AttachmentType[]
     */
    public $Attachments;
    /**
     * The Signature
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: ds:Signature
     * @var \StructType\SignatureType[]
     */
    public $Signature;
    /**
     * Constructor method for EApplicationType
     * @uses EApplicationType::setEApplicationKey()
     * @uses EApplicationType::setEApplicationType()
     * @uses EApplicationType::setEApplicationDate()
     * @uses EApplicationType::setPersonalInfromation()
     * @uses EApplicationType::setEApplicationBase()
     * @uses EApplicationType::setSignDateTime()
     * @uses EApplicationType::setSignatureBase()
     * @uses EApplicationType::setAttachments()
     * @uses EApplicationType::setSignature()
     * @param string $eApplicationKey
     * @param string $eApplicationType
     * @param string $eApplicationDate
     * @param \StructType\ContragentDatumType $personalInfromation
     * @param string $eApplicationBase
     * @param string $signDateTime
     * @param string $signatureBase
     * @param \StructType\AttachmentType[] $attachments
     * @param \StructType\SignatureType[] $signature
     */
    public function __construct($eApplicationKey = null, $eApplicationType = null, $eApplicationDate = null, \StructType\ContragentDatumType $personalInfromation = null, $eApplicationBase = null, $signDateTime = null, $signatureBase = null, array $attachments = array(), array $signature = array())
    {
        $this
            ->setEApplicationKey($eApplicationKey)
            ->setEApplicationType($eApplicationType)
            ->setEApplicationDate($eApplicationDate)
            ->setPersonalInfromation($personalInfromation)
            ->setEApplicationBase($eApplicationBase)
            ->setSignDateTime($signDateTime)
            ->setSignatureBase($signatureBase)
            ->setAttachments($attachments)
            ->setSignature($signature);
    }
    /**
     * Get EApplicationKey value
     * @return string|null
     */
    public function getEApplicationKey()
    {
        return $this->EApplicationKey;
    }
    /**
     * Set EApplicationKey value
     * @param string $eApplicationKey
     * @return \StructType\EApplicationType
     */
    public function setEApplicationKey($eApplicationKey = null)
    {
        $this->EApplicationKey = $eApplicationKey;
        return $this;
    }
    /**
     * Get EApplicationType value
     * @return string|null
     */
    public function getEApplicationType()
    {
        return $this->EApplicationType;
    }
    /**
     * Set EApplicationType value
     * @param string $eApplicationType
     * @return \StructType\EApplicationType
     */
    public function setEApplicationType($eApplicationType = null)
    {
        $this->EApplicationType = $eApplicationType;
        return $this;
    }
    /**
     * Get EApplicationDate value
     * @return string|null
     */
    public function getEApplicationDate()
    {
        return $this->EApplicationDate;
    }
    /**
     * Set EApplicationDate value
     * @param string $eApplicationDate
     * @return \StructType\EApplicationType
     */
    public function setEApplicationDate($eApplicationDate = null)
    {
        $this->EApplicationDate = $eApplicationDate;
        return $this;
    }
    /**
     * Get PersonalInfromation value
     * @return \StructType\ContragentDatumType|null
     */
    public function getPersonalInfromation()
    {
        return $this->PersonalInfromation;
    }
    /**
     * Set PersonalInfromation value
     * @param \StructType\ContragentDatumType $personalInfromation
     * @return \StructType\EApplicationType
     */
    public function setPersonalInfromation(\StructType\ContragentDatumType $personalInfromation = null)
    {
        $this->PersonalInfromation = $personalInfromation;
        return $this;
    }
    /**
     * Get EApplicationBase value
     * @return string|null
     */
    public function getEApplicationBase()
    {
        return $this->EApplicationBase;
    }
    /**
     * Set EApplicationBase value
     * @param string $eApplicationBase
     * @return \StructType\EApplicationType
     */
    public function setEApplicationBase($eApplicationBase = null)
    {
        $this->EApplicationBase = $eApplicationBase;
        return $this;
    }
    /**
     * Get SignDateTime value
     * @return string|null
     */
    public function getSignDateTime()
    {
        return $this->SignDateTime;
    }
    /**
     * Set SignDateTime value
     * @param string $signDateTime
     * @return \StructType\EApplicationType
     */
    public function setSignDateTime($signDateTime = null)
    {
        $this->SignDateTime = $signDateTime;
        return $this;
    }
    /**
     * Get SignatureBase value
     * @return string|null
     */
    public function getSignatureBase()
    {
        return $this->SignatureBase;
    }
    /**
     * Set SignatureBase value
     * @param string $signatureBase
     * @return \StructType\EApplicationType
     */
    public function setSignatureBase($signatureBase = null)
    {
        $this->SignatureBase = $signatureBase;
        return $this;
    }
    /**
     * Get Attachments value
     * @return \StructType\AttachmentType[]|null
     */
    public function getAttachments()
    {
        return $this->Attachments;
    }
    /**
     * Set Attachments value
     * @throws \InvalidArgumentException
     * @param \StructType\AttachmentType[] $attachments
     * @return \StructType\EApplicationType
     */
    public function setAttachments(array $attachments = array())
    {
        $this->Attachments = $attachments;
        return $this;
    }
    /**
     * Add item to Attachments value
     * @throws \InvalidArgumentException
     * @param \StructType\AttachmentType $item
     * @return \StructType\EApplicationType
     */
    public function addToAttachments(\StructType\AttachmentType $item)
    {
        $this->Attachments[] = $item;
        return $this;
    }
    /**
     * Get Signature value
     * @return \StructType\SignatureType[]|null
     */
    public function getSignature()
    {
        return $this->Signature;
    }
    /**
     * Set Signature value
     * @throws \InvalidArgumentException
     * @param \StructType\SignatureType[] $signature
     * @return \StructType\EApplicationType
     */
    public function setSignature(array $signature = array())
    {
        $this->Signature = $signature;
        return $this;
    }
    /**
     * Add item to Signature value
     * @throws \InvalidArgumentException
     * @param \StructType\SignatureType $item
     * @return \StructType\EApplicationType
     */
    public function addToSignature(\StructType\SignatureType $item)
    {
        $this->Signature[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\EApplicationType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
