<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EApplicationResultType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Ответ на электронное обращение | Используется для передачи от ФССП России внешнему контрагенту информации об ответе на
 * электронное обращение Заявителя | ЭП
 * - type: tns:EApplicationResultType
 * @subpackage Structs
 */
class EApplicationResultType extends AbstractStructBase
{
    /**
     * The EApplicationKey
     * Meta informations extracted from the WSDL
     * - documentation: Уникальный ключ электронного заявления | Идентификатор объекта, присвоенный объекту АИС внешнего контрагентом (ФНС, ПФР и
     * прочие). Данный идентификатор должен быть уникальным для типа идентифицируемого документа в пространстве обмена данными с конкретным
     * внешним контрагентом.
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $EApplicationKey;
    /**
     * The EApplicationResponseKey
     * Meta informations extracted from the WSDL
     * - documentation: Уникальный ключ ответа на электронное обращение | Ключ объекта, присвоенний информационной системой ФССП РФ при создании
     * объекта или при получении объекта от контрагента
     * - maxInclusive: 9223372036854775807
     * - minInclusive: -9223372036854775808
     * @var int
     */
    public $EApplicationResponseKey;
    /**
     * The DocNumber
     * Meta informations extracted from the WSDL
     * - documentation: Номер документа ответа на электронное обращение | Обязательно для заполнения в случае код смены статуса принимает значение
     * «COMPLETED». | Номер документа
     * - minOccurs: 0
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $DocNumber;
    /**
     * The DocDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата электронного заявления | Обязательно для заполнения в случае код смены статуса принимает значение «COMPLETED». | Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $DocDate;
    /**
     * The AppStatus
     * Meta informations extracted from the WSDL
     * - documentation: Код смены статуса заявления
     * @var string
     */
    public $AppStatus;
    /**
     * The EApplicationResponseBase
     * Meta informations extracted from the WSDL
     * - documentation: Ответ на электронное обращение | Обязательно для заполнения в случае код смены статуса принимает значение «COMPLETED». Ответ на
     * электронное обращение составленный в соответствии с форматом Приложения № 3 «Форматы электронного обращение» в кодировке Base64.
     * - minOccurs: 0
     * @var string
     */
    public $EApplicationResponseBase;
    /**
     * The SignatureBase
     * Meta informations extracted from the WSDL
     * - documentation: ЭП ответа на электронное обращение | Обязательно для заполнения в случае код смены статуса принимает значение «COMPLETED». ЭП
     * ответа электронного обращение элемента «EApplicationResponseBase» в формате pkcs#7.
     * - minOccurs: 0
     * @var string
     */
    public $SignatureBase;
    /**
     * The Attachments
     * Meta informations extracted from the WSDL
     * - documentation: Прикрепленные файлы | Дополнительные данные в произвольных форматах.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\AttachmentType[]
     */
    public $Attachments;
    /**
     * The SignDateTime
     * Meta informations extracted from the WSDL
     * - documentation: Дата и время формирования подписи | Дата и время | Дата и время
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01T00:00:00
     * - minInclusive: 1900-01-01T00:00:00
     * @var string
     */
    public $SignDateTime;
    /**
     * The Signature
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: ds:Signature
     * @var \StructType\SignatureType[]
     */
    public $Signature;
    /**
     * Constructor method for EApplicationResultType
     * @uses EApplicationResultType::setEApplicationKey()
     * @uses EApplicationResultType::setEApplicationResponseKey()
     * @uses EApplicationResultType::setDocNumber()
     * @uses EApplicationResultType::setDocDate()
     * @uses EApplicationResultType::setAppStatus()
     * @uses EApplicationResultType::setEApplicationResponseBase()
     * @uses EApplicationResultType::setSignatureBase()
     * @uses EApplicationResultType::setAttachments()
     * @uses EApplicationResultType::setSignDateTime()
     * @uses EApplicationResultType::setSignature()
     * @param string $eApplicationKey
     * @param int $eApplicationResponseKey
     * @param string $docNumber
     * @param string $docDate
     * @param string $appStatus
     * @param string $eApplicationResponseBase
     * @param string $signatureBase
     * @param \StructType\AttachmentType[] $attachments
     * @param string $signDateTime
     * @param \StructType\SignatureType[] $signature
     */
    public function __construct($eApplicationKey = null, $eApplicationResponseKey = null, $docNumber = null, $docDate = null, $appStatus = null, $eApplicationResponseBase = null, $signatureBase = null, array $attachments = array(), $signDateTime = null, array $signature = array())
    {
        $this
            ->setEApplicationKey($eApplicationKey)
            ->setEApplicationResponseKey($eApplicationResponseKey)
            ->setDocNumber($docNumber)
            ->setDocDate($docDate)
            ->setAppStatus($appStatus)
            ->setEApplicationResponseBase($eApplicationResponseBase)
            ->setSignatureBase($signatureBase)
            ->setAttachments($attachments)
            ->setSignDateTime($signDateTime)
            ->setSignature($signature);
    }
    /**
     * Get EApplicationKey value
     * @return string|null
     */
    public function getEApplicationKey()
    {
        return $this->EApplicationKey;
    }
    /**
     * Set EApplicationKey value
     * @param string $eApplicationKey
     * @return \StructType\EApplicationResultType
     */
    public function setEApplicationKey($eApplicationKey = null)
    {
        $this->EApplicationKey = $eApplicationKey;
        return $this;
    }
    /**
     * Get EApplicationResponseKey value
     * @return int|null
     */
    public function getEApplicationResponseKey()
    {
        return $this->EApplicationResponseKey;
    }
    /**
     * Set EApplicationResponseKey value
     * @param int $eApplicationResponseKey
     * @return \StructType\EApplicationResultType
     */
    public function setEApplicationResponseKey($eApplicationResponseKey = null)
    {
        $this->EApplicationResponseKey = $eApplicationResponseKey;
        return $this;
    }
    /**
     * Get DocNumber value
     * @return string|null
     */
    public function getDocNumber()
    {
        return $this->DocNumber;
    }
    /**
     * Set DocNumber value
     * @param string $docNumber
     * @return \StructType\EApplicationResultType
     */
    public function setDocNumber($docNumber = null)
    {
        $this->DocNumber = $docNumber;
        return $this;
    }
    /**
     * Get DocDate value
     * @return string|null
     */
    public function getDocDate()
    {
        return $this->DocDate;
    }
    /**
     * Set DocDate value
     * @param string $docDate
     * @return \StructType\EApplicationResultType
     */
    public function setDocDate($docDate = null)
    {
        $this->DocDate = $docDate;
        return $this;
    }
    /**
     * Get AppStatus value
     * @return string|null
     */
    public function getAppStatus()
    {
        return $this->AppStatus;
    }
    /**
     * Set AppStatus value
     * @uses \EnumType\ApplicationStatus::valueIsValid()
     * @uses \EnumType\ApplicationStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $appStatus
     * @return \StructType\EApplicationResultType
     */
    public function setAppStatus($appStatus = null)
    {
        $this->AppStatus = $appStatus;
        return $this;
    }
    /**
     * Get EApplicationResponseBase value
     * @return string|null
     */
    public function getEApplicationResponseBase()
    {
        return $this->EApplicationResponseBase;
    }
    /**
     * Set EApplicationResponseBase value
     * @param string $eApplicationResponseBase
     * @return \StructType\EApplicationResultType
     */
    public function setEApplicationResponseBase($eApplicationResponseBase = null)
    {
        $this->EApplicationResponseBase = $eApplicationResponseBase;
        return $this;
    }
    /**
     * Get SignatureBase value
     * @return string|null
     */
    public function getSignatureBase()
    {
        return $this->SignatureBase;
    }
    /**
     * Set SignatureBase value
     * @param string $signatureBase
     * @return \StructType\EApplicationResultType
     */
    public function setSignatureBase($signatureBase = null)
    {
        $this->SignatureBase = $signatureBase;
        return $this;
    }
    /**
     * Get Attachments value
     * @return \StructType\AttachmentType[]|null
     */
    public function getAttachments()
    {
        return $this->Attachments;
    }
    /**
     * Set Attachments value
     * @throws \InvalidArgumentException
     * @param \StructType\AttachmentType[] $attachments
     * @return \StructType\EApplicationResultType
     */
    public function setAttachments(array $attachments = array())
    {
        $this->Attachments = $attachments;
        return $this;
    }
    /**
     * Add item to Attachments value
     * @throws \InvalidArgumentException
     * @param \StructType\AttachmentType $item
     * @return \StructType\EApplicationResultType
     */
    public function addToAttachments(\StructType\AttachmentType $item)
    {
        $this->Attachments[] = $item;
        return $this;
    }
    /**
     * Get SignDateTime value
     * @return string|null
     */
    public function getSignDateTime()
    {
        return $this->SignDateTime;
    }
    /**
     * Set SignDateTime value
     * @param string $signDateTime
     * @return \StructType\EApplicationResultType
     */
    public function setSignDateTime($signDateTime = null)
    {
        $this->SignDateTime = $signDateTime;
        return $this;
    }
    /**
     * Get Signature value
     * @return \StructType\SignatureType[]|null
     */
    public function getSignature()
    {
        return $this->Signature;
    }
    /**
     * Set Signature value
     * @throws \InvalidArgumentException
     * @param \StructType\SignatureType[] $signature
     * @return \StructType\EApplicationResultType
     */
    public function setSignature(array $signature = array())
    {
        $this->Signature = $signature;
        return $this;
    }
    /**
     * Add item to Signature value
     * @throws \InvalidArgumentException
     * @param \StructType\SignatureType $item
     * @return \StructType\EApplicationResultType
     */
    public function addToSignature(\StructType\SignatureType $item)
    {
        $this->Signature[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\EApplicationResultType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
