<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DxNotifyDocumentType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Cобытие для документа
 * @subpackage Structs
 */
class DxNotifyDocumentType extends ObjectType
{
    /**
     * The Text
     * Meta informations extracted from the WSDL
     * - documentation: Текст сообщения
     * - minOccurs: 0
     * - maxLength: 1000
     * @var string
     */
    public $Text;
    /**
     * The SenderDocId
     * Meta informations extracted from the WSDL
     * - documentation: Ключ документа отправителя
     * - minOccurs: 0
     * - maxLength: 60
     * @var string
     */
    public $SenderDocId;
    /**
     * The ReceiverDocId
     * Meta informations extracted from the WSDL
     * - documentation: Ключ документа получателя
     * - minOccurs: 0
     * - maxLength: 60
     * @var string
     */
    public $ReceiverDocId;
    /**
     * The Event
     * Meta informations extracted from the WSDL
     * - documentation: Событие
     * - minOccurs: 0
     * - maxLength: 1000
     * @var string
     */
    public $Event;
    /**
     * Constructor method for DxNotifyDocumentType
     * @uses DxNotifyDocumentType::setText()
     * @uses DxNotifyDocumentType::setSenderDocId()
     * @uses DxNotifyDocumentType::setReceiverDocId()
     * @uses DxNotifyDocumentType::setEvent()
     * @param string $text
     * @param string $senderDocId
     * @param string $receiverDocId
     * @param string $event
     */
    public function __construct($text = null, $senderDocId = null, $receiverDocId = null, $event = null)
    {
        $this
            ->setText($text)
            ->setSenderDocId($senderDocId)
            ->setReceiverDocId($receiverDocId)
            ->setEvent($event);
    }
    /**
     * Get Text value
     * @return string|null
     */
    public function getText()
    {
        return $this->Text;
    }
    /**
     * Set Text value
     * @param string $text
     * @return \StructType\DxNotifyDocumentType
     */
    public function setText($text = null)
    {
        $this->Text = $text;
        return $this;
    }
    /**
     * Get SenderDocId value
     * @return string|null
     */
    public function getSenderDocId()
    {
        return $this->SenderDocId;
    }
    /**
     * Set SenderDocId value
     * @param string $senderDocId
     * @return \StructType\DxNotifyDocumentType
     */
    public function setSenderDocId($senderDocId = null)
    {
        $this->SenderDocId = $senderDocId;
        return $this;
    }
    /**
     * Get ReceiverDocId value
     * @return string|null
     */
    public function getReceiverDocId()
    {
        return $this->ReceiverDocId;
    }
    /**
     * Set ReceiverDocId value
     * @param string $receiverDocId
     * @return \StructType\DxNotifyDocumentType
     */
    public function setReceiverDocId($receiverDocId = null)
    {
        $this->ReceiverDocId = $receiverDocId;
        return $this;
    }
    /**
     * Get Event value
     * @return string|null
     */
    public function getEvent()
    {
        return $this->Event;
    }
    /**
     * Set Event value
     * @param string $event
     * @return \StructType\DxNotifyDocumentType
     */
    public function setEvent($event = null)
    {
        $this->Event = $event;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DxNotifyDocumentType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
