<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DocumentStatusSMEV3 StructType
 * Meta informations extracted from the WSDL
 * - documentation: Сообщение о статусе документа (СМЭВ 3)
 * - type: tns:DocumentStatusSMEV3
 * @subpackage Structs
 */
class DocumentStatusSMEV3 extends AbstractStructBase
{
    /**
     * The Id
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор сообщения о статусе | Уникальный идентификатор (ключ) сообщения о статусе в АИС контрагента | Идентификатор
     * объекта, присвоенный объекту АИС внешнего контрагентом (ФНС, ПФР и прочие). Данный идентификатор должен быть уникальным для типа
     * идентифицируемого документа в пространстве обмена данными с конкретным внешним контрагентом.
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $Id;
    /**
     * The ReferencedDocumentId
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор исходного документа отправителя | Указывается идентификатор исходного документа отправителя | Идентификатор
     * объекта, присвоенный объекту АИС внешнего контрагентом (ФНС, ПФР и прочие). Данный идентификатор должен быть уникальным для типа
     * идентифицируемого документа в пространстве обмена данными с конкретным внешним контрагентом.
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $ReferencedDocumentId;
    /**
     * The StatusDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата и время статуса документа | Дата и время | Дата и время
     * - maxExclusive: 2100-01-01T00:00:00
     * - minInclusive: 1900-01-01T00:00:00
     * @var string
     */
    public $StatusDate;
    /**
     * The StatusId
     * Meta informations extracted from the WSDL
     * - documentation: Статус документа | Указывается идентификатор статуса документа на основе справочника «Статусы документов СМЭВ3» | Статус
     * документа
     * - minInclusive: 1
     * @var int
     */
    public $StatusId;
    /**
     * The MessageText
     * Meta informations extracted from the WSDL
     * - documentation: Сообщение | В поле передается заголовок статуса или текстовый комментарий к статусу/отказу | Строка длиной от 1 до 2000 символов
     * - minOccurs: 0
     * - maxLength: 2000
     * - minLength: 1
     * @var string
     */
    public $MessageText;
    /**
     * Constructor method for DocumentStatusSMEV3
     * @uses DocumentStatusSMEV3::setId()
     * @uses DocumentStatusSMEV3::setReferencedDocumentId()
     * @uses DocumentStatusSMEV3::setStatusDate()
     * @uses DocumentStatusSMEV3::setStatusId()
     * @uses DocumentStatusSMEV3::setMessageText()
     * @param string $id
     * @param string $referencedDocumentId
     * @param string $statusDate
     * @param int $statusId
     * @param string $messageText
     */
    public function __construct($id = null, $referencedDocumentId = null, $statusDate = null, $statusId = null, $messageText = null)
    {
        $this
            ->setId($id)
            ->setReferencedDocumentId($referencedDocumentId)
            ->setStatusDate($statusDate)
            ->setStatusId($statusId)
            ->setMessageText($messageText);
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \StructType\DocumentStatusSMEV3
     */
    public function setId($id = null)
    {
        $this->Id = $id;
        return $this;
    }
    /**
     * Get ReferencedDocumentId value
     * @return string|null
     */
    public function getReferencedDocumentId()
    {
        return $this->ReferencedDocumentId;
    }
    /**
     * Set ReferencedDocumentId value
     * @param string $referencedDocumentId
     * @return \StructType\DocumentStatusSMEV3
     */
    public function setReferencedDocumentId($referencedDocumentId = null)
    {
        $this->ReferencedDocumentId = $referencedDocumentId;
        return $this;
    }
    /**
     * Get StatusDate value
     * @return string|null
     */
    public function getStatusDate()
    {
        return $this->StatusDate;
    }
    /**
     * Set StatusDate value
     * @param string $statusDate
     * @return \StructType\DocumentStatusSMEV3
     */
    public function setStatusDate($statusDate = null)
    {
        $this->StatusDate = $statusDate;
        return $this;
    }
    /**
     * Get StatusId value
     * @return int|null
     */
    public function getStatusId()
    {
        return $this->StatusId;
    }
    /**
     * Set StatusId value
     * @param int $statusId
     * @return \StructType\DocumentStatusSMEV3
     */
    public function setStatusId($statusId = null)
    {
        $this->StatusId = $statusId;
        return $this;
    }
    /**
     * Get MessageText value
     * @return string|null
     */
    public function getMessageText()
    {
        return $this->MessageText;
    }
    /**
     * Set MessageText value
     * @param string $messageText
     * @return \StructType\DocumentStatusSMEV3
     */
    public function setMessageText($messageText = null)
    {
        $this->MessageText = $messageText;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DocumentStatusSMEV3
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
