<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DocumentRef StructType
 * Meta informations extracted from the WSDL
 * - documentation: Ссылка на документ
 * @subpackage Structs
 */
class DocumentRef extends AbstractStructBase
{
    /**
     * The id
     * Meta informations extracted from the WSDL
     * - documentation: Уникальный идентификатор документа в АИС отправителя | Идентификатор объекта | Атрибут документа
     * - use: required
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $id;
    /**
     * The DocNumber
     * Meta informations extracted from the WSDL
     * - documentation: Номер документа | Номер документа
     * - minOccurs: 0
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $DocNumber;
    /**
     * The DocDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата документа | Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $DocDate;
    /**
     * The doc_type
     * Meta informations extracted from the WSDL
     * - documentation: Код типа документа | Тип документа АИС ФССП России (тип документа ПКОСП) | Тип документа электронного документооборота | NSI_Document |
     * Наименование объекта NCORE
     * - maxLength: 31 | 31
     * - minLength: 1 | 1
     * @var string
     */
    public $doc_type;
    /**
     * The env_id
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор конверта в АИС отправителя | Идентификатор объекта | Атрибут документа
     * - use: optional
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $env_id;
    /**
     * The receiver_id
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор документа в АИС получателя | Идентификатор объекта | Атрибут документа
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $receiver_id;
    /**
     * Constructor method for DocumentRef
     * @uses DocumentRef::setId()
     * @uses DocumentRef::setDocNumber()
     * @uses DocumentRef::setDocDate()
     * @uses DocumentRef::setDoc_type()
     * @uses DocumentRef::setEnv_id()
     * @uses DocumentRef::setReceiver_id()
     * @param string $id
     * @param string $docNumber
     * @param string $docDate
     * @param string $doc_type
     * @param string $env_id
     * @param string $receiver_id
     */
    public function __construct($id = null, $docNumber = null, $docDate = null, $doc_type = null, $env_id = null, $receiver_id = null)
    {
        $this
            ->setId($id)
            ->setDocNumber($docNumber)
            ->setDocDate($docDate)
            ->setDoc_type($doc_type)
            ->setEnv_id($env_id)
            ->setReceiver_id($receiver_id);
    }
    /**
     * Get id value
     * @return string
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param string $id
     * @return \StructType\DocumentRef
     */
    public function setId($id = null)
    {
        $this->id = $id;
        return $this;
    }
    /**
     * Get DocNumber value
     * @return string|null
     */
    public function getDocNumber()
    {
        return $this->DocNumber;
    }
    /**
     * Set DocNumber value
     * @param string $docNumber
     * @return \StructType\DocumentRef
     */
    public function setDocNumber($docNumber = null)
    {
        $this->DocNumber = $docNumber;
        return $this;
    }
    /**
     * Get DocDate value
     * @return string|null
     */
    public function getDocDate()
    {
        return $this->DocDate;
    }
    /**
     * Set DocDate value
     * @param string $docDate
     * @return \StructType\DocumentRef
     */
    public function setDocDate($docDate = null)
    {
        $this->DocDate = $docDate;
        return $this;
    }
    /**
     * Get doc_type value
     * @return string|null
     */
    public function getDoc_type()
    {
        return $this->doc_type;
    }
    /**
     * Set doc_type value
     * @param string $doc_type
     * @return \StructType\DocumentRef
     */
    public function setDoc_type($doc_type = null)
    {
        $this->doc_type = $doc_type;
        return $this;
    }
    /**
     * Get env_id value
     * @return string|null
     */
    public function getEnv_id()
    {
        return $this->env_id;
    }
    /**
     * Set env_id value
     * @param string $env_id
     * @return \StructType\DocumentRef
     */
    public function setEnv_id($env_id = null)
    {
        $this->env_id = $env_id;
        return $this;
    }
    /**
     * Get receiver_id value
     * @return string|null
     */
    public function getReceiver_id()
    {
        return $this->receiver_id;
    }
    /**
     * Set receiver_id value
     * @param string $receiver_id
     * @return \StructType\DocumentRef
     */
    public function setReceiver_id($receiver_id = null)
    {
        $this->receiver_id = $receiver_id;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DocumentRef
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
