<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DocumentNote StructType
 * Meta informations extracted from the WSDL
 * - documentation: Документ DocumentNote «Технологическое сообщение» | ЭП
 * @subpackage Structs
 */
class DocumentNote extends AbstractStructBase
{
    /**
     * The ExternalKey
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор АИС ВК | Идентификатор сообщения, присвоенный АИС внешнего контрагента. Уникален в рамках типа документа и
     * конкретного внешнего контрагента | Идентификатор объекта, присвоенный объекту АИС внешнего контрагентом (ФНС, ПФР и прочие). Данный
     * идентификатор должен быть уникальным для типа идентифицируемого документа в пространстве обмена данными с конкретным внешним
     * контрагентом.
     * - minOccurs: 0
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $ExternalKey;
    /**
     * The InternalKey
     * Meta informations extracted from the WSDL
     * - documentation: Ключ ФССП России | Уникальный идентификатор сообщения, присвоенный АИС ФССП России | Ключ объекта, присвоенний информационной
     * системой ФССП РФ при создании объекта или при получении объекта от контрагента
     * - minOccurs: 0
     * - maxInclusive: 9223372036854775807
     * - minInclusive: -9223372036854775808
     * @var int
     */
    public $InternalKey;
    /**
     * The TypeDoc
     * Meta informations extracted from the WSDL
     * - documentation: Тип документа | Код документа из справочника электронных документов передаваемых сторонами | Тип документа АИС ФССП России
     * (тип документа ПКОСП) | Тип документа электронного документооборота | NSI_Document | Наименование объекта NCORE
     * - minOccurs: 0
     * - maxLength: 31 | 31
     * - minLength: 1 | 1
     * @var string
     */
    public $TypeDoc;
    /**
     * The DocExternalKey
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор документа АИС ВК | Идентификатор документа, полученного ранее от АИС внешнего контрагента | Идентификатор
     * объекта, присвоенный объекту АИС внешнего контрагентом (ФНС, ПФР и прочие). Данный идентификатор должен быть уникальным для типа
     * идентифицируемого документа в пространстве обмена данными с конкретным внешним контрагентом.
     * - minOccurs: 0
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $DocExternalKey;
    /**
     * The DocInternalKey
     * Meta informations extracted from the WSDL
     * - documentation: Ключ документа ФССП РФ | Уникальный идентификатор документа, присвоенный АИС ФССП России и переданный ранее внешнему
     * контрагенту | Ключ объекта, присвоенний информационной системой ФССП РФ при создании объекта или при получении объекта от контрагента
     * - minOccurs: 0
     * - maxInclusive: 9223372036854775807
     * - minInclusive: -9223372036854775808
     * @var int
     */
    public $DocInternalKey;
    /**
     * The SpecStr
     * Meta informations extracted from the WSDL
     * - documentation: Текст сообщения | Строка длиной от 1 до 1000 символов
     * - minOccurs: 0
     * - maxLength: 1000
     * - minLength: 1
     * @var string
     */
    public $SpecStr;
    /**
     * The DateMess
     * Meta informations extracted from the WSDL
     * - documentation: Дата и время сообщения | Дата и время | Дата и время
     * - maxExclusive: 2100-01-01T00:00:00
     * - minInclusive: 1900-01-01T00:00:00
     * @var string
     */
    public $DateMess;
    /**
     * The MessCod
     * Meta informations extracted from the WSDL
     * - documentation: Код сообщения | Код сообщения из справочника кодов технологических сообщений
     * @var string
     */
    public $MessCod;
    /**
     * The SignDateTime
     * Meta informations extracted from the WSDL
     * - documentation: Дата и время формирования подписи | Дата и время | Дата и время
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01T00:00:00
     * - minInclusive: 1900-01-01T00:00:00
     * @var string
     */
    public $SignDateTime;
    /**
     * The Signature
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: ds:Signature
     * @var \StructType\SignatureType[]
     */
    public $Signature;
    /**
     * The Id
     * Meta informations extracted from the WSDL
     * - documentation: Атрибут документа | Идентификатор объекта | Атрибут документа
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $Id;
    /**
     * Constructor method for DocumentNote
     * @uses DocumentNote::setExternalKey()
     * @uses DocumentNote::setInternalKey()
     * @uses DocumentNote::setTypeDoc()
     * @uses DocumentNote::setDocExternalKey()
     * @uses DocumentNote::setDocInternalKey()
     * @uses DocumentNote::setSpecStr()
     * @uses DocumentNote::setDateMess()
     * @uses DocumentNote::setMessCod()
     * @uses DocumentNote::setSignDateTime()
     * @uses DocumentNote::setSignature()
     * @uses DocumentNote::setId()
     * @param string $externalKey
     * @param int $internalKey
     * @param string $typeDoc
     * @param string $docExternalKey
     * @param int $docInternalKey
     * @param string $specStr
     * @param string $dateMess
     * @param string $messCod
     * @param string $signDateTime
     * @param \StructType\SignatureType[] $signature
     * @param string $id
     */
    public function __construct($externalKey = null, $internalKey = null, $typeDoc = null, $docExternalKey = null, $docInternalKey = null, $specStr = null, $dateMess = null, $messCod = null, $signDateTime = null, array $signature = array(), $id = null)
    {
        $this
            ->setExternalKey($externalKey)
            ->setInternalKey($internalKey)
            ->setTypeDoc($typeDoc)
            ->setDocExternalKey($docExternalKey)
            ->setDocInternalKey($docInternalKey)
            ->setSpecStr($specStr)
            ->setDateMess($dateMess)
            ->setMessCod($messCod)
            ->setSignDateTime($signDateTime)
            ->setSignature($signature)
            ->setId($id);
    }
    /**
     * Get ExternalKey value
     * @return string|null
     */
    public function getExternalKey()
    {
        return $this->ExternalKey;
    }
    /**
     * Set ExternalKey value
     * @param string $externalKey
     * @return \StructType\DocumentNote
     */
    public function setExternalKey($externalKey = null)
    {
        $this->ExternalKey = $externalKey;
        return $this;
    }
    /**
     * Get InternalKey value
     * @return int|null
     */
    public function getInternalKey()
    {
        return $this->InternalKey;
    }
    /**
     * Set InternalKey value
     * @param int $internalKey
     * @return \StructType\DocumentNote
     */
    public function setInternalKey($internalKey = null)
    {
        $this->InternalKey = $internalKey;
        return $this;
    }
    /**
     * Get TypeDoc value
     * @return string|null
     */
    public function getTypeDoc()
    {
        return $this->TypeDoc;
    }
    /**
     * Set TypeDoc value
     * @param string $typeDoc
     * @return \StructType\DocumentNote
     */
    public function setTypeDoc($typeDoc = null)
    {
        $this->TypeDoc = $typeDoc;
        return $this;
    }
    /**
     * Get DocExternalKey value
     * @return string|null
     */
    public function getDocExternalKey()
    {
        return $this->DocExternalKey;
    }
    /**
     * Set DocExternalKey value
     * @param string $docExternalKey
     * @return \StructType\DocumentNote
     */
    public function setDocExternalKey($docExternalKey = null)
    {
        $this->DocExternalKey = $docExternalKey;
        return $this;
    }
    /**
     * Get DocInternalKey value
     * @return int|null
     */
    public function getDocInternalKey()
    {
        return $this->DocInternalKey;
    }
    /**
     * Set DocInternalKey value
     * @param int $docInternalKey
     * @return \StructType\DocumentNote
     */
    public function setDocInternalKey($docInternalKey = null)
    {
        $this->DocInternalKey = $docInternalKey;
        return $this;
    }
    /**
     * Get SpecStr value
     * @return string|null
     */
    public function getSpecStr()
    {
        return $this->SpecStr;
    }
    /**
     * Set SpecStr value
     * @param string $specStr
     * @return \StructType\DocumentNote
     */
    public function setSpecStr($specStr = null)
    {
        $this->SpecStr = $specStr;
        return $this;
    }
    /**
     * Get DateMess value
     * @return string|null
     */
    public function getDateMess()
    {
        return $this->DateMess;
    }
    /**
     * Set DateMess value
     * @param string $dateMess
     * @return \StructType\DocumentNote
     */
    public function setDateMess($dateMess = null)
    {
        $this->DateMess = $dateMess;
        return $this;
    }
    /**
     * Get MessCod value
     * @return string|null
     */
    public function getMessCod()
    {
        return $this->MessCod;
    }
    /**
     * Set MessCod value
     * @uses \EnumType\MessageCodeType::valueIsValid()
     * @uses \EnumType\MessageCodeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $messCod
     * @return \StructType\DocumentNote
     */
    public function setMessCod($messCod = null)
    {
        $this->MessCod = $messCod;
        return $this;
    }
    /**
     * Get SignDateTime value
     * @return string|null
     */
    public function getSignDateTime()
    {
        return $this->SignDateTime;
    }
    /**
     * Set SignDateTime value
     * @param string $signDateTime
     * @return \StructType\DocumentNote
     */
    public function setSignDateTime($signDateTime = null)
    {
        $this->SignDateTime = $signDateTime;
        return $this;
    }
    /**
     * Get Signature value
     * @return \StructType\SignatureType[]|null
     */
    public function getSignature()
    {
        return $this->Signature;
    }
    /**
     * Set Signature value
     * @throws \InvalidArgumentException
     * @param \StructType\SignatureType[] $signature
     * @return \StructType\DocumentNote
     */
    public function setSignature(array $signature = array())
    {
        $this->Signature = $signature;
        return $this;
    }
    /**
     * Add item to Signature value
     * @throws \InvalidArgumentException
     * @param \StructType\SignatureType $item
     * @return \StructType\DocumentNote
     */
    public function addToSignature(\StructType\SignatureType $item)
    {
        $this->Signature[] = $item;
        return $this;
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \StructType\DocumentNote
     */
    public function setId($id = null)
    {
        $this->Id = $id;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DocumentNote
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
