<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DocRefType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Ссылка на документ | Используется в составе документов для передачи сведений о логически связанных документах
 * @subpackage Structs
 */
class DocRefType extends AbstractStructBase
{
    /**
     * The DocNumber
     * Meta informations extracted from the WSDL
     * - documentation: Номер документа | Номер документа
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $DocNumber;
    /**
     * The DocDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата документа | Дата | Дата
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $DocDate;
    /**
     * The DocumentId
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор документа | Ключ объекта, присвоенний информационной системой ФССП РФ при создании объекта или при получении
     * объекта от контрагента
     * - maxInclusive: 9223372036854775807
     * - minInclusive: -9223372036854775808
     * @var int
     */
    public $DocumentId;
    /**
     * Constructor method for DocRefType
     * @uses DocRefType::setDocNumber()
     * @uses DocRefType::setDocDate()
     * @uses DocRefType::setDocumentId()
     * @param string $docNumber
     * @param string $docDate
     * @param int $documentId
     */
    public function __construct($docNumber = null, $docDate = null, $documentId = null)
    {
        $this
            ->setDocNumber($docNumber)
            ->setDocDate($docDate)
            ->setDocumentId($documentId);
    }
    /**
     * Get DocNumber value
     * @return string|null
     */
    public function getDocNumber()
    {
        return $this->DocNumber;
    }
    /**
     * Set DocNumber value
     * @param string $docNumber
     * @return \StructType\DocRefType
     */
    public function setDocNumber($docNumber = null)
    {
        $this->DocNumber = $docNumber;
        return $this;
    }
    /**
     * Get DocDate value
     * @return string|null
     */
    public function getDocDate()
    {
        return $this->DocDate;
    }
    /**
     * Set DocDate value
     * @param string $docDate
     * @return \StructType\DocRefType
     */
    public function setDocDate($docDate = null)
    {
        $this->DocDate = $docDate;
        return $this;
    }
    /**
     * Get DocumentId value
     * @return int|null
     */
    public function getDocumentId()
    {
        return $this->DocumentId;
    }
    /**
     * Set DocumentId value
     * @param int $documentId
     * @return \StructType\DocRefType
     */
    public function setDocumentId($documentId = null)
    {
        $this->DocumentId = $documentId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DocRefType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
