<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DocNoteCollection StructType
 * Meta informations extracted from the WSDL
 * - documentation: Коллекция квитанций на документы
 * @subpackage Structs
 */
class DocNoteCollection extends AbstractStructBase
{
    /**
     * The Note
     * Meta informations extracted from the WSDL
     * - documentation: Технологическое сообщение протокола обмена данными
     * - maxOccurs: unbounded
     * @var \StructType\DocNote[]
     */
    public $Note;
    /**
     * Constructor method for DocNoteCollection
     * @uses DocNoteCollection::setNote()
     * @param \StructType\DocNote[] $note
     */
    public function __construct(array $note = array())
    {
        $this
            ->setNote($note);
    }
    /**
     * Get Note value
     * @return \StructType\DocNote[]|null
     */
    public function getNote()
    {
        return $this->Note;
    }
    /**
     * Set Note value
     * @throws \InvalidArgumentException
     * @param \StructType\DocNote[] $note
     * @return \StructType\DocNoteCollection
     */
    public function setNote(array $note = array())
    {
        $this->Note = $note;
        return $this;
    }
    /**
     * Add item to Note value
     * @throws \InvalidArgumentException
     * @param \StructType\DocNote $item
     * @return \StructType\DocNoteCollection
     */
    public function addToNote(\StructType\DocNote $item)
    {
        $this->Note[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DocNoteCollection
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
