<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Direction StructType
 * Meta informations extracted from the WSDL
 * - documentation: Направление передачи данных
 * @subpackage Structs
 */
class Direction extends AbstractStructBase
{
    /**
     * The Sender
     * Meta informations extracted from the WSDL
     * - documentation: Отправитель
     * @var \StructType\RedAddress
     */
    public $Sender;
    /**
     * The Recipient
     * Meta informations extracted from the WSDL
     * - documentation: Получатель
     * @var \StructType\RedAddress
     */
    public $Recipient;
    /**
     * The Protocol
     * Meta informations extracted from the WSDL
     * - documentation: Протокол | Код протокола
     * - maxLength: 20
     * - minLength: 1
     * @var string
     */
    public $Protocol;
    /**
     * Constructor method for Direction
     * @uses Direction::setSender()
     * @uses Direction::setRecipient()
     * @uses Direction::setProtocol()
     * @param \StructType\RedAddress $sender
     * @param \StructType\RedAddress $recipient
     * @param string $protocol
     */
    public function __construct(\StructType\RedAddress $sender = null, \StructType\RedAddress $recipient = null, $protocol = null)
    {
        $this
            ->setSender($sender)
            ->setRecipient($recipient)
            ->setProtocol($protocol);
    }
    /**
     * Get Sender value
     * @return \StructType\RedAddress|null
     */
    public function getSender()
    {
        return $this->Sender;
    }
    /**
     * Set Sender value
     * @param \StructType\RedAddress $sender
     * @return \StructType\Direction
     */
    public function setSender(\StructType\RedAddress $sender = null)
    {
        $this->Sender = $sender;
        return $this;
    }
    /**
     * Get Recipient value
     * @return \StructType\RedAddress|null
     */
    public function getRecipient()
    {
        return $this->Recipient;
    }
    /**
     * Set Recipient value
     * @param \StructType\RedAddress $recipient
     * @return \StructType\Direction
     */
    public function setRecipient(\StructType\RedAddress $recipient = null)
    {
        $this->Recipient = $recipient;
        return $this;
    }
    /**
     * Get Protocol value
     * @return string|null
     */
    public function getProtocol()
    {
        return $this->Protocol;
    }
    /**
     * Set Protocol value
     * @param string $protocol
     * @return \StructType\Direction
     */
    public function setProtocol($protocol = null)
    {
        $this->Protocol = $protocol;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Direction
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
