<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DebtorIpNotify StructType
 * Meta informations extracted from the WSDL
 * - documentation: Документ DebtorIpNotify «Информация об уведомлении должника о возбуждении ИП» | ЭП
 * - type: tns:DebtorIpNotify
 * @subpackage Structs
 */
class DebtorIpNotify extends AbstractStructBase
{
    /**
     * The ExternalKey
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор АИС ВК | Идентификатор объекта, присвоенный объекту АИС внешнего контрагентом (ФНС, ПФР и прочие). Данный
     * идентификатор должен быть уникальным для типа идентифицируемого документа в пространстве обмена данными с конкретным внешним
     * контрагентом.
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $ExternalKey;
    /**
     * The MessageInternalKey
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор сообщения АИС ФССП России | Ключ объекта, присвоенний информационной системой ФССП РФ при создании объекта или
     * при получении объекта от контрагента
     * - minOccurs: 0
     * - maxInclusive: 9223372036854775807
     * - minInclusive: -9223372036854775808
     * @var int
     */
    public $MessageInternalKey;
    /**
     * The IpNumber
     * Meta informations extracted from the WSDL
     * - documentation: Номер ИП | Номер документа
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $IpNumber;
    /**
     * The NotifyState
     * Meta informations extracted from the WSDL
     * - documentation: Состояние отправки сообщения
     * @var string
     */
    public $NotifyState;
    /**
     * The Comment
     * Meta informations extracted from the WSDL
     * - documentation: Комментарий | Строка длиной от 1 до 300 символов
     * - minOccurs: 0
     * - maxLength: 300
     * - minLength: 1
     * @var string
     */
    public $Comment;
    /**
     * The NotifyTimestamp
     * Meta informations extracted from the WSDL
     * - documentation: Дата и время уведомления | Дата и время | Дата и время
     * - maxExclusive: 2100-01-01T00:00:00
     * - minInclusive: 1900-01-01T00:00:00
     * @var string
     */
    public $NotifyTimestamp;
    /**
     * The NotifyType
     * Meta informations extracted from the WSDL
     * - documentation: Способ уведомления
     * @var string
     */
    public $NotifyType;
    /**
     * The Data
     * Meta informations extracted from the WSDL
     * - documentation: Сведения
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Data[]
     */
    public $Data;
    /**
     * The Attachments
     * Meta informations extracted from the WSDL
     * - documentation: Прикрепленные файлы
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\AttachmentType[]
     */
    public $Attachments;
    /**
     * The SignDateTime
     * Meta informations extracted from the WSDL
     * - documentation: Дата и время формирования подписи | Дата и время | Дата и время
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01T00:00:00
     * - minInclusive: 1900-01-01T00:00:00
     * @var string
     */
    public $SignDateTime;
    /**
     * The Signature
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: ds:Signature
     * @var \StructType\SignatureType[]
     */
    public $Signature;
    /**
     * The Id
     * Meta informations extracted from the WSDL
     * - documentation: Атрибут документа | Идентификатор объекта | Атрибут документа
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $Id;
    /**
     * Constructor method for DebtorIpNotify
     * @uses DebtorIpNotify::setExternalKey()
     * @uses DebtorIpNotify::setMessageInternalKey()
     * @uses DebtorIpNotify::setIpNumber()
     * @uses DebtorIpNotify::setNotifyState()
     * @uses DebtorIpNotify::setComment()
     * @uses DebtorIpNotify::setNotifyTimestamp()
     * @uses DebtorIpNotify::setNotifyType()
     * @uses DebtorIpNotify::setData()
     * @uses DebtorIpNotify::setAttachments()
     * @uses DebtorIpNotify::setSignDateTime()
     * @uses DebtorIpNotify::setSignature()
     * @uses DebtorIpNotify::setId()
     * @param string $externalKey
     * @param int $messageInternalKey
     * @param string $ipNumber
     * @param string $notifyState
     * @param string $comment
     * @param string $notifyTimestamp
     * @param string $notifyType
     * @param \StructType\Data[] $data
     * @param \StructType\AttachmentType[] $attachments
     * @param string $signDateTime
     * @param \StructType\SignatureType[] $signature
     * @param string $id
     */
    public function __construct($externalKey = null, $messageInternalKey = null, $ipNumber = null, $notifyState = null, $comment = null, $notifyTimestamp = null, $notifyType = null, array $data = array(), array $attachments = array(), $signDateTime = null, array $signature = array(), $id = null)
    {
        $this
            ->setExternalKey($externalKey)
            ->setMessageInternalKey($messageInternalKey)
            ->setIpNumber($ipNumber)
            ->setNotifyState($notifyState)
            ->setComment($comment)
            ->setNotifyTimestamp($notifyTimestamp)
            ->setNotifyType($notifyType)
            ->setData($data)
            ->setAttachments($attachments)
            ->setSignDateTime($signDateTime)
            ->setSignature($signature)
            ->setId($id);
    }
    /**
     * Get ExternalKey value
     * @return string|null
     */
    public function getExternalKey()
    {
        return $this->ExternalKey;
    }
    /**
     * Set ExternalKey value
     * @param string $externalKey
     * @return \StructType\DebtorIpNotify
     */
    public function setExternalKey($externalKey = null)
    {
        $this->ExternalKey = $externalKey;
        return $this;
    }
    /**
     * Get MessageInternalKey value
     * @return int|null
     */
    public function getMessageInternalKey()
    {
        return $this->MessageInternalKey;
    }
    /**
     * Set MessageInternalKey value
     * @param int $messageInternalKey
     * @return \StructType\DebtorIpNotify
     */
    public function setMessageInternalKey($messageInternalKey = null)
    {
        $this->MessageInternalKey = $messageInternalKey;
        return $this;
    }
    /**
     * Get IpNumber value
     * @return string|null
     */
    public function getIpNumber()
    {
        return $this->IpNumber;
    }
    /**
     * Set IpNumber value
     * @param string $ipNumber
     * @return \StructType\DebtorIpNotify
     */
    public function setIpNumber($ipNumber = null)
    {
        $this->IpNumber = $ipNumber;
        return $this;
    }
    /**
     * Get NotifyState value
     * @return string|null
     */
    public function getNotifyState()
    {
        return $this->NotifyState;
    }
    /**
     * Set NotifyState value
     * @uses \EnumType\NotifyStateCodeType::valueIsValid()
     * @uses \EnumType\NotifyStateCodeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $notifyState
     * @return \StructType\DebtorIpNotify
     */
    public function setNotifyState($notifyState = null)
    {
        $this->NotifyState = $notifyState;
        return $this;
    }
    /**
     * Get Comment value
     * @return string|null
     */
    public function getComment()
    {
        return $this->Comment;
    }
    /**
     * Set Comment value
     * @param string $comment
     * @return \StructType\DebtorIpNotify
     */
    public function setComment($comment = null)
    {
        $this->Comment = $comment;
        return $this;
    }
    /**
     * Get NotifyTimestamp value
     * @return string|null
     */
    public function getNotifyTimestamp()
    {
        return $this->NotifyTimestamp;
    }
    /**
     * Set NotifyTimestamp value
     * @param string $notifyTimestamp
     * @return \StructType\DebtorIpNotify
     */
    public function setNotifyTimestamp($notifyTimestamp = null)
    {
        $this->NotifyTimestamp = $notifyTimestamp;
        return $this;
    }
    /**
     * Get NotifyType value
     * @return string|null
     */
    public function getNotifyType()
    {
        return $this->NotifyType;
    }
    /**
     * Set NotifyType value
     * @uses \EnumType\DebtorNotifyType::valueIsValid()
     * @uses \EnumType\DebtorNotifyType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $notifyType
     * @return \StructType\DebtorIpNotify
     */
    public function setNotifyType($notifyType = null)
    {
        $this->NotifyType = $notifyType;
        return $this;
    }
    /**
     * Get Data value
     * @return \StructType\Data[]|null
     */
    public function getData()
    {
        return $this->Data;
    }
    /**
     * Set Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Data[] $data
     * @return \StructType\DebtorIpNotify
     */
    public function setData(array $data = array())
    {
        $this->Data = $data;
        return $this;
    }
    /**
     * Add item to Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Data $item
     * @return \StructType\DebtorIpNotify
     */
    public function addToData(\StructType\Data $item)
    {
        $this->Data[] = $item;
        return $this;
    }
    /**
     * Get Attachments value
     * @return \StructType\AttachmentType[]|null
     */
    public function getAttachments()
    {
        return $this->Attachments;
    }
    /**
     * Set Attachments value
     * @throws \InvalidArgumentException
     * @param \StructType\AttachmentType[] $attachments
     * @return \StructType\DebtorIpNotify
     */
    public function setAttachments(array $attachments = array())
    {
        $this->Attachments = $attachments;
        return $this;
    }
    /**
     * Add item to Attachments value
     * @throws \InvalidArgumentException
     * @param \StructType\AttachmentType $item
     * @return \StructType\DebtorIpNotify
     */
    public function addToAttachments(\StructType\AttachmentType $item)
    {
        $this->Attachments[] = $item;
        return $this;
    }
    /**
     * Get SignDateTime value
     * @return string|null
     */
    public function getSignDateTime()
    {
        return $this->SignDateTime;
    }
    /**
     * Set SignDateTime value
     * @param string $signDateTime
     * @return \StructType\DebtorIpNotify
     */
    public function setSignDateTime($signDateTime = null)
    {
        $this->SignDateTime = $signDateTime;
        return $this;
    }
    /**
     * Get Signature value
     * @return \StructType\SignatureType[]|null
     */
    public function getSignature()
    {
        return $this->Signature;
    }
    /**
     * Set Signature value
     * @throws \InvalidArgumentException
     * @param \StructType\SignatureType[] $signature
     * @return \StructType\DebtorIpNotify
     */
    public function setSignature(array $signature = array())
    {
        $this->Signature = $signature;
        return $this;
    }
    /**
     * Add item to Signature value
     * @throws \InvalidArgumentException
     * @param \StructType\SignatureType $item
     * @return \StructType\DebtorIpNotify
     */
    public function addToSignature(\StructType\SignatureType $item)
    {
        $this->Signature[] = $item;
        return $this;
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \StructType\DebtorIpNotify
     */
    public function setId($id = null)
    {
        $this->Id = $id;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DebtorIpNotify
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
